#include <QtCore/QtGlobal>
#include <QtOpenGL/qopenglversionprofile.h>
#include <QtCore/QVariant>
#include <QtCore/qcontainerfwd.h>
#include <QtGui/qsurfaceformat.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QOpenGLVersionProfile(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QOpenGLVersionProfile")
    QOpenGLVersionProfile *_ptr = reinterpret_cast<QOpenGLVersionProfile *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QOpenGLVersionProfile()
void __qt_construct_QOpenGLVersionProfile(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLVersionProfile()")
    Q_UNUSED(__java_arguments)
    QOpenGLVersionProfile *__qt_this = new(__qtjambi_ptr) QOpenGLVersionProfile();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QOpenGLVersionProfile::QOpenGLVersionProfile()
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_initialize_1native__Lio_qt_opengl_QOpenGLVersionProfile_2
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLVersionProfile::QOpenGLVersionProfile()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLVersionProfile, sizeof(QOpenGLVersionProfile), typeid(QOpenGLVersionProfile), 0, false, &deleter_QOpenGLVersionProfile, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLVersionProfile(QOpenGLVersionProfile)
void __qt_construct_QOpenGLVersionProfile_cref_QOpenGLVersionProfile(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLVersionProfile(QOpenGLVersionProfile)")
    jobject other0 = __java_arguments[0].l;
    const QOpenGLVersionProfile& __qt_other0 = qtjambi_cast<const QOpenGLVersionProfile&>(__jni_env, other0);
    QOpenGLVersionProfile *__qt_this = new(__qtjambi_ptr) QOpenGLVersionProfile(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QOpenGLVersionProfile::QOpenGLVersionProfile(QOpenGLVersionProfile)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_initialize_1native__Lio_qt_opengl_QOpenGLVersionProfile_2Lio_qt_opengl_QOpenGLVersionProfile_2
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLVersionProfile::QOpenGLVersionProfile(QOpenGLVersionProfile)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLVersionProfile_cref_QOpenGLVersionProfile, sizeof(QOpenGLVersionProfile), typeid(QOpenGLVersionProfile), 0, false, &deleter_QOpenGLVersionProfile, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLVersionProfile(QSurfaceFormat)
void __qt_construct_QOpenGLVersionProfile_cref_QSurfaceFormat(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLVersionProfile(QSurfaceFormat)")
    jobject format0 = __java_arguments[0].l;
    const QSurfaceFormat& __qt_format0 = qtjambi_cast<const QSurfaceFormat&>(__jni_env, format0);
    QOpenGLVersionProfile *__qt_this = new(__qtjambi_ptr) QOpenGLVersionProfile(__qt_format0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QOpenGLVersionProfile::QOpenGLVersionProfile(QSurfaceFormat)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_initialize_1native__Lio_qt_opengl_QOpenGLVersionProfile_2Lio_qt_gui_QSurfaceFormat_2
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject format0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLVersionProfile::QOpenGLVersionProfile(QSurfaceFormat)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = format0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLVersionProfile_cref_QSurfaceFormat, sizeof(QOpenGLVersionProfile), typeid(QOpenGLVersionProfile), 0, false, &deleter_QOpenGLVersionProfile, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QOpenGLVersionProfile
void __qt_destruct_QOpenGLVersionProfile(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QOpenGLVersionProfile")
    reinterpret_cast<QOpenGLVersionProfile*>(ptr)->~QOpenGLVersionProfile();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QOpenGLVersionProfile::hasProfiles()const
extern "C" JNIEXPORT jboolean JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_hasProfiles_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLVersionProfile::hasProfiles()const", __this_nativeId)
        __java_return_value = __qt_this->hasProfiles();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLVersionProfile::isLegacyVersion()const
extern "C" JNIEXPORT jboolean JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_isLegacyVersion_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLVersionProfile::isLegacyVersion()const", __this_nativeId)
        __java_return_value = __qt_this->isLegacyVersion();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLVersionProfile::isValid()const
extern "C" JNIEXPORT jboolean JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_isValid_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLVersionProfile::isValid()const", __this_nativeId)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLVersionProfile::operator=(QOpenGLVersionProfile)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_assign_1native_1cref_1QOpenGLVersionProfile__JJ
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLVersionProfile::operator=(QOpenGLVersionProfile)", __this_nativeId)
        const QOpenGLVersionProfile& __qt_rhs0 = QtJambiAPI::valueReferenceFromNativeId<QOpenGLVersionProfile>(rhs0);
        (*__qt_this) = __qt_rhs0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLVersionProfile::operator==(QOpenGLVersionProfile,QOpenGLVersionProfile)
extern "C" JNIEXPORT jboolean JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_equals_1native_1cref_1QOpenGLVersionProfile__JJ
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLVersionProfile::operator==(QOpenGLVersionProfile,QOpenGLVersionProfile)", __this_nativeId)
        const QOpenGLVersionProfile& __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QOpenGLVersionProfile>(rhs1);
        __java_return_value = (*__qt_this) == __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLVersionProfile::profile()const
extern "C" JNIEXPORT jint JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_profile_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLVersionProfile::profile()const", __this_nativeId)
        QSurfaceFormat::OpenGLContextProfile __qt_return_value = __qt_this->profile();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLVersionProfile::setProfile(QSurfaceFormat::OpenGLContextProfile)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_setProfile_1native_1QSurfaceFormat_1OpenGLContextProfile__JI
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint profile0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLVersionProfile::setProfile(QSurfaceFormat::OpenGLContextProfile)", __this_nativeId)
        QSurfaceFormat::OpenGLContextProfile __qt_profile0 = qtjambi_cast<QSurfaceFormat::OpenGLContextProfile>(__jni_env, profile0);
        __qt_this->setProfile(QSurfaceFormat::OpenGLContextProfile(__qt_profile0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLVersionProfile::setVersion(int,int)
extern "C" JNIEXPORT void JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_setVersion_1native_1int_1int__JII
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint majorVersion0,
 jint minorVersion1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLVersionProfile::setVersion(int,int)", __this_nativeId)
        __qt_this->setVersion(static_cast<int>(majorVersion0), static_cast<int>(minorVersion1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLVersionProfile::version()const
extern "C" JNIEXPORT jobject JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_version_1native_1constfct__J
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLVersionProfile::version()const", __this_nativeId)
        QPair<int, int> __qt_return_value = __qt_this->version();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" JNIEXPORT jint JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_hashCode_1native
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" JNIEXPORT jstring JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_toString_1native(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" JNIEXPORT jobject JNICALL Java_io_qt_opengl_QOpenGLVersionProfile_clone_1native
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QOpenGLVersionProfile *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLVersionProfile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QOpenGLVersionProfile(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QOpenGLVersionProfile>("QOpenGLVersionProfile", "io/qt/opengl/QOpenGLVersionProfile");
    Q_UNUSED(typeId)
    registerConstructorInfos(typeId, 0, &__qt_destruct_QOpenGLVersionProfile, {
        ConstructorInfo{&__qt_construct_QOpenGLVersionProfile, nullptr}
       ,ConstructorInfo{&__qt_construct_QOpenGLVersionProfile_cref_QOpenGLVersionProfile, "Lio/qt/opengl/QOpenGLVersionProfile;"}
       ,ConstructorInfo{&__qt_construct_QOpenGLVersionProfile_cref_QSurfaceFormat, "Lio/qt/gui/QSurfaceFormat;"}
    });
    registerDeleter(typeId, &deleter_QOpenGLVersionProfile);
    registerMetaType<QOpenGLVersionProfile>("QOpenGLVersionProfile");
}
