#include <QtCore/QtGlobal>
#include <QtOpenGL/qopengldebug.h>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambiOpenGL/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QOpenGLDebugMessage(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QOpenGLDebugMessage")
    QOpenGLDebugMessage *_ptr = reinterpret_cast<QOpenGLDebugMessage *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QOpenGLDebugMessage()
void __qt_construct_QOpenGLDebugMessage_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLDebugMessage()")
    Q_UNUSED(__java_arguments)
    QOpenGLDebugMessage *__qt_this = new(__qtjambi_ptr) QOpenGLDebugMessage();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QOpenGLDebugMessage(QOpenGLDebugMessage)
void __qt_construct_QOpenGLDebugMessage_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLDebugMessage(QOpenGLDebugMessage)")
    jobject debugMessage0 = __java_arguments[0].l;
    const QOpenGLDebugMessage& __qt_debugMessage0 = qtjambi_cast<const QOpenGLDebugMessage& >(__jni_env, debugMessage0);
    QOpenGLDebugMessage *__qt_this = new(__qtjambi_ptr) QOpenGLDebugMessage(__qt_debugMessage0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QOpenGLDebugMessage
void __qt_destruct_QOpenGLDebugMessage(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QOpenGLDebugMessage")
    reinterpret_cast<QOpenGLDebugMessage*>(ptr)->~QOpenGLDebugMessage();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QOpenGLDebugMessage::QOpenGLDebugMessage()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_initialize_1native__Lio_qt_opengl_QOpenGLDebugMessage_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLDebugMessage::QOpenGLDebugMessage()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLDebugMessage_0, sizeof(QOpenGLDebugMessage), typeid(QOpenGLDebugMessage), false, &deleter_QOpenGLDebugMessage, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLDebugMessage::QOpenGLDebugMessage(QOpenGLDebugMessage)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_initialize_1native__Lio_qt_opengl_QOpenGLDebugMessage_2Lio_qt_opengl_QOpenGLDebugMessage_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject debugMessage0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLDebugMessage::QOpenGLDebugMessage(QOpenGLDebugMessage)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = debugMessage0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLDebugMessage_1, sizeof(QOpenGLDebugMessage), typeid(QOpenGLDebugMessage), false, &deleter_QOpenGLDebugMessage, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLDebugMessage::id()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_id_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLDebugMessage::id()const", __qt_this)
        GLuint __qt_return_value = __qt_this->id();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLDebugMessage::message()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_message_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLDebugMessage::message()const", __qt_this)
        QString __qt_return_value = __qt_this->message();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLDebugMessage::operator=(QOpenGLDebugMessage)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_assign_1native_1cref_1QOpenGLDebugMessage__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID debugMessage0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLDebugMessage::operator=(QOpenGLDebugMessage)", __qt_this)
        const QOpenGLDebugMessage& __qt_debugMessage0 = QtJambiAPI::valueReferenceFromNativeId<QOpenGLDebugMessage>(debugMessage0);
        (*__qt_this) = __qt_debugMessage0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLDebugMessage::operator==(QOpenGLDebugMessage)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_operator_1equal_1native_1cref_1QOpenGLDebugMessage_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID debugMessage0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLDebugMessage::operator==(QOpenGLDebugMessage)const", __qt_this)
        const QOpenGLDebugMessage& __qt_debugMessage0 = QtJambiAPI::valueReferenceFromNativeId<QOpenGLDebugMessage>(debugMessage0);
        __java_return_value = (*__qt_this) == __qt_debugMessage0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLDebugMessage::severity()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_severity_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLDebugMessage::severity()const", __qt_this)
        QOpenGLDebugMessage::Severity __qt_return_value = __qt_this->severity();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLDebugMessage::source()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_source_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLDebugMessage::source()const", __qt_this)
        QOpenGLDebugMessage::Source __qt_return_value = __qt_this->source();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLDebugMessage::swap(QOpenGLDebugMessage&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_swap_1native_1ref_1QOpenGLDebugMessage__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLDebugMessage::swap(QOpenGLDebugMessage&)", __qt_this)
        QOpenGLDebugMessage& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QOpenGLDebugMessage>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLDebugMessage::type()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_type_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLDebugMessage::type()const", __qt_this)
        QOpenGLDebugMessage::Type __qt_return_value = __qt_this->type();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLDebugMessage::createApplicationMessage(QString,GLuint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_createApplicationMessage_1native_1cref_1QString_1GLuint_1QOpenGLDebugMessage_1Severity_1QOpenGLDebugMessage_1Type__Ljava_lang_String_2III)
(JNIEnv *__jni_env,
 jclass,
 jstring text0,
 jint id1,
 jint severity2,
 jint type3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLDebugMessage::createApplicationMessage(QString,GLuint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_text0 = qtjambi_cast<QString>(__jni_env, text0);
        QOpenGLDebugMessage::Severity __qt_severity2 = qtjambi_cast<QOpenGLDebugMessage::Severity>(__jni_env, severity2);
        QOpenGLDebugMessage::Type __qt_type3 = qtjambi_cast<QOpenGLDebugMessage::Type>(__jni_env, type3);
        QOpenGLDebugMessage __qt_return_value = QOpenGLDebugMessage::createApplicationMessage(__qt_text0, static_cast<GLuint>(id1), QOpenGLDebugMessage::Severity(__qt_severity2), QOpenGLDebugMessage::Type(__qt_type3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLDebugMessage::createThirdPartyMessage(QString,GLuint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_createThirdPartyMessage_1native_1cref_1QString_1GLuint_1QOpenGLDebugMessage_1Severity_1QOpenGLDebugMessage_1Type__Ljava_lang_String_2III)
(JNIEnv *__jni_env,
 jclass,
 jstring text0,
 jint id1,
 jint severity2,
 jint type3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLDebugMessage::createThirdPartyMessage(QString,GLuint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_text0 = qtjambi_cast<QString>(__jni_env, text0);
        QOpenGLDebugMessage::Severity __qt_severity2 = qtjambi_cast<QOpenGLDebugMessage::Severity>(__jni_env, severity2);
        QOpenGLDebugMessage::Type __qt_type3 = qtjambi_cast<QOpenGLDebugMessage::Type>(__jni_env, type3);
        QOpenGLDebugMessage __qt_return_value = QOpenGLDebugMessage::createThirdPartyMessage(__qt_text0, static_cast<GLuint>(id1), QOpenGLDebugMessage::Severity(__qt_severity2), QOpenGLDebugMessage::Type(__qt_type3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_opengl_QOpenGLDebugMessage_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QOpenGLDebugMessage *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLDebugMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QOpenGLDebugMessage(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QOpenGLDebugMessage>("QOpenGLDebugMessage", "io/qt/opengl/QOpenGLDebugMessage");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QOpenGLDebugMessage, {
        ConstructorInfo(&__qt_construct_QOpenGLDebugMessage_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QOpenGLDebugMessage_1, "Lio/qt/opengl/QOpenGLDebugMessage;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QOpenGLDebugMessage);
    registerMetaType<QOpenGLDebugMessage>("QOpenGLDebugMessage");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QOpenGLDebugMessage::Severity>("QOpenGLDebugMessage::Severity", "io/qt/opengl/QOpenGLDebugMessage$Severity", "QOpenGLDebugMessage::Severities", "QFlags<QOpenGLDebugMessage::Severity>", "io/qt/opengl/QOpenGLDebugMessage$Severities");
    registerEnumTypeInfo<QOpenGLDebugMessage::Source>("QOpenGLDebugMessage::Source", "io/qt/opengl/QOpenGLDebugMessage$Source", "QOpenGLDebugMessage::Sources", "QFlags<QOpenGLDebugMessage::Source>", "io/qt/opengl/QOpenGLDebugMessage$Sources");
    registerEnumTypeInfo<QOpenGLDebugMessage::Type>("QOpenGLDebugMessage::Type", "io/qt/opengl/QOpenGLDebugMessage$Type", "QOpenGLDebugMessage::Types", "QFlags<QOpenGLDebugMessage::Type>", "io/qt/opengl/QOpenGLDebugMessage$Types");
// END: enums and flags
}
