package io.pythagoras.messagebus.core.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "messagebus")
public class MessageBusProperties {

    private boolean enabled = true;
    private boolean sendEnabled = true;
    private boolean receiveEnabled = true;

    private int outboundThreadCount = 3;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = ("true" == enabled.toLowerCase());
    }

    public boolean isSendEnabled() {
        return sendEnabled;
    }

    public void setSendEnabled(boolean sendEnabled) {
        this.sendEnabled = sendEnabled;
    }

    public boolean isReceiveEnabled() {
        return receiveEnabled;
    }

    public void setReceiveEnabled(boolean receiveEnabled) {
        this.receiveEnabled = receiveEnabled;
    }

    public int getOutboundThreadCount() {
        return outboundThreadCount;
    }

    public void setOutboundThreadCount(int outboundThreadCount) {
        this.outboundThreadCount = outboundThreadCount;
    }
}
