package io.pythagoras.messagebus.core;

import io.pythagoras.messagebus.annotations.MessageBusAdapter;
import io.pythagoras.messagebus.core.config.MessageBusProperties;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Collection;

@Component
public class MessageBusAdapterProvider implements ApplicationContextAware {

    private ApplicationContext context;

    private IMessageBusAdapter adapter;

    private Boolean enabled;

    public MessageBusAdapterProvider(MessageBusProperties properties) {
        this.enabled = properties.isEnabled();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @PostConstruct
    public void init() {
        this.load();
    }

    public IMessageBusAdapter getAdapter() {
        return this.adapter;
    }

    private void load() throws MessageBusInitializationException {

        if(!enabled) {
            return;
        }

        Collection<Object> objs = this.context.getBeansWithAnnotation(MessageBusAdapter.class).values();

        if (objs.size() != 1) {
            throw new MessageBusInitializationException("There must be exactly one MessageBusAdapter. " + objs.size() + " found.");
        }

        Object o = objs.toArray()[0];

        // Get the class
        Class<IMessageBusAdapter> cl = (Class<IMessageBusAdapter>) o.getClass();

        if (!(IMessageBusAdapter.class.isAssignableFrom(cl))) {
            throw new MessageBusInitializationException("Class '" + cl.getName() + "' must implement IMessageContract.");
        }

        // Make sure it can be built
        IMessageBusAdapter handler = this.context.getBean(cl);

        this.adapter = handler;

    }

}
