package io.pythagoras.messagebus.core;

public interface IMessageBus {

    /**
     * Handles a generic message coming in from the message Bus, and converts it into the
     * specific contract types and dispatches it.
     * @param busMessage The message being received.
     * @throws HandleMessageFailureException When the handling of the message fails.
     */
    void receiveMessage(IBusMessage busMessage) throws HandleMessageFailureException;

    /**
     * Takes the specific message, turns it into a generic message, and send to the message bus. ASYNC
     * @param message the message to send
     * @throws MessageSendingException When there is a failure in sending.
     */
    void sendMessage(IMessageContract message) throws MessageSendingException;

    /**
     * Takes the specific message, turns it into a generic message, and send to the message bus. BLOCKING
     * @param message the message to send
     * @throws MessageSendingException When there is a failure in sending.
     */
    void sendBlockingMessage(IMessageContract message) throws MessageSendingException;

    /**
     * Disables the message bus.  If already disabled, then it does nothing.  Will no longer send or receive messages.
     * @throws MessageBusStateException When it is unable to result in a disabled state.
     */
    void disableMessageBus() throws MessageBusStateException;

    /**
     * Enables the message bus.  If already enabled then it does nothing.  Will go through reinitialization
     * of queues and topics which makes this an expensive call.
     * @throws MessageBusStateException
     */
    void enableMessageBus() throws MessageBusStateException;

    /**
     * Allows the queue depth to be checked before additional messages are sent.
     * @return
     */
    int getOutboundWorkQueueSize();
}
