package io.pythagoras.messagebus.core;

public interface IMessageHandler<A extends IMessageContract> {

    Class<A> getAllowedClass();

    boolean allowedVersion(Integer version);

    /**
     * Because all 3 handle methods will be called (other 2 are in IMessageHandler2, if available), you should
     * only have one method do any real work.  Others can just `return;`
     * @param message
     * @throws HandleMessageFailureException
     */
    void handleMessage(A message) throws HandleMessageFailureException;
}
