package io.pythagoras.messagebus.annotations;


import org.springframework.stereotype.Component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation should be added to any class which implements the IMessageBusAdapter interface so it
 * is loaded and wired into the bus system.
 */

@Component
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface MessageBusAdapter {

}
