package io.pythagoras.messagebus.core;

import java.util.Date;

public interface IMessageHandler2<A extends IMessageContract> extends IMessageHandler<A> {

    /**
     * Because all 3 handle methods will be called, you should only have one method do any real work.  Others can just `return;`
     * @param message
     * @param sentTime
     * @throws HandleMessageFailureException
     */
    void handleMessage(A message, Date sentTime) throws HandleMessageFailureException;

    /**
     * Because all 3 handle methods will be called, you should only have one method do any real work.  Others can just `return;`
     * @param messageBody
     * @param sentTime
     * @throws HandleMessageFailureException
     */
    void handleRawMessage(String messageBody, Date sentTime) throws HandleMessageFailureException;
}
