package io.pythagoras.messagebus.core;

import java.util.List;

public interface IMessageBusAdapter {

    /**
     *
     * @param messageCodes The codes for all the messages in scope (Exchanges)
     * @param handlerCodes The codes the there are handlers for (Exchanges we need a queue which we are subscribed to)
     * @throws MessageBusInitializationException On failure to initialize
     */
    public void initialize(List<String> messageCodes, List<String> handlerCodes) throws MessageBusInitializationException;

    /**
     * Sends a message out to the bus implementation.
     * @param message Message to send to the Bus
     * @throws MessageSendingException If an error occurs
     */
    public void sendMessage(IBusMessage message) throws MessageSendingException;

    /**
     * Registers the messageBusService.
     * @param messageBus the message bus service.
     */
    public void registerMessageBusService(IMessageBus messageBus);

}
