package io.pythagoras.messagebus.core;

public interface IMessageBus {

    /**
     * Handles a generic message coming in from the message Bus, and converts it into the
     * specific contract types and dispatches it.
     * @param busMessage The message being received.
     * @throws HandleMessageFailureException When the handling of the message fails.
     */
    public void receiveMessage(IBusMessage busMessage) throws HandleMessageFailureException;

    /**
     * Takes the specific message, turns it into a generic message, and send to the message bus.
     * @param message the message to send
     * @throws MessageSendingException When there is a failure in sending.
     */
    public void sendMessage(IMessageContract message) throws MessageSendingException;
}
