/*
 * Decompiled with CFR 0.152.
 */
package io.pythagoras.messagebus.core;

import io.pythagoras.messagebus.annotations.MessageHandler;
import io.pythagoras.messagebus.core.HandleMessageFailureException;
import io.pythagoras.messagebus.core.IMessageContract;
import io.pythagoras.messagebus.core.IMessageHandler;
import io.pythagoras.messagebus.core.MessageBusInitializationException;
import io.pythagoras.messagebus.core.MessageContractProvider;
import io.pythagoras.messagebus.core.MessageFactory;
import io.pythagoras.messagebus.core.config.MessageBusProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class MessageHandlerProvider
implements ApplicationContextAware {
    private ApplicationContext context;
    private MessageContractProvider messageContractProvider;
    private MessageFactory messageFactory;
    private HashMap<String, List<IMessageHandler>> classes = new HashMap();
    private Boolean enabled;

    public MessageHandlerProvider(MessageContractProvider messageContractProvider, MessageFactory messageFactory, MessageBusProperties properties) {
        this.messageContractProvider = messageContractProvider;
        this.messageFactory = messageFactory;
        this.enabled = properties.isEnabled();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @PostConstruct
    public void init() {
        this.load();
    }

    public List<String> getHandlerContractCodes() {
        ArrayList<String> codes = new ArrayList<String>();
        for (String contractClass : this.classes.keySet()) {
            try {
                IMessageContract message = this.messageFactory.make(Class.forName(contractClass));
                codes.add(message.getCode());
            }
            catch (ClassNotFoundException e) {}
        }
        return codes;
    }

    public IMessageHandler getMessageHandlerForCodeAndVersion(String code, Integer version) {
        Class<IMessageContract> klass = this.messageContractProvider.get(code, version);
        if (!this.classes.containsKey(klass.getName())) {
            throw new HandleMessageFailureException();
        }
        List<IMessageHandler> handlers = this.classes.get(klass.getName());
        ArrayList<IMessageHandler> matchingListeners = new ArrayList<IMessageHandler>();
        for (IMessageHandler listener : handlers) {
            if (!listener.allowedVersion(version)) continue;
            matchingListeners.add(listener);
        }
        if (matchingListeners.size() != 1) {
            throw new HandleMessageFailureException("There can only be one listener per contract and version.");
        }
        return (IMessageHandler)matchingListeners.get(0);
    }

    private void load() throws MessageBusInitializationException {
        if (!this.enabled.booleanValue()) {
            return;
        }
        for (Object o : this.context.getBeansWithAnnotation(MessageHandler.class).values()) {
            Class<?> cl = o.getClass();
            if (!IMessageHandler.class.isAssignableFrom(cl)) {
                throw new MessageBusInitializationException("Class '" + cl.getName() + "' must implement IMessageHandler.");
            }
            IMessageHandler handler = (IMessageHandler)this.context.getBean(cl);
            String allowedClass = handler.getAllowedClass().getName();
            this.classes.putIfAbsent(allowedClass, new ArrayList());
            this.classes.get(handler.getAllowedClass().getName()).add(handler);
        }
    }
}

