/*
 * Decompiled with CFR 0.152.
 */
package io.pythagoras.messagebus.core;

import io.pythagoras.messagebus.annotations.MessageContract;
import io.pythagoras.messagebus.core.IMessageContract;
import io.pythagoras.messagebus.core.MessageBusInitializationException;
import io.pythagoras.messagebus.core.MessageConversionException;
import io.pythagoras.messagebus.core.MessageFactory;
import io.pythagoras.messagebus.core.config.MessageBusProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class MessageContractProvider<A extends IMessageContract>
implements ApplicationContextAware {
    private MessageFactory<A> messageFactory;
    private ApplicationContext context;
    private HashMap<String, HashMap<Integer, Class<IMessageContract>>> classes = new HashMap();
    private Boolean enabled;

    @Autowired
    public MessageContractProvider(MessageFactory<A> messageFactory, MessageBusProperties properties) {
        this.messageFactory = messageFactory;
        this.enabled = properties.isEnabled();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @PostConstruct
    public void init() {
        this.load();
    }

    public boolean has(String code, Integer version) {
        if (!this.classes.containsKey(code)) {
            return false;
        }
        return this.classes.get(code).containsKey(version);
    }

    public List<String> getCodeList() {
        ArrayList<String> codes = new ArrayList<String>();
        for (String code : this.classes.keySet()) {
            if (codes.contains(code)) continue;
            codes.add(code);
        }
        return codes;
    }

    public Class<IMessageContract> get(String code, Integer version) throws MessageConversionException {
        if (!this.has(code, version)) {
            throw new MessageConversionException();
        }
        return this.classes.get(code).get(version);
    }

    private void add(Class<IMessageContract> klass) throws MessageConversionException {
        IMessageContract obj = this.messageFactory.make(klass);
        this.classes.putIfAbsent(obj.getCode(), new HashMap());
        this.classes.get(obj.getCode()).putIfAbsent(obj.getVersion(), klass);
    }

    private void load() {
        if (!this.enabled.booleanValue()) {
            return;
        }
        for (Object o : this.context.getBeansWithAnnotation(MessageContract.class).values()) {
            Class<IMessageContract> cl = o.getClass();
            if (!IMessageContract.class.isAssignableFrom(cl)) {
                throw new MessageBusInitializationException("Class '" + cl.getName() + "' must implement IMessageContract.");
            }
            IMessageContract message = this.messageFactory.make(cl);
            this.add(cl);
        }
    }
}

