/*
 * Decompiled with CFR 0.152.
 */
package io.pythagoras.messagebus.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.pythagoras.messagebus.core.BusMessage;
import io.pythagoras.messagebus.core.HandleMessageFailureException;
import io.pythagoras.messagebus.core.IBusMessage;
import io.pythagoras.messagebus.core.IMessageBus;
import io.pythagoras.messagebus.core.IMessageContract;
import io.pythagoras.messagebus.core.IMessageHandler;
import io.pythagoras.messagebus.core.MessageBusAdapterProvider;
import io.pythagoras.messagebus.core.MessageContractProvider;
import io.pythagoras.messagebus.core.MessageFactory;
import io.pythagoras.messagebus.core.MessageHandlerProvider;
import io.pythagoras.messagebus.core.MessageSendingException;
import io.pythagoras.messagebus.core.config.MessageBusProperties;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageBusService
implements IMessageBus {
    private MessageBusAdapterProvider messageBusAdapterProvider;
    private MessageContractProvider messageContractProvider;
    private MessageFactory messageFactory;
    private MessageHandlerProvider messageHandlerProvider;
    private Gson gson;
    private Boolean enabled;

    @Autowired
    public MessageBusService(MessageBusAdapterProvider messageBusAdapterProvider, MessageContractProvider messageContractProvider, MessageHandlerProvider messageHandlerProvider, MessageFactory messageFactory, MessageBusProperties properties) {
        this.messageBusAdapterProvider = messageBusAdapterProvider;
        this.messageHandlerProvider = messageHandlerProvider;
        this.messageContractProvider = messageContractProvider;
        this.messageFactory = messageFactory;
        this.gson = new GsonBuilder().create();
        this.enabled = properties.isEnabled();
    }

    @PostConstruct
    public void init() {
        if (!this.enabled.booleanValue()) {
            return;
        }
        List<String> messageCodes = this.messageContractProvider.getCodeList();
        List<String> handlerCodes = this.messageHandlerProvider.getHandlerContractCodes();
        this.messageBusAdapterProvider.getAdapter().initialize(messageCodes, handlerCodes);
        this.messageBusAdapterProvider.getAdapter().registerMessageBusService(this);
    }

    @Override
    public void sendMessage(IMessageContract message) throws MessageSendingException {
        if (!this.enabled.booleanValue()) {
            throw new MessageSendingException("MessageBus is disabled.");
        }
        BusMessage busMessage = new BusMessage();
        busMessage.setCode(message.getCode());
        busMessage.setVersion(message.getVersion());
        String body = this.gson.toJson((Object)message);
        busMessage.setPayload(body);
        this.messageBusAdapterProvider.getAdapter().sendMessage(busMessage);
    }

    @Override
    public void receiveMessage(IBusMessage busMessage) throws HandleMessageFailureException {
        if (!this.enabled.booleanValue()) {
            throw new HandleMessageFailureException("MessageBus is disabled.");
        }
        IMessageContract message = this.convertFromBusMessage(busMessage);
        IMessageHandler handler = this.messageHandlerProvider.getMessageHandlerForCodeAndVersion(message.getCode(), message.getVersion());
        handler.handleMessage(message);
    }

    private IMessageContract convertFromBusMessage(IBusMessage busMessage) {
        Class<IMessageContract> klass = this.messageContractProvider.get(busMessage.getCode(), busMessage.getVersion());
        IMessageContract obj = this.messageFactory.make(klass);
        IMessageContract message = (IMessageContract)this.gson.fromJson(busMessage.getPayload(), obj.getClass());
        return message;
    }
}

