/*
 * Decompiled with CFR 0.152.
 */
package io.pythagoras.messagebus.core;

import io.pythagoras.messagebus.annotations.MessageBusAdapter;
import io.pythagoras.messagebus.core.IMessageBusAdapter;
import io.pythagoras.messagebus.core.MessageBusInitializationException;
import io.pythagoras.messagebus.core.config.MessageBusProperties;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class MessageBusAdapterProvider
implements ApplicationContextAware {
    private ApplicationContext context;
    private IMessageBusAdapter adapter;
    private Boolean enabled;

    public MessageBusAdapterProvider(MessageBusProperties properties) {
        this.enabled = properties.isEnabled();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @PostConstruct
    public void init() {
        this.load();
    }

    public IMessageBusAdapter getAdapter() {
        return this.adapter;
    }

    private void load() throws MessageBusInitializationException {
        IMessageBusAdapter handler;
        if (!this.enabled.booleanValue()) {
            return;
        }
        Collection objs = this.context.getBeansWithAnnotation(MessageBusAdapter.class).values();
        if (objs.size() != 1) {
            throw new MessageBusInitializationException("There must be exactly one MessageBusAdapter. " + objs.size() + " found.");
        }
        Object o = objs.toArray()[0];
        Class<?> cl = o.getClass();
        if (!IMessageBusAdapter.class.isAssignableFrom(cl)) {
            throw new MessageBusInitializationException("Class '" + cl.getName() + "' must implement IMessageContract.");
        }
        this.adapter = handler = (IMessageBusAdapter)this.context.getBean(cl);
    }
}

