package io.pythagoras.messagebus.core;

import org.springframework.stereotype.Component;

@Component
public class MessageFactory<A extends IMessageContract> {

    public IMessageContract make(Class<IMessageContract> klass) {
        try {
            Object temp = klass.newInstance();
            if(!(temp instanceof IMessageContract)) {
                throw new MessageConversionException();
            }
            A obj = (A) temp;
            return obj;
        } catch (InstantiationException | IllegalAccessException e) {
            throw new MessageConversionException("",e);
        }
    }

}
