/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.protostuff.compiler.model.ModuleConfiguration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ModuleConfiguration", generator="Immutables")
@Immutable
public final class ImmutableModuleConfiguration
implements ModuleConfiguration {
    private final String name;
    private final ImmutableList<Path> includePaths;
    private final ImmutableList<String> protoFiles;
    private final String generator;
    private final String output;
    private final ImmutableMap<String, Object> options;

    private ImmutableModuleConfiguration(String name, ImmutableList<Path> includePaths, ImmutableList<String> protoFiles, String generator, String output, ImmutableMap<String, Object> options) {
        this.name = name;
        this.includePaths = includePaths;
        this.protoFiles = protoFiles;
        this.generator = generator;
        this.output = output;
        this.options = options;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<Path> getIncludePaths() {
        return this.includePaths;
    }

    public ImmutableList<String> getProtoFiles() {
        return this.protoFiles;
    }

    @Override
    public String getGenerator() {
        return this.generator;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    public ImmutableMap<String, Object> getOptions() {
        return this.options;
    }

    public final ImmutableModuleConfiguration withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableModuleConfiguration(newValue, this.includePaths, this.protoFiles, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withIncludePaths(Path ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableModuleConfiguration(this.name, (ImmutableList<Path>)newValue, this.protoFiles, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withIncludePaths(Iterable<? extends Path> elements) {
        if (this.includePaths == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableModuleConfiguration(this.name, (ImmutableList<Path>)newValue, this.protoFiles, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withProtoFiles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableModuleConfiguration(this.name, this.includePaths, (ImmutableList<String>)newValue, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withProtoFiles(Iterable<String> elements) {
        if (this.protoFiles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableModuleConfiguration(this.name, this.includePaths, (ImmutableList<String>)newValue, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withGenerator(String value) {
        String newValue = Objects.requireNonNull(value, "generator");
        if (this.generator.equals(newValue)) {
            return this;
        }
        return new ImmutableModuleConfiguration(this.name, this.includePaths, this.protoFiles, newValue, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withOutput(String value) {
        String newValue = Objects.requireNonNull(value, "output");
        if (this.output.equals(newValue)) {
            return this;
        }
        return new ImmutableModuleConfiguration(this.name, this.includePaths, this.protoFiles, this.generator, newValue, this.options);
    }

    public final ImmutableModuleConfiguration withOptions(Map<String, ? extends Object> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableModuleConfiguration(this.name, this.includePaths, this.protoFiles, this.generator, this.output, (ImmutableMap<String, Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModuleConfiguration && this.equalTo((ImmutableModuleConfiguration)another);
    }

    private boolean equalTo(ImmutableModuleConfiguration another) {
        return this.name.equals(another.name) && this.includePaths.equals(another.includePaths) && this.protoFiles.equals(another.protoFiles) && this.generator.equals(another.generator) && this.output.equals(another.output) && this.options.equals(another.options);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.includePaths.hashCode();
        h += (h << 5) + this.protoFiles.hashCode();
        h += (h << 5) + this.generator.hashCode();
        h += (h << 5) + this.output.hashCode();
        h += (h << 5) + this.options.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModuleConfiguration").omitNullValues().add("name", (Object)this.name).add("includePaths", this.includePaths).add("protoFiles", this.protoFiles).add("generator", (Object)this.generator).add("output", (Object)this.output).add("options", this.options).toString();
    }

    public static ImmutableModuleConfiguration copyOf(ModuleConfiguration instance) {
        if (instance instanceof ImmutableModuleConfiguration) {
            return (ImmutableModuleConfiguration)instance;
        }
        return ImmutableModuleConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ModuleConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_GENERATOR = 2L;
        private static final long INIT_BIT_OUTPUT = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        private ImmutableList.Builder<Path> includePaths = ImmutableList.builder();
        private ImmutableList.Builder<String> protoFiles = ImmutableList.builder();
        @Nullable
        private String generator;
        @Nullable
        private String output;
        private ImmutableMap.Builder<String, Object> options = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModuleConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllIncludePaths(instance.getIncludePaths());
            this.addAllProtoFiles(instance.getProtoFiles());
            this.generator(instance.getGenerator());
            this.output(instance.getOutput());
            this.putAllOptions(instance.getOptions());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIncludePaths(Path element) {
            this.includePaths.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIncludePaths(Path ... elements) {
            this.includePaths.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder includePaths(Iterable<? extends Path> elements) {
            this.includePaths = ImmutableList.builder();
            return this.addAllIncludePaths(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllIncludePaths(Iterable<? extends Path> elements) {
            this.includePaths.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProtoFiles(String element) {
            this.protoFiles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProtoFiles(String ... elements) {
            this.protoFiles.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder protoFiles(Iterable<String> elements) {
            this.protoFiles = ImmutableList.builder();
            return this.addAllProtoFiles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProtoFiles(Iterable<String> elements) {
            this.protoFiles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder generator(String generator) {
            this.generator = Objects.requireNonNull(generator, "generator");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder output(String output) {
            this.output = Objects.requireNonNull(output, "output");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, Object value) {
            this.options.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends Object> entry) {
            this.options.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends Object> entries) {
            this.options = ImmutableMap.builder();
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends Object> entries) {
            this.options.putAll(entries);
            return this;
        }

        public ImmutableModuleConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModuleConfiguration(this.name, (ImmutableList<Path>)this.includePaths.build(), (ImmutableList<String>)this.protoFiles.build(), this.generator, this.output, (ImmutableMap<String, Object>)this.options.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("generator");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("output");
            }
            return "Cannot build ModuleConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

