/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.protostuff.compiler.model.Module;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.UsageIndex;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Module", generator="Immutables")
@Immutable
public final class ImmutableModule
implements Module {
    private final String name;
    private final ImmutableList<Proto> protos;
    private final String output;
    private final ImmutableMap<String, Object> options;
    private final UsageIndex usageIndex;

    private ImmutableModule(String name, ImmutableList<Proto> protos, String output, ImmutableMap<String, Object> options, UsageIndex usageIndex) {
        this.name = name;
        this.protos = protos;
        this.output = output;
        this.options = options;
        this.usageIndex = usageIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<Proto> getProtos() {
        return this.protos;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    public ImmutableMap<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public UsageIndex usageIndex() {
        return this.usageIndex;
    }

    public final ImmutableModule withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableModule(newValue, this.protos, this.output, this.options, this.usageIndex);
    }

    public final ImmutableModule withProtos(Proto ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableModule(this.name, (ImmutableList<Proto>)newValue, this.output, this.options, this.usageIndex);
    }

    public final ImmutableModule withProtos(Iterable<? extends Proto> elements) {
        if (this.protos == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableModule(this.name, (ImmutableList<Proto>)newValue, this.output, this.options, this.usageIndex);
    }

    public final ImmutableModule withOutput(String value) {
        String newValue = Objects.requireNonNull(value, "output");
        if (this.output.equals(newValue)) {
            return this;
        }
        return new ImmutableModule(this.name, this.protos, newValue, this.options, this.usageIndex);
    }

    public final ImmutableModule withOptions(Map<String, ? extends Object> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableModule(this.name, this.protos, this.output, (ImmutableMap<String, Object>)newValue, this.usageIndex);
    }

    public final ImmutableModule withUsageIndex(UsageIndex value) {
        if (this.usageIndex == value) {
            return this;
        }
        UsageIndex newValue = Objects.requireNonNull(value, "usageIndex");
        return new ImmutableModule(this.name, this.protos, this.output, this.options, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModule && this.equalTo((ImmutableModule)another);
    }

    private boolean equalTo(ImmutableModule another) {
        return this.name.equals(another.name) && this.protos.equals(another.protos) && this.output.equals(another.output) && this.options.equals(another.options) && this.usageIndex.equals(another.usageIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.protos.hashCode();
        h += (h << 5) + this.output.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.usageIndex.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Module").omitNullValues().add("name", (Object)this.name).add("protos", this.protos).add("output", (Object)this.output).add("options", this.options).add("usageIndex", (Object)this.usageIndex).toString();
    }

    public static ImmutableModule copyOf(Module instance) {
        if (instance instanceof ImmutableModule) {
            return (ImmutableModule)instance;
        }
        return ImmutableModule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Module", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_OUTPUT = 2L;
        private static final long INIT_BIT_USAGE_INDEX = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        private ImmutableList.Builder<Proto> protos = ImmutableList.builder();
        @Nullable
        private String output;
        private ImmutableMap.Builder<String, Object> options = ImmutableMap.builder();
        @Nullable
        private UsageIndex usageIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Module instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllProtos(instance.getProtos());
            this.output(instance.getOutput());
            this.putAllOptions(instance.getOptions());
            this.usageIndex(instance.usageIndex());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProtos(Proto element) {
            this.protos.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProtos(Proto ... elements) {
            this.protos.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder protos(Iterable<? extends Proto> elements) {
            this.protos = ImmutableList.builder();
            return this.addAllProtos(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProtos(Iterable<? extends Proto> elements) {
            this.protos.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder output(String output) {
            this.output = Objects.requireNonNull(output, "output");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, Object value) {
            this.options.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends Object> entry) {
            this.options.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends Object> entries) {
            this.options = ImmutableMap.builder();
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends Object> entries) {
            this.options.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder usageIndex(UsageIndex usageIndex) {
            this.usageIndex = Objects.requireNonNull(usageIndex, "usageIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableModule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModule(this.name, (ImmutableList<Proto>)this.protos.build(), this.output, (ImmutableMap<String, Object>)this.options.build(), this.usageIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("output");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("usageIndex");
            }
            return "Cannot build Module, some of required attributes are not set " + attributes;
        }
    }
}

