/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.AnnotationContainer;
import io.protostuff.parser.EnumField;
import io.protostuff.parser.HasFields;
import io.protostuff.parser.HasName;
import io.protostuff.parser.HasOptions;
import io.protostuff.parser.Message;
import io.protostuff.parser.MessageField;
import io.protostuff.parser.Proto;
import io.protostuff.parser.TextFormat;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;

public abstract class Field<T>
extends AnnotationContainer
implements Comparable<Field<?>>,
HasName,
HasOptions {
    java.lang.String name;
    java.lang.String defaultValueConstant;
    int number;
    Modifier modifier;
    boolean packable;
    T defaultValue;
    Message owner;
    final LinkedHashMap<java.lang.String, Object> standardOptions = new LinkedHashMap();
    final LinkedHashMap<java.lang.String, Object> extraOptions = new LinkedHashMap();

    public Field() {
    }

    public Field(boolean packable) {
        this.packable = packable;
    }

    @Override
    public Proto getProto() {
        return this.owner == null ? null : this.owner.getProto();
    }

    public LinkedHashMap<java.lang.String, Object> getStandardOptions() {
        return this.standardOptions;
    }

    public LinkedHashMap<java.lang.String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    public LinkedHashMap<java.lang.String, Object> getO() {
        return this.getOptions();
    }

    public LinkedHashMap<java.lang.String, Object> getOptions() {
        return this.extraOptions;
    }

    public <V> V getOption(java.lang.String key) {
        return (V)this.extraOptions.get(key);
    }

    public boolean hasOption(java.lang.String key) {
        return this.extraOptions.containsKey(key);
    }

    @Override
    public void putStandardOption(java.lang.String key, Object value) {
        this.putExtraOption(key, value);
        this.standardOptions.put(key, value);
    }

    @Override
    public void putExtraOption(java.lang.String key, Object value) {
        if (this.extraOptions.put(key, value) != null) {
            java.lang.String ofOwner;
            Proto proto;
            if (this.owner != null) {
                proto = this.owner.getProto();
                ofOwner = " of " + this.owner.getRelativeName();
            } else {
                proto = null;
                ofOwner = "";
            }
            throw Field.err("The field " + this.name + ofOwner + " contains a duplicate option: " + key, proto);
        }
    }

    @Override
    public java.lang.String getName() {
        return this.name;
    }

    public java.lang.String getDefaultValueConstant() {
        return this.defaultValueConstant;
    }

    public int getNumber() {
        return this.number;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public boolean isPackable() {
        return this.packable;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRepeated() {
        return this.modifier == Modifier.REPEATED;
    }

    public boolean isRequired() {
        return this.modifier == Modifier.REQUIRED;
    }

    public boolean isOptional() {
        return this.modifier == Modifier.OPTIONAL;
    }

    public boolean isDefaultValueSet() {
        return this.getDefaultValue() != null;
    }

    public boolean isNumberField() {
        return Number.class.isAssignableFrom(this.getClass());
    }

    public boolean isEnumField() {
        return EnumField.class.isAssignableFrom(this.getClass());
    }

    public boolean isMessageField() {
        return MessageField.class.isAssignableFrom(this.getClass());
    }

    public boolean isBytesField() {
        return Bytes.class.isAssignableFrom(this.getClass());
    }

    public boolean isStringField() {
        return String.class.isAssignableFrom(this.getClass());
    }

    public boolean isBoolField() {
        return Bool.class.isAssignableFrom(this.getClass());
    }

    public boolean isDelimited() {
        return false;
    }

    public java.lang.String toString() {
        return '{' + "type:" + this.getClass().getSimpleName() + ',' + "name:" + this.name + ',' + "number:" + this.number + ',' + "modifier:" + (Object)((Object)this.modifier) + ',' + "packable:" + this.packable + ',' + "defaultValue:" + this.defaultValue + '}';
    }

    @Override
    public int compareTo(Field<?> f) {
        if (f.number == this.number) {
            throw Field.err("The field: " + f.name + " cannot have the same number as " + this.name, this.owner == null ? null : this.owner.getProto());
        }
        return f.number < this.number ? 1 : -1;
    }

    public abstract java.lang.String getJavaType();

    public java.lang.String getProtoType() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    public java.lang.String getDefaultValueAsString() {
        return this.getDefaultValue().toString();
    }

    public Message getOwner() {
        return this.owner;
    }

    public static class Reference
    extends Field<Object> {
        java.lang.String refName;
        java.lang.String packageName;
        HasFields hasFields;

        public Reference(java.lang.String packageName, java.lang.String refName, HasFields hasFields) {
            this.packageName = packageName;
            this.refName = refName;
            this.hasFields = hasFields;
        }

        public java.lang.String getRefName() {
            return this.refName;
        }

        public java.lang.String getPackageName() {
            return this.packageName;
        }

        @Override
        public java.lang.String getJavaType() {
            return this.refName;
        }

        @Override
        public java.lang.String getProtoType() {
            return this.refName;
        }
    }

    public static class Bytes
    extends Field<byte[]> {
        public Bytes() {
            super(false);
        }

        @Override
        public java.lang.String getJavaType() {
            if (this.hasOption("ByteBuffer")) {
                return "ByteBuffer";
            }
            return "ByteString";
        }

        @Override
        public java.lang.String getDefaultValueAsString() {
            return TextFormat.escapeBytes(ByteBuffer.wrap((byte[])this.getDefaultValue())).toString();
        }

        @Override
        public boolean isDelimited() {
            return true;
        }
    }

    public static class String
    extends Field<java.lang.String> {
        public String() {
            super(false);
        }

        @Override
        public java.lang.String getJavaType() {
            return "String";
        }

        @Override
        public java.lang.String getDefaultValueAsString() {
            return TextFormat.escapeText((java.lang.String)this.getDefaultValue());
        }

        @Override
        public boolean isDelimited() {
            return true;
        }
    }

    public static class Bool
    extends Field<Boolean> {
        public Bool() {
            super(true);
        }

        @Override
        public java.lang.String getJavaType() {
            return "boolean";
        }
    }

    public static class Double
    extends Number<java.lang.Double> {
        @Override
        public java.lang.String getJavaType() {
            return "double";
        }
    }

    public static class Float
    extends Number<java.lang.Float> {
        @Override
        public java.lang.String getJavaType() {
            return "float";
        }
    }

    public static class SFixed64
    extends Number<Long> {
        @Override
        public java.lang.String getJavaType() {
            return "long";
        }
    }

    public static class Fixed64
    extends Number<Long> {
        @Override
        public java.lang.String getJavaType() {
            return "long";
        }
    }

    public static class SInt64
    extends Number<Long> {
        @Override
        public java.lang.String getJavaType() {
            return "long";
        }
    }

    public static class UInt64
    extends Number<Long> {
        @Override
        public java.lang.String getJavaType() {
            return "long";
        }
    }

    public static class Int64
    extends Number<Long> {
        @Override
        public java.lang.String getJavaType() {
            return "long";
        }
    }

    public static class SFixed32
    extends Number<Integer> {
        @Override
        public java.lang.String getJavaType() {
            return "int";
        }
    }

    public static class Fixed32
    extends Number<Integer> {
        @Override
        public java.lang.String getJavaType() {
            return "int";
        }
    }

    public static class SInt32
    extends Number<Integer> {
        @Override
        public java.lang.String getJavaType() {
            return "int";
        }
    }

    public static class UInt32
    extends Number<Integer> {
        @Override
        public java.lang.String getJavaType() {
            return "int";
        }
    }

    public static class Int32
    extends Number<Integer> {
        @Override
        public java.lang.String getJavaType() {
            return "int";
        }
    }

    static abstract class Number<T>
    extends Field<T> {
        public Number() {
            super(true);
        }
    }

    public static enum Modifier {
        OPTIONAL,
        REQUIRED,
        REPEATED;


        public java.lang.String getName() {
            return this.name().toLowerCase();
        }
    }
}

