/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.AnnotationContainer;
import io.protostuff.parser.ConfiguredReference;
import io.protostuff.parser.HasName;
import io.protostuff.parser.HasOptions;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import java.util.Collection;
import java.util.LinkedHashMap;

public class Service
extends AnnotationContainer
implements HasName,
HasOptions {
    final String name;
    final Message parentMessage;
    final Proto proto;
    final LinkedHashMap<String, RpcMethod> rpcMethods = new LinkedHashMap();
    final LinkedHashMap<String, Object> standardOptions = new LinkedHashMap();
    final LinkedHashMap<String, Object> extraOptions = new LinkedHashMap();

    public Service(String name, Message parentMessage, Proto proto) {
        this.name = name;
        this.parentMessage = parentMessage;
        if (parentMessage != null) {
            this.proto = parentMessage.getProto();
            parentMessage.addNestedService(this);
        } else {
            this.proto = proto;
            proto.addService(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        StringBuilder buffer = new StringBuilder();
        if (this.isNested()) {
            buffer.append(this.parentMessage.getFullName()).append('.').append(this.name);
        } else {
            buffer.append(this.getProto().getPackageName()).append('.').append(this.name);
        }
        return buffer.toString();
    }

    public String getJavaFullName() {
        StringBuilder buffer = new StringBuilder();
        if (this.isNested()) {
            buffer.append(this.parentMessage.getJavaFullName()).append('.').append(this.name);
        } else {
            buffer.append(this.getProto().getJavaPackageName()).append('.').append(this.name);
        }
        return buffer.toString();
    }

    public String getRelativeName() {
        return this.isNested() ? this.parentMessage.getRelativeName() + "." + this.name : this.name;
    }

    public Message getParentMessage() {
        return this.parentMessage;
    }

    public boolean isNested() {
        return this.parentMessage != null;
    }

    @Override
    public Proto getProto() {
        return this.proto;
    }

    public Collection<RpcMethod> getRpcMethods() {
        return this.rpcMethods.values();
    }

    public LinkedHashMap<String, RpcMethod> getRpcMethodMap() {
        return this.rpcMethods;
    }

    public RpcMethod getRpcMethod(String name) {
        return this.rpcMethods.get(name);
    }

    RpcMethod addRpcMethod(String name, String argName, String argPackage, String retName, String retPackage) {
        return new RpcMethod(name, this, argName, argPackage, retName, retPackage);
    }

    public LinkedHashMap<String, Object> getStandardOptions() {
        return this.standardOptions;
    }

    @Override
    public void putStandardOption(String key, Object value) {
        this.putExtraOption(key, value);
        this.standardOptions.put(key, value);
    }

    public Object getStandardOption(String name) {
        return this.standardOptions.get(name);
    }

    public LinkedHashMap<String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    @Override
    public void putExtraOption(String key, Object value) {
        if (this.extraOptions.put(key, value) != null) {
            throw Service.err("Duplicate service option: " + key, this.getProto());
        }
    }

    public Object getExtraOption(String name) {
        return this.extraOptions.get(name);
    }

    public LinkedHashMap<String, Object> getO() {
        return this.getOptions();
    }

    public LinkedHashMap<String, Object> getOptions() {
        return this.extraOptions;
    }

    void resolveReferences() {
        for (RpcMethod rm : this.rpcMethods.values()) {
            rm.resolveReferences();
        }
        if (!this.standardOptions.isEmpty()) {
            this.proto.references.add(new ConfiguredReference(this.standardOptions, this.extraOptions, this.proto.getPackageName()));
        }
    }

    public static class RpcMethod
    extends AnnotationContainer
    implements HasName,
    HasOptions {
        final LinkedHashMap<String, Object> standardOptions = new LinkedHashMap();
        final LinkedHashMap<String, Object> extraOptions = new LinkedHashMap();
        final String name;
        final Service service;
        final int index;
        final String argName;
        final String argPackage;
        final String retName;
        final String retPackage;
        Message argType;
        Message returnType;

        RpcMethod(String name, Service service, String argName, String argPackage, String retName, String retPackage) {
            this.name = name;
            this.service = service;
            this.index = service.rpcMethods.size();
            this.argName = argName;
            this.argPackage = argPackage;
            this.retName = retName;
            this.retPackage = retPackage;
            if (service.rpcMethods.put(name, this) != null) {
                throw RpcMethod.err("Duplicate rpc method: " + name + " from service " + service.name, service.getProto());
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public Proto getProto() {
            return this.service.getProto();
        }

        public Service getService() {
            return this.service;
        }

        public Service getOwner() {
            return this.service;
        }

        public Message getArgType() {
            return this.argType;
        }

        public Message getReturnType() {
            return this.returnType;
        }

        public boolean isVoidArgType() {
            return this.argType == null;
        }

        public boolean isVoidReturnType() {
            return this.returnType == null;
        }

        public String getJavaArgType() {
            if (this.argType == null) {
                return "null";
            }
            return this.getProto().getJavaPackageName().equals(this.argType.getProto().getJavaPackageName()) ? this.argType.getRelativeName() : this.argType.getJavaFullName();
        }

        public String getJavaReturnType() {
            if (this.returnType == null) {
                return "null";
            }
            return this.getProto().getJavaPackageName().equals(this.returnType.getProto().getJavaPackageName()) ? this.returnType.getRelativeName() : this.returnType.getJavaFullName();
        }

        public LinkedHashMap<String, Object> getStandardOptions() {
            return this.standardOptions;
        }

        @Override
        public void putStandardOption(String key, Object value) {
            this.putExtraOption(key, value);
            this.standardOptions.put(key, value);
        }

        public Object getStandardOption(String name) {
            return this.standardOptions.get(name);
        }

        public LinkedHashMap<String, Object> getExtraOptions() {
            return this.extraOptions;
        }

        @Override
        public void putExtraOption(String key, Object value) {
            if (this.extraOptions.put(key, value) != null) {
                throw RpcMethod.err("Duplicate rpc option: " + key, this.getProto());
            }
        }

        public Object getExtraOption(String name) {
            return this.extraOptions.get(name);
        }

        public LinkedHashMap<String, Object> getO() {
            return this.getOptions();
        }

        public LinkedHashMap<String, Object> getOptions() {
            return this.extraOptions;
        }

        void resolveReferences() {
            String fullReturnName;
            String fullArgName;
            Proto proto = this.getProto();
            String enclosingNs = this.service.isNested() ? this.service.parentMessage.getFullName() : proto.getPackageName();
            String string = fullArgName = this.argPackage != null ? this.argPackage + '.' + this.argName : this.argName;
            if (!"void".equals(fullArgName)) {
                Message argType = proto.findMessageReference(fullArgName, enclosingNs);
                if (argType == null) {
                    throw RpcMethod.err("The message " + fullArgName + " is not defined", proto);
                }
                this.argType = argType;
            }
            String string2 = fullReturnName = this.retPackage != null ? this.retPackage + '.' + this.retName : this.retName;
            if (!"void".equals(fullReturnName)) {
                Message returnType = proto.findMessageReference(fullReturnName, enclosingNs);
                if (returnType == null) {
                    throw RpcMethod.err("The message " + fullReturnName + " is not defined", proto);
                }
                this.returnType = returnType;
            }
            if (!this.standardOptions.isEmpty()) {
                proto.references.add(new ConfiguredReference(this.standardOptions, this.extraOptions, proto.getPackageName()));
            }
        }
    }
}

