/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.AnnotationContainer;
import io.protostuff.parser.ConfiguredReference;
import io.protostuff.parser.Field;
import io.protostuff.parser.HasFields;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import java.util.Collection;
import java.util.LinkedHashMap;

public class Extension
extends AnnotationContainer
implements HasFields {
    final Message parentMessage;
    final String packageName;
    final String type;
    Proto proto;
    final LinkedHashMap<String, Field<?>> fields = new LinkedHashMap();
    final LinkedHashMap<String, Object> standardOptions = new LinkedHashMap();
    final LinkedHashMap<String, Object> extraOptions = new LinkedHashMap();
    Message extendedMessage;

    public Extension(Proto proto, Message parentMessage, String packageName, String type) {
        this.proto = proto;
        this.parentMessage = parentMessage;
        this.packageName = packageName;
        this.type = type;
    }

    public Message getParentMessage() {
        return this.parentMessage;
    }

    public boolean isNested() {
        return this.parentMessage != null;
    }

    @Override
    public Proto getProto() {
        Proto p = this.proto;
        if (p == null) {
            this.proto = p = this.parentMessage.getProto();
        }
        return p;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return this.fields.values();
    }

    @Override
    public Field<?> getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public void addField(Field<?> field) {
        if (this.fields.put(field.name, field) != null) {
            throw Extension.err("Duplicate extension field: " + field.name, this.getProto());
        }
    }

    @Override
    public void putStandardOption(String key, Object value) {
        this.putExtraOption(key, value);
        this.standardOptions.put(key, value);
    }

    public LinkedHashMap<String, Object> getStandardOptions() {
        return this.standardOptions;
    }

    public Object getStandardOption(String key) {
        return this.standardOptions.get(key);
    }

    @Override
    public void putExtraOption(String key, Object value) {
        if (this.extraOptions.put(key, value) != null) {
            throw Extension.err("Duplicate extension option: " + key, this.getProto());
        }
    }

    public LinkedHashMap<String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    public Object getExtraOption(String key) {
        return this.extraOptions.get(key);
    }

    public LinkedHashMap<String, Object> getO() {
        return this.getOptions();
    }

    public LinkedHashMap<String, Object> getOptions() {
        return this.extraOptions;
    }

    public Message getExtendedMessage() {
        return this.extendedMessage;
    }

    void resolveReferences() {
        this.extendedMessage = this.getProto().findMessageReference(this.getExtendedMessageFullName(), this.getEnclosingNamespace());
        if (this.extendedMessage == null) {
            throw Extension.err("The message " + this.getExtendedMessageFullName() + " is not defined", this.getProto());
        }
        this.extendedMessage.extend(this);
        if (!this.standardOptions.isEmpty()) {
            this.proto.references.add(new ConfiguredReference(this.standardOptions, this.extraOptions, this.getExtendedMessageFullName()));
        }
    }

    public String getExtendedMessageFullName() {
        return this.packageName == null ? this.type : this.packageName + "." + this.type;
    }

    @Override
    public String getEnclosingNamespace() {
        return this.isNested() ? this.getParentMessage().getFullName() : this.getProto().getPackageName();
    }

    public String toString() {
        return '{' + "extend:" + this.getExtendedMessageFullName() + ',' + "fields:" + this.fields.values() + '}';
    }
}

