/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.EnumField;
import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Extension;
import io.protostuff.parser.Field;
import io.protostuff.parser.Message;
import io.protostuff.parser.MessageField;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoUtil;
import io.protostuff.parser.TextFormat;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;

public class ProtoParserTest
extends TestCase {
    static URL getResource(String path) throws IOException {
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }

    static File getFile(String path) {
        return new File(new File("src/test/resources"), path);
    }

    public void testSimple() throws Exception {
        File f = ProtoParserTest.getFile("TestModel.proto");
        ProtoParserTest.assertTrue((boolean)f.exists());
        Proto proto = new Proto(f);
        ProtoUtil.loadFrom((File)f, (Proto)proto);
        ProtoParserTest.assertEquals((String)proto.getPackageName(), (String)"simple");
        ProtoParserTest.assertEquals((String)proto.getJavaPackageName(), (String)"com.example.simple");
        ProtoParserTest.assertTrue((proto.getEnumGroups().size() == 0 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((proto.getMessages().size() == 3 ? 1 : 0) != 0);
        Message foo = proto.getMessage("Foo");
        Message bar = proto.getMessage("Bar");
        Message baz = proto.getMessage("Baz");
        ProtoParserTest.assertNotNull((Object)foo);
        ProtoParserTest.assertNotNull((Object)bar);
        ProtoParserTest.assertNotNull((Object)baz);
        ProtoParserTest.assertTrue((foo.getNestedEnumGroups().size() == 1 ? 1 : 0) != 0);
        EnumGroup enumSample = foo.getNestedEnumGroup("EnumSample");
        ProtoParserTest.assertNotNull((Object)enumSample);
        ProtoParserTest.assertTrue((enumSample.getValues().size() == 5 ? 1 : 0) != 0);
        ProtoParserTest.assertEquals((String)"TYPE0", (String)enumSample.getValue(0).getName());
        ProtoParserTest.assertEquals((String)"TYPE1", (String)enumSample.getValue(1).getName());
        ProtoParserTest.assertEquals((String)"TYPE2", (String)enumSample.getValue(2).getName());
        ProtoParserTest.assertEquals((String)"TYPE3", (String)enumSample.getValue(3).getName());
        ProtoParserTest.assertEquals((String)"TYPE4", (String)enumSample.getValue(4).getName());
        ProtoParserTest.assertTrue((foo.getFields().size() == 9 ? 1 : 0) != 0);
        Field.Int32 foo_some_int = (Field.Int32)foo.getField("some_int");
        Field.String foo_some_string = (Field.String)foo.getField("some_string");
        MessageField foo_bar = (MessageField)foo.getField("bar");
        EnumField foo_some_enum = (EnumField)foo.getField("some_enum");
        Field.Bytes foo_some_bytes = (Field.Bytes)foo.getField("some_bytes");
        Field.Bool foo_some_boolean = (Field.Bool)foo.getField("some_boolean");
        Field.Float foo_some_float = (Field.Float)foo.getField("some_float");
        Field.Double foo_some_double = (Field.Double)foo.getField("some_double");
        Field.Int64 foo_some_long = (Field.Int64)foo.getField("some_long");
        ProtoParserTest.assertTrue((foo_some_int != null && foo_some_int.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((foo_some_string != null && foo_some_string.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((foo_bar != null && foo_bar.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((foo_some_enum != null && foo_some_enum.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((foo_some_bytes != null && foo_some_bytes.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((foo_some_boolean != null && foo_some_boolean.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((foo_some_float != null && foo_some_float.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((foo_some_double != null && foo_some_double.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((foo_some_long != null && foo_some_long.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        Field.Int32 bar_some_int = (Field.Int32)bar.getField("some_int");
        Field.String bar_some_string = (Field.String)bar.getField("some_string");
        MessageField bar_baz = (MessageField)bar.getField("baz");
        EnumField bar_some_enum = (EnumField)bar.getField("some_enum");
        Field.Bytes bar_some_bytes = (Field.Bytes)bar.getField("some_bytes");
        Field.Bool bar_some_boolean = (Field.Bool)bar.getField("some_boolean");
        Field.Float bar_some_float = (Field.Float)bar.getField("some_float");
        Field.Double bar_some_double = (Field.Double)bar.getField("some_double");
        Field.Int64 bar_some_long = (Field.Int64)bar.getField("some_long");
        ProtoParserTest.assertTrue((bar_some_int != null && bar_some_int.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((bar_some_string != null && bar_some_string.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((bar_baz != null && bar_baz.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((bar_some_enum != null && bar_some_enum.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((bar_some_bytes != null && bar_some_bytes.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((bar_some_boolean != null && bar_some_boolean.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((bar_some_float != null && bar_some_float.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((bar_some_double != null && bar_some_double.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((bar_some_long != null && bar_some_long.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        Field.Int64 baz_id = (Field.Int64)baz.getField("id");
        Field.String baz_name = (Field.String)baz.getField("name");
        Field.Int64 baz_timestamp = (Field.Int64)baz.getField("timestamp");
        Field.Bytes baz_data = (Field.Bytes)baz.getField("data");
        ProtoParserTest.assertTrue((baz_id != null && baz_id.modifier == Field.Modifier.REQUIRED ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((baz_name != null && baz_name.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((baz_timestamp != null && baz_timestamp.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((baz_data != null && baz_data.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertEquals((Object)bar_some_int.defaultValue, (Object)127);
        ProtoParserTest.assertEquals((String)new String(((String)bar_some_string.defaultValue).getBytes(TextFormat.ISO_8859_1), "UTF-8"), (String)"\u1234");
        ProtoParserTest.assertEquals((Object)bar_some_float.defaultValue, (Object)Float.valueOf(127.0f));
        ProtoParserTest.assertEquals((Object)bar_some_double.defaultValue, (Object)45.123);
        byte[] data = (byte[])baz_data.getDefaultValue();
        ProtoParserTest.assertTrue((data != null && data.length == 2 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue(((data[0] & 0xFF) == 250 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue(((data[1] & 0xFF) == 206 ? 1 : 0) != 0);
    }

    public void testImport() throws Exception {
        File f = ProtoParserTest.getFile("unittest.proto");
        ProtoParserTest.assertTrue((boolean)f.exists());
        Proto proto = new Proto(f);
        ProtoUtil.loadFrom((File)f, (Proto)proto);
        Proto iProto = proto.getImportedProto(ProtoParserTest.getFile("google/protobuf/unittest_import.proto"));
        ProtoParserTest.assertNotNull((Object)iProto);
        ProtoParserTest.assertEquals((String)"protobuf_unittest_import", (String)iProto.getPackageName());
        ProtoParserTest.assertEquals((String)"com.google.protobuf.test", (String)iProto.getJavaPackageName());
        ProtoParserTest.assertTrue((iProto.getMessages().size() == 1 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((iProto.getEnumGroups().size() == 1 ? 1 : 0) != 0);
        EnumGroup importEnum = iProto.getEnumGroup("ImportEnum");
        ProtoParserTest.assertNotNull((Object)importEnum);
        ProtoParserTest.assertTrue((importEnum.values.size() == 3 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((importEnum.getValue((String)"IMPORT_FOO").number == 7 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((importEnum.getValue((String)"IMPORT_BAR").number == 8 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((importEnum.getValue((String)"IMPORT_BAZ").number == 9 ? 1 : 0) != 0);
        Message importMessage = iProto.getMessage("ImportMessage");
        ProtoParserTest.assertNotNull((Object)importMessage);
        ProtoParserTest.assertTrue((importMessage.getFields().size() == 1 ? 1 : 0) != 0);
        Field.Int32 import_message_d = (Field.Int32)importMessage.getField("d");
        ProtoParserTest.assertTrue((import_message_d != null ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((import_message_d.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((import_message_d.number == 1 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((import_message_d.defaultValue == null ? 1 : 0) != 0);
        ProtoParserTest.assertEquals((String)"protobuf_unittest", (String)proto.getPackageName());
        ProtoParserTest.assertEquals((String)proto.getJavaPackageName(), (String)proto.getPackageName());
        ProtoParserTest.assertTrue((proto.getEnumGroups().size() == 3 ? 1 : 0) != 0);
        EnumGroup foreignEnum = proto.getEnumGroup("ForeignEnum");
        ProtoParserTest.assertNotNull((Object)foreignEnum);
        ProtoParserTest.assertTrue((foreignEnum.getValues().size() == 3 ? 1 : 0) != 0);
        EnumGroup testEnumWithDupValue = proto.getEnumGroup("TestEnumWithDupValue");
        ProtoParserTest.assertNotNull((Object)testEnumWithDupValue);
        ProtoParserTest.assertTrue((testEnumWithDupValue.getValues().size() == 5 ? 1 : 0) != 0);
        ProtoParserTest.assertEquals((String)"FOO2", (String)((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)0)).name);
        ProtoParserTest.assertTrue((((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)0)).number == 1 ? 1 : 0) != 0);
        ProtoParserTest.assertEquals((String)"FOO1", (String)((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)1)).name);
        ProtoParserTest.assertTrue((((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)1)).number == 1 ? 1 : 0) != 0);
        ProtoParserTest.assertEquals((String)"BAR2", (String)((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)2)).name);
        ProtoParserTest.assertTrue((((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)2)).number == 2 ? 1 : 0) != 0);
        ProtoParserTest.assertEquals((String)"BAR1", (String)((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)3)).name);
        ProtoParserTest.assertTrue((((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)3)).number == 2 ? 1 : 0) != 0);
        ProtoParserTest.assertEquals((String)"BAZ", (String)((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)4)).name);
        ProtoParserTest.assertTrue((((EnumGroup.Value)testEnumWithDupValue.getSortedValues().get((int)4)).number == 3 ? 1 : 0) != 0);
        EnumGroup testSparseEnum = proto.getEnumGroup("TestSparseEnum");
        ProtoParserTest.assertNotNull((Object)testSparseEnum);
        ProtoParserTest.assertTrue((testSparseEnum.getValues().size() == 7 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((boolean)((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)0)).name.equals("SPARSE_E"));
        ProtoParserTest.assertTrue((((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)0)).number == -53452 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((boolean)((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)1)).name.equals("SPARSE_D"));
        ProtoParserTest.assertTrue((((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)1)).number == -15 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((boolean)((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)2)).name.equals("SPARSE_F"));
        ProtoParserTest.assertTrue((((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)2)).number == 0 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((boolean)((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)3)).name.equals("SPARSE_G"));
        ProtoParserTest.assertTrue((((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)3)).number == 2 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((boolean)((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)4)).name.equals("SPARSE_A"));
        ProtoParserTest.assertTrue((((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)4)).number == 123 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((boolean)((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)5)).name.equals("SPARSE_B"));
        ProtoParserTest.assertTrue((((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)5)).number == 62374 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((boolean)((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)6)).name.equals("SPARSE_C"));
        ProtoParserTest.assertTrue((((EnumGroup.Value)testSparseEnum.getSortedValues().get((int)6)).number == 12589234 ? 1 : 0) != 0);
        Message testAllTypes = proto.getMessage("TestAllTypes");
        ProtoParserTest.assertNotNull((Object)testAllTypes);
        ProtoParserTest.assertTrue((testAllTypes.getNestedMessages().size() == 1 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((testAllTypes.getNestedEnumGroups().size() == 1 ? 1 : 0) != 0);
        Field defaultStringPiece = testAllTypes.getField("default_string_piece");
        Field defaultCord = testAllTypes.getField("default_cord");
        ProtoParserTest.assertNotNull((Object)defaultStringPiece);
        ProtoParserTest.assertEquals((Object)"STRING_PIECE", (Object)defaultStringPiece.getOption("ctype"));
        ProtoParserTest.assertEquals((Object)"abc", (Object)defaultStringPiece.getOption("default"));
        ProtoParserTest.assertEquals((Object)"abc", (Object)defaultStringPiece.defaultValue);
        ProtoParserTest.assertNotNull((Object)defaultCord);
        ProtoParserTest.assertEquals((Object)"CORD", (Object)defaultCord.getOption("ctype"));
        ProtoParserTest.assertEquals((Object)"123", (Object)defaultCord.getOption("default"));
        ProtoParserTest.assertEquals((Object)"123", (Object)defaultCord.defaultValue);
        Message nestedMessage = testAllTypes.getNestedMessage("NestedMessage");
        ProtoParserTest.assertNotNull((Object)nestedMessage);
        EnumGroup nestedEnum = testAllTypes.getNestedEnumGroup("NestedEnum");
        ProtoParserTest.assertNotNull((Object)nestedEnum);
        Message foreignMessage = proto.getMessage("ForeignMessage");
        ProtoParserTest.assertNotNull((Object)foreignMessage);
        EnumField optional_nested_enum = (EnumField)testAllTypes.getField("optional_nested_enum", EnumField.class);
        ProtoParserTest.assertNotNull((Object)optional_nested_enum);
        ProtoParserTest.assertTrue((nestedEnum == optional_nested_enum.getEnumGroup() ? 1 : 0) != 0);
        EnumField optional_foreign_enum = (EnumField)testAllTypes.getField("optional_foreign_enum", EnumField.class);
        ProtoParserTest.assertNotNull((Object)optional_foreign_enum);
        ProtoParserTest.assertTrue((foreignEnum == optional_foreign_enum.getEnumGroup() ? 1 : 0) != 0);
        EnumField optional_import_enum = (EnumField)testAllTypes.getField("optional_import_enum", EnumField.class);
        ProtoParserTest.assertNotNull((Object)optional_import_enum);
        ProtoParserTest.assertTrue((importEnum == optional_import_enum.getEnumGroup() ? 1 : 0) != 0);
        MessageField optional_nested_message = (MessageField)testAllTypes.getField("optional_nested_message", MessageField.class);
        ProtoParserTest.assertNotNull((Object)optional_nested_message);
        ProtoParserTest.assertTrue((nestedMessage == optional_nested_message.getMessage() ? 1 : 0) != 0);
        MessageField optional_foreign_message = (MessageField)testAllTypes.getField("optional_foreign_message", MessageField.class);
        ProtoParserTest.assertNotNull((Object)optional_foreign_message);
        ProtoParserTest.assertTrue((foreignMessage == optional_foreign_message.getMessage() ? 1 : 0) != 0);
        MessageField optional_import_message = (MessageField)testAllTypes.getField("optional_import_message", MessageField.class);
        ProtoParserTest.assertNotNull((Object)optional_import_message);
        ProtoParserTest.assertTrue((importMessage == optional_import_message.getMessage() ? 1 : 0) != 0);
        Message testRequiredForeign = proto.getMessage("TestRequiredForeign");
        ProtoParserTest.assertNotNull((Object)testRequiredForeign);
        ProtoParserTest.assertTrue((testRequiredForeign.getFields().size() == 3 ? 1 : 0) != 0);
        MessageField test_required_foreign_optional_message = (MessageField)testRequiredForeign.getField("optional_message", MessageField.class);
        ProtoParserTest.assertNotNull((Object)test_required_foreign_optional_message);
        ProtoParserTest.assertTrue((test_required_foreign_optional_message.modifier == Field.Modifier.OPTIONAL ? 1 : 0) != 0);
        MessageField test_required_foreign_repeated_message = (MessageField)testRequiredForeign.getField("repeated_message", MessageField.class);
        ProtoParserTest.assertNotNull((Object)test_required_foreign_repeated_message);
        ProtoParserTest.assertTrue((test_required_foreign_repeated_message.modifier == Field.Modifier.REPEATED ? 1 : 0) != 0);
        Field.Int32 dummy = (Field.Int32)testRequiredForeign.getField("dummy", Field.Int32.class);
        ProtoParserTest.assertNotNull((Object)dummy);
        ProtoParserTest.assertTrue((dummy.modifier == Field.Modifier.OPTIONAL && dummy.number == 3 ? 1 : 0) != 0);
        Message testForeignNested = proto.getMessage("TestForeignNested");
        ProtoParserTest.assertNotNull((Object)testForeignNested);
        MessageField foreign_nested = (MessageField)testForeignNested.getField("foreign_nested", MessageField.class);
        ProtoParserTest.assertNotNull((Object)foreign_nested);
        ProtoParserTest.assertTrue((nestedMessage == foreign_nested.getMessage() ? 1 : 0) != 0);
        Message testEmptyMessage = proto.getMessage("TestEmptyMessage");
        ProtoParserTest.assertNotNull((Object)testEmptyMessage);
        ProtoParserTest.assertTrue((testEmptyMessage.getFields().size() == 0 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((testEmptyMessage.getNestedEnumGroups().size() == 0 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((testEmptyMessage.getNestedMessages().size() == 0 ? 1 : 0) != 0);
        Message testReallyLargeTagNumber = proto.getMessage("TestReallyLargeTagNumber");
        ProtoParserTest.assertNotNull((Object)testReallyLargeTagNumber);
        Field.Int32 a = (Field.Int32)testReallyLargeTagNumber.getField("a", Field.Int32.class);
        ProtoParserTest.assertNotNull((Object)a);
        ProtoParserTest.assertTrue((a.number == 1 ? 1 : 0) != 0);
        Field.Int32 bb = (Field.Int32)testReallyLargeTagNumber.getField("bb", Field.Int32.class);
        ProtoParserTest.assertNotNull((Object)bb);
        ProtoParserTest.assertTrue((bb.number == 0xFFFFFFF ? 1 : 0) != 0);
        Message testRecursiveMessage = proto.getMessage("TestRecursiveMessage");
        ProtoParserTest.assertNotNull((Object)testRecursiveMessage);
        MessageField testRecursiveMessage_a = (MessageField)testRecursiveMessage.getField("a", MessageField.class);
        ProtoParserTest.assertTrue((testRecursiveMessage == testRecursiveMessage_a.getMessage() ? 1 : 0) != 0);
        Message testMutualRecursionA = proto.getMessage("TestMutualRecursionA");
        ProtoParserTest.assertNotNull((Object)testMutualRecursionA);
        Message testMutualRecursionB = proto.getMessage("TestMutualRecursionB");
        ProtoParserTest.assertNotNull((Object)testMutualRecursionB);
        MessageField testMutualRecursionA_bb = (MessageField)testMutualRecursionA.getField("bb", MessageField.class);
        ProtoParserTest.assertNotNull((Object)testMutualRecursionA_bb);
        MessageField testMutualRecursionB_a = (MessageField)testMutualRecursionB.getField("a", MessageField.class);
        ProtoParserTest.assertNotNull((Object)testMutualRecursionB_a);
        ProtoParserTest.assertTrue((testMutualRecursionA == testMutualRecursionB_a.getMessage() ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((testMutualRecursionB == testMutualRecursionA_bb.getMessage() ? 1 : 0) != 0);
        Message testNestedMessageHasBits = proto.getMessage("TestNestedMessageHasBits");
        ProtoParserTest.assertNotNull((Object)testNestedMessageHasBits);
        Message tnmhb_nestedMessage = testNestedMessageHasBits.getNestedMessage("NestedMessage");
        ProtoParserTest.assertNotNull((Object)tnmhb_nestedMessage);
        MessageField tnmhb_optional_nested_message = (MessageField)testNestedMessageHasBits.getField("optional_nested_message", MessageField.class);
        ProtoParserTest.assertNotNull((Object)tnmhb_optional_nested_message);
        ProtoParserTest.assertTrue((tnmhb_nestedMessage == tnmhb_optional_nested_message.getMessage() ? 1 : 0) != 0);
        MessageField nestedmessage_repeated_foreignmessage = (MessageField)tnmhb_nestedMessage.getField("nestedmessage_repeated_foreignmessage", MessageField.class);
        ProtoParserTest.assertNotNull((Object)nestedmessage_repeated_foreignmessage);
        ProtoParserTest.assertTrue((foreignMessage == nestedmessage_repeated_foreignmessage.getMessage() ? 1 : 0) != 0);
        Message testFieldOrderings = proto.getMessage("TestFieldOrderings");
        ProtoParserTest.assertNotNull((Object)testFieldOrderings);
        ProtoParserTest.assertTrue((testFieldOrderings.getFields().size() == 3 ? 1 : 0) != 0);
        ProtoParserTest.assertEquals((String)((Field)testFieldOrderings.sortedFields.get((int)0)).name, (String)"my_int");
        ProtoParserTest.assertEquals((String)((Field)testFieldOrderings.sortedFields.get((int)1)).name, (String)"my_string");
        ProtoParserTest.assertEquals((String)((Field)testFieldOrderings.sortedFields.get((int)2)).name, (String)"my_float");
        Message testExtremeDefaultValues = proto.getMessage("TestExtremeDefaultValues");
        ProtoParserTest.assertNotNull((Object)testExtremeDefaultValues);
        Field.UInt32 large_uint32 = (Field.UInt32)testExtremeDefaultValues.getField("large_uint32", Field.UInt32.class);
        ProtoParserTest.assertNotNull((Object)large_uint32);
        ProtoParserTest.assertTrue((((Integer)large_uint32.getDefaultValue() & 0xFFFFFFFF) == -1 ? 1 : 0) != 0);
        Field.UInt64 large_uint64 = (Field.UInt64)testExtremeDefaultValues.getField("large_uint64", Field.UInt64.class);
        ProtoParserTest.assertNotNull((Object)large_uint64);
        ProtoParserTest.assertTrue((-1L == (Long)large_uint64.getDefaultValue() ? 1 : 0) != 0);
        Field.Int32 small_int32 = (Field.Int32)testExtremeDefaultValues.getField("small_int32", Field.Int32.class);
        ProtoParserTest.assertNotNull((Object)small_int32);
        ProtoParserTest.assertTrue(((Integer)small_int32.getDefaultValue() == -2147483647 ? 1 : 0) != 0);
        Field.Int64 small_int64 = (Field.Int64)testExtremeDefaultValues.getField("small_int64", Field.Int64.class);
        ProtoParserTest.assertNotNull((Object)small_int64);
        ProtoParserTest.assertTrue((-9223372036854775807L == (Long)small_int64.getDefaultValue() ? 1 : 0) != 0);
        Message testAllExtensions = proto.getMessage("TestAllExtensions");
        ProtoParserTest.assertNotNull((Object)proto.getExtensions());
        ProtoParserTest.assertTrue((proto.getExtensions().size() > 0 ? 1 : 0) != 0);
        Extension extension = (Extension)proto.getExtensions().iterator().next();
        ProtoParserTest.assertEquals((Object)testAllExtensions, (Object)extension.extendedMessage);
        ProtoParserTest.assertNotNull((Object)extension.getFields());
        ProtoParserTest.assertTrue((extension.getFields().size() > 0 ? 1 : 0) != 0);
        Message testNestedExtension = proto.getMessage("TestNestedExtension");
        ProtoParserTest.assertNotNull((Object)testNestedExtension.getNestedExtensions());
        ProtoParserTest.assertEquals((int)1, (int)testNestedExtension.getNestedExtensions().size());
        extension = (Extension)testNestedExtension.getNestedExtensions().iterator().next();
        ProtoParserTest.assertTrue((boolean)extension.isNested());
        Message testMultipleExtensionRanges = proto.getMessage("TestMultipleExtensionRanges");
        ProtoParserTest.assertNotNull((Object)testMultipleExtensionRanges);
        ProtoParserTest.assertTrue((3 == testMultipleExtensionRanges.extensionRanges.size() ? 1 : 0) != 0);
        int[] first = (int[])testMultipleExtensionRanges.extensionRanges.get(0);
        int[] second = (int[])testMultipleExtensionRanges.extensionRanges.get(1);
        int[] third = (int[])testMultipleExtensionRanges.extensionRanges.get(2);
        ProtoParserTest.assertTrue((first[0] == first[1] && first[0] == 42 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((second[0] == 4143 && second[1] == 4243 ? 1 : 0) != 0);
        ProtoParserTest.assertTrue((third[0] == 65536 && third[1] == 0x1FFFFFFF ? 1 : 0) != 0);
    }

    public void testEnumWithTrailingSemicolon() throws Exception {
        File f = ProtoParserTest.getFile("enum_with_semicolon.proto");
        ProtoParserTest.assertTrue((boolean)f.exists());
        Proto proto = new Proto(f);
        ProtoUtil.loadFrom((File)f, (Proto)proto);
        ProtoParserTest.assertEquals((String)proto.getPackageName(), (String)"rpc");
    }

    public void testDescriptorProto() throws Exception {
        File f = ProtoParserTest.getFile("descriptor.proto");
        ProtoParserTest.assertTrue((boolean)f.exists());
        Proto proto = new Proto(f);
        ProtoUtil.loadFrom((File)f, (Proto)proto);
        ProtoParserTest.assertEquals((String)proto.getPackageName(), (String)"google.protobuf");
    }
}

