/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoParserTest;
import io.protostuff.parser.ProtoUtil;
import io.protostuff.parser.Service;
import java.io.File;
import junit.framework.TestCase;

public class ProtoServiceTest
extends TestCase {
    public void testRpc() throws Exception {
        File f = ProtoParserTest.getFile("test_rpc.proto");
        ProtoServiceTest.assertTrue((boolean)f.exists());
        Proto proto = new Proto(f);
        ProtoUtil.loadFrom((File)f, (Proto)proto);
        ProtoServiceTest.assertTrue((proto.getImportedProtos().size() == 2 ? 1 : 0) != 0);
        Proto importedProto = proto.getImportedProto(ProtoParserTest.getFile("test_imported_inner.proto"));
        ProtoServiceTest.assertNotNull((Object)importedProto);
        Proto jpImportedProto = proto.getImportedProto(ProtoParserTest.getFile("test_java_package_imported_inner.proto"));
        ProtoServiceTest.assertNotNull((Object)jpImportedProto);
        Message request = proto.getMessage("Request");
        ProtoServiceTest.assertNotNull((Object)request);
        Message requestInner = request.getNestedMessage("Inner");
        ProtoServiceTest.assertNotNull((Object)requestInner);
        Message requestDeeper = requestInner.getNestedMessage("Deeper");
        ProtoServiceTest.assertNotNull((Object)requestDeeper);
        Message response = proto.getMessage("Response");
        ProtoServiceTest.assertNotNull((Object)response);
        Message responseInner = response.getNestedMessage("Inner");
        ProtoServiceTest.assertNotNull((Object)responseInner);
        Message responseDeeper = responseInner.getNestedMessage("Deeper");
        ProtoServiceTest.assertNotNull((Object)responseDeeper);
        Message foo = importedProto.getMessage("Foo");
        ProtoServiceTest.assertNotNull((Object)foo);
        Message fooInner = foo.getNestedMessage("Inner");
        ProtoServiceTest.assertNotNull((Object)fooInner);
        Message fooDeeper = fooInner.getNestedMessage("Deeper");
        ProtoServiceTest.assertNotNull((Object)fooDeeper);
        Message bar = importedProto.getMessage("Bar");
        ProtoServiceTest.assertNotNull((Object)bar);
        Message barInner = bar.getNestedMessage("Inner");
        ProtoServiceTest.assertNotNull((Object)barInner);
        Message barDeeper = barInner.getNestedMessage("Deeper");
        ProtoServiceTest.assertNotNull((Object)barDeeper);
        Message jpFoo = jpImportedProto.getMessage("JPFoo");
        ProtoServiceTest.assertNotNull((Object)jpFoo);
        Message jpFooInner = jpFoo.getNestedMessage("Inner");
        ProtoServiceTest.assertNotNull((Object)jpFooInner);
        Message jpFooDeeper = jpFooInner.getNestedMessage("Deeper");
        ProtoServiceTest.assertNotNull((Object)jpFooDeeper);
        Message jpBar = jpImportedProto.getMessage("JPBar");
        ProtoServiceTest.assertNotNull((Object)jpBar);
        Message jpBarInner = jpBar.getNestedMessage("Inner");
        ProtoServiceTest.assertNotNull((Object)jpBarInner);
        Message jpBarDeeper = jpBarInner.getNestedMessage("Deeper");
        ProtoServiceTest.assertNotNull((Object)jpBarDeeper);
        Service service = proto.getService("SimpleRpc");
        ProtoServiceTest.assertNotNull((Object)service);
        Service.RpcMethod local = service.getRpcMethod("Local");
        ProtoServiceTest.assertNotNull((Object)local);
        ProtoServiceTest.assertTrue((local.getArgType() == request ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((local.getReturnType() == response ? 1 : 0) != 0);
        ProtoServiceTest.assertEquals((Object)Boolean.TRUE, (Object)local.getExtraOption("rpc.is_streaming_rpc"));
        ProtoServiceTest.assertEquals((Object)"bar", (Object)local.getExtraOption("foo"));
        ProtoServiceTest.assertEquals((Object)Float.valueOf(1.0f), (Object)local.getExtraOption("bar.baz"));
        ProtoServiceTest.assertEquals((Object)1, (Object)local.getExtraOption("id"));
        Service.RpcMethod theVoid = service.getRpcMethod("theVoid");
        ProtoServiceTest.assertNotNull((Object)theVoid);
        ProtoServiceTest.assertTrue((boolean)theVoid.isVoidArgType());
        ProtoServiceTest.assertTrue((boolean)theVoid.isVoidReturnType());
        Service.RpcMethod localFull = service.getRpcMethod("LocalFull");
        ProtoServiceTest.assertNotNull((Object)localFull);
        ProtoServiceTest.assertTrue((localFull.getArgType() == request ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((localFull.getReturnType() == response ? 1 : 0) != 0);
        Service.RpcMethod localInner = service.getRpcMethod("LocalInner");
        ProtoServiceTest.assertNotNull((Object)localInner);
        ProtoServiceTest.assertTrue((localInner.getArgType() == requestInner ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((localInner.getReturnType() == responseInner ? 1 : 0) != 0);
        Service.RpcMethod localInnerFull = service.getRpcMethod("LocalInnerFull");
        ProtoServiceTest.assertNotNull((Object)localInnerFull);
        ProtoServiceTest.assertTrue((localInnerFull.getArgType() == requestInner ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((localInnerFull.getReturnType() == responseInner ? 1 : 0) != 0);
        Service.RpcMethod localDeeper = service.getRpcMethod("LocalDeeper");
        ProtoServiceTest.assertNotNull((Object)localDeeper);
        ProtoServiceTest.assertTrue((localDeeper.getArgType() == requestDeeper ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((localDeeper.getReturnType() == responseDeeper ? 1 : 0) != 0);
        Service.RpcMethod localDeeperFull = service.getRpcMethod("LocalDeeperFull");
        ProtoServiceTest.assertNotNull((Object)localDeeperFull);
        ProtoServiceTest.assertTrue((localDeeperFull.getArgType() == requestDeeper ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((localDeeperFull.getReturnType() == responseDeeper ? 1 : 0) != 0);
        Service.RpcMethod foreign = service.getRpcMethod("Foreign");
        ProtoServiceTest.assertNotNull((Object)foreign);
        ProtoServiceTest.assertTrue((foreign.getArgType() == foo ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((foreign.getReturnType() == bar ? 1 : 0) != 0);
        Service.RpcMethod foreignFull = service.getRpcMethod("ForeignFull");
        ProtoServiceTest.assertNotNull((Object)foreignFull);
        ProtoServiceTest.assertTrue((foreignFull.getArgType() == foo ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((foreignFull.getReturnType() == bar ? 1 : 0) != 0);
        Service.RpcMethod foreignInner = service.getRpcMethod("ForeignInner");
        ProtoServiceTest.assertNotNull((Object)foreignInner);
        ProtoServiceTest.assertTrue((foreignInner.getArgType() == fooInner ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((foreignInner.getReturnType() == barInner ? 1 : 0) != 0);
        Service.RpcMethod foreignInnerFull = service.getRpcMethod("ForeignInnerFull");
        ProtoServiceTest.assertNotNull((Object)foreignInnerFull);
        ProtoServiceTest.assertTrue((foreignInnerFull.getArgType() == fooInner ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((foreignInnerFull.getReturnType() == barInner ? 1 : 0) != 0);
        Service.RpcMethod foreignDeeper = service.getRpcMethod("ForeignDeeper");
        ProtoServiceTest.assertNotNull((Object)foreignDeeper);
        ProtoServiceTest.assertTrue((foreignDeeper.getArgType() == fooDeeper ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((foreignDeeper.getReturnType() == barDeeper ? 1 : 0) != 0);
        Service.RpcMethod foreignDeeperFull = service.getRpcMethod("ForeignDeeperFull");
        ProtoServiceTest.assertNotNull((Object)foreignDeeperFull);
        ProtoServiceTest.assertTrue((foreignDeeperFull.getArgType() == fooDeeper ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((foreignDeeperFull.getReturnType() == barDeeper ? 1 : 0) != 0);
        Service.RpcMethod jpForeign = service.getRpcMethod("JPForeign");
        ProtoServiceTest.assertNotNull((Object)jpForeign);
        ProtoServiceTest.assertTrue((jpForeign.getArgType() == jpFoo ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((jpForeign.getReturnType() == jpBar ? 1 : 0) != 0);
        Service.RpcMethod jpForeignFull = service.getRpcMethod("JPForeignFull");
        ProtoServiceTest.assertNotNull((Object)jpForeignFull);
        ProtoServiceTest.assertTrue((jpForeignFull.getArgType() == jpFoo ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((jpForeignFull.getReturnType() == jpBar ? 1 : 0) != 0);
        Service.RpcMethod jpForeignInner = service.getRpcMethod("JPForeignInner");
        ProtoServiceTest.assertNotNull((Object)jpForeignInner);
        ProtoServiceTest.assertTrue((jpForeignInner.getArgType() == jpFooInner ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((jpForeignInner.getReturnType() == jpBarInner ? 1 : 0) != 0);
        Service.RpcMethod jpForeignInnerFull = service.getRpcMethod("JPForeignInnerFull");
        ProtoServiceTest.assertNotNull((Object)jpForeignInnerFull);
        ProtoServiceTest.assertTrue((jpForeignInnerFull.getArgType() == jpFooInner ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((jpForeignInnerFull.getReturnType() == jpBarInner ? 1 : 0) != 0);
        Service.RpcMethod jpForeignDeeper = service.getRpcMethod("JPForeignDeeper");
        ProtoServiceTest.assertNotNull((Object)jpForeignDeeper);
        ProtoServiceTest.assertTrue((jpForeignDeeper.getArgType() == jpFooDeeper ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((jpForeignDeeper.getReturnType() == jpBarDeeper ? 1 : 0) != 0);
        Service.RpcMethod jpForeignDeeperFull = service.getRpcMethod("JPForeignDeeperFull");
        ProtoServiceTest.assertNotNull((Object)jpForeignDeeperFull);
        ProtoServiceTest.assertTrue((jpForeignDeeperFull.getArgType() == jpFooDeeper ? 1 : 0) != 0);
        ProtoServiceTest.assertTrue((jpForeignDeeperFull.getReturnType() == jpBarDeeper ? 1 : 0) != 0);
        ProtoServiceTest.verifyNested(proto.getMessage("Hello"), response, responseInner, requestInner);
    }

    static void verifyNested(Message hello, Message response, Message responseInner, Message requestInner) {
        ProtoServiceTest.assertNotNull((Object)hello);
        Service s = hello.getNestedService("S");
        ProtoServiceTest.assertNotNull((Object)s);
        Service.RpcMethod greet = s.getRpcMethod("greet");
        ProtoServiceTest.assertNotNull((Object)greet);
        Message req = greet.getArgType();
        ProtoServiceTest.assertTrue((req == hello ? 1 : 0) != 0);
        Message res = greet.getReturnType();
        ProtoServiceTest.assertTrue((res == response ? 1 : 0) != 0);
        Service i = responseInner.getNestedService("I");
        ProtoServiceTest.assertNotNull((Object)i);
        Service.RpcMethod getChild = i.getRpcMethod("getChild");
        ProtoServiceTest.assertNotNull((Object)getChild);
        ProtoServiceTest.assertNotNull((Object)getChild.getArgType());
        ProtoServiceTest.assertTrue((getChild.getArgType() == responseInner ? 1 : 0) != 0);
        ProtoServiceTest.assertNotNull((Object)getChild.getReturnType());
        ProtoServiceTest.assertTrue((getChild.getReturnType() == responseInner.getNestedMessage("Deeper") ? 1 : 0) != 0);
        Service.RpcMethod getParent = i.getRpcMethod("getParent");
        ProtoServiceTest.assertNotNull((Object)getParent);
        ProtoServiceTest.assertNotNull((Object)getParent.getArgType());
        ProtoServiceTest.assertTrue((getParent.getArgType() == responseInner ? 1 : 0) != 0);
        ProtoServiceTest.assertNotNull((Object)getParent.getReturnType());
        ProtoServiceTest.assertTrue((getParent.getReturnType() == responseInner.getParentMessage() ? 1 : 0) != 0);
        Service.RpcMethod getHello = i.getRpcMethod("getHello");
        ProtoServiceTest.assertNotNull((Object)getHello);
        ProtoServiceTest.assertNotNull((Object)getHello.getArgType());
        ProtoServiceTest.assertTrue((getHello.getArgType() == responseInner ? 1 : 0) != 0);
        ProtoServiceTest.assertNotNull((Object)getHello.getReturnType());
        ProtoServiceTest.assertTrue((getHello.getReturnType() == hello ? 1 : 0) != 0);
        Service.RpcMethod fetchChild = i.getRpcMethod("fetchChild");
        ProtoServiceTest.assertNotNull((Object)fetchChild);
        ProtoServiceTest.assertNotNull((Object)fetchChild.getArgType());
        ProtoServiceTest.assertTrue((fetchChild.getArgType() == requestInner ? 1 : 0) != 0);
        ProtoServiceTest.assertNotNull((Object)fetchChild.getReturnType());
        ProtoServiceTest.assertTrue((fetchChild.getReturnType() == requestInner.getNestedMessage("Deeper") ? 1 : 0) != 0);
        Service.RpcMethod fetchParent = i.getRpcMethod("fetchParent");
        ProtoServiceTest.assertNotNull((Object)fetchParent);
        ProtoServiceTest.assertNotNull((Object)fetchParent.getArgType());
        ProtoServiceTest.assertTrue((fetchParent.getArgType() == requestInner ? 1 : 0) != 0);
        ProtoServiceTest.assertNotNull((Object)fetchParent.getReturnType());
        ProtoServiceTest.assertTrue((fetchParent.getReturnType() == requestInner.getParentMessage() ? 1 : 0) != 0);
        Service.RpcMethod fetchHello = i.getRpcMethod("fetchHello");
        ProtoServiceTest.assertNotNull((Object)fetchHello);
        ProtoServiceTest.assertNotNull((Object)fetchHello.getArgType());
        ProtoServiceTest.assertTrue((fetchHello.getArgType() == requestInner ? 1 : 0) != 0);
        ProtoServiceTest.assertNotNull((Object)fetchHello.getReturnType());
        ProtoServiceTest.assertTrue((fetchHello.getReturnType() == hello ? 1 : 0) != 0);
    }
}

