/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Message;
import io.protostuff.parser.MessageField;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoParserTest;
import io.protostuff.parser.ProtoUtil;
import java.io.File;
import junit.framework.TestCase;

public class DeepReferenceTest
extends TestCase {
    public void testIt() throws Exception {
        File f = ProtoParserTest.getFile("test_deep_reference.proto");
        DeepReferenceTest.assertTrue((boolean)f.exists());
        Proto proto = new Proto(f);
        ProtoUtil.loadFrom((File)f, (Proto)proto);
        DeepReferenceTest.assertTrue((proto.getImportedProtos().size() == 2 ? 1 : 0) != 0);
        Proto importedProto = proto.getImportedProto(ProtoParserTest.getFile("test_imported_inner.proto"));
        DeepReferenceTest.assertNotNull((Object)importedProto);
        Proto jpImportedProto = proto.getImportedProto(ProtoParserTest.getFile("test_java_package_imported_inner.proto"));
        DeepReferenceTest.assertNotNull((Object)jpImportedProto);
        Message request = proto.getMessage("Request");
        DeepReferenceTest.assertNotNull((Object)request);
        Message requestInner = request.getNestedMessage("Inner");
        DeepReferenceTest.assertNotNull((Object)requestInner);
        Message requestDeeper = requestInner.getNestedMessage("Deeper");
        DeepReferenceTest.assertNotNull((Object)requestDeeper);
        Message response = proto.getMessage("Response");
        DeepReferenceTest.assertNotNull((Object)response);
        Message responseInner = response.getNestedMessage("Inner");
        DeepReferenceTest.assertNotNull((Object)responseInner);
        Message responseDeeper = responseInner.getNestedMessage("Deeper");
        DeepReferenceTest.assertNotNull((Object)responseDeeper);
        Message foo = importedProto.getMessage("Foo");
        DeepReferenceTest.assertNotNull((Object)foo);
        Message fooInner = foo.getNestedMessage("Inner");
        DeepReferenceTest.assertNotNull((Object)fooInner);
        Message fooDeeper = fooInner.getNestedMessage("Deeper");
        DeepReferenceTest.assertNotNull((Object)fooDeeper);
        Message bar = importedProto.getMessage("Bar");
        DeepReferenceTest.assertNotNull((Object)bar);
        Message barInner = bar.getNestedMessage("Inner");
        DeepReferenceTest.assertNotNull((Object)barInner);
        Message barDeeper = barInner.getNestedMessage("Deeper");
        DeepReferenceTest.assertNotNull((Object)barDeeper);
        Message jpFoo = jpImportedProto.getMessage("JPFoo");
        DeepReferenceTest.assertNotNull((Object)jpFoo);
        Message jpFooInner = jpFoo.getNestedMessage("Inner");
        DeepReferenceTest.assertNotNull((Object)jpFooInner);
        Message jpFooDeeper = jpFooInner.getNestedMessage("Deeper");
        DeepReferenceTest.assertNotNull((Object)jpFooDeeper);
        Message jpBar = jpImportedProto.getMessage("JPBar");
        DeepReferenceTest.assertNotNull((Object)jpBar);
        Message jpBarInner = jpBar.getNestedMessage("Inner");
        DeepReferenceTest.assertNotNull((Object)jpBarInner);
        Message jpBarDeeper = jpBarInner.getNestedMessage("Deeper");
        DeepReferenceTest.assertNotNull((Object)jpBarDeeper);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("foo1", request) == foo ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("foo2", request) == foo ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("foo3", request) == jpFoo ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner1", request) == fooInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner2", request) == fooInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner3", request) == jpFooInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper1", request) == fooDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper2", request) == fooDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper3", request) == jpFooDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("foo1", requestInner) == foo ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("foo2", requestInner) == foo ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("foo3", requestInner) == jpFoo ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner1", requestInner) == fooInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner2", requestInner) == fooInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner3", requestInner) == jpFooInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper1", requestInner) == fooDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper2", requestInner) == fooDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper3", requestInner) == jpFooDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("foo1", requestDeeper) == foo ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("foo2", requestDeeper) == foo ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("foo3", requestDeeper) == jpFoo ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner1", requestDeeper) == fooInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner2", requestDeeper) == fooInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner3", requestDeeper) == jpFooInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper1", requestDeeper) == fooDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper2", requestDeeper) == fooDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper3", requestDeeper) == jpFooDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("bar1", response) == bar ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("bar2", response) == bar ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("bar3", response) == jpBar ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner1", response) == barInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner2", response) == barInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner3", response) == jpBarInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper1", response) == barDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper2", response) == barDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper3", response) == jpBarDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("bar1", responseInner) == bar ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("bar2", responseInner) == bar ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("bar3", responseInner) == jpBar ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner1", responseInner) == barInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner2", responseInner) == barInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner3", responseInner) == jpBarInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper1", responseInner) == barDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper2", responseInner) == barDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper3", responseInner) == jpBarDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("bar1", responseDeeper) == bar ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("bar2", responseDeeper) == bar ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("bar3", responseDeeper) == jpBar ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner1", responseDeeper) == barInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner2", responseDeeper) == barInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("inner3", responseDeeper) == jpBarInner ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper1", responseDeeper) == barDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper2", responseDeeper) == barDeeper ? 1 : 0) != 0);
        DeepReferenceTest.assertTrue((DeepReferenceTest.getMessageField("deeper3", responseDeeper) == jpBarDeeper ? 1 : 0) != 0);
    }

    static Message getMessageField(String name, Message msg) {
        return ((MessageField)msg.getField(name)).getMessage();
    }
}

