/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Annotation;
import io.protostuff.parser.ConfiguredReference;
import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Field;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoParserTest;
import io.protostuff.parser.ProtoUtil;
import io.protostuff.parser.Service;
import java.io.File;
import junit.framework.TestCase;

public class ConfiguredReferenceTest
extends TestCase {
    public void testIt() throws Exception {
        File f = ProtoParserTest.getFile("io/protostuff/parser/test_option_annotation_reference.proto");
        ConfiguredReferenceTest.assertTrue((boolean)f.exists());
        Proto proto = new Proto(f);
        ProtoUtil.loadFrom((File)f, (Proto)proto);
        Message car = proto.getMessage("Car");
        ConfiguredReferenceTest.assertNotNull((Object)car);
        EnumGroup condition = car.getNestedEnumGroup("Condition");
        ConfiguredReferenceTest.assertNotNull((Object)condition);
        Message part = car.getNestedMessage("Part");
        ConfiguredReferenceTest.assertNotNull((Object)part);
        Message tire = part.getNestedMessage("Tire");
        ConfiguredReferenceTest.assertNotNull((Object)tire);
        Message person = (Message)proto.findReference("Person", proto.getPackageName());
        ConfiguredReferenceTest.assertNotNull((Object)person);
        Message listRequest = person.getNestedMessage("ListRequest");
        ConfiguredReferenceTest.assertNotNull((Object)listRequest);
        EnumGroup importedGender = (EnumGroup)proto.findReference("Person.Gender", proto.getPackageName());
        ConfiguredReferenceTest.assertNotNull((Object)importedGender);
        EnumGroup localGender = proto.getEnumGroup("Gender");
        ConfiguredReferenceTest.assertNotNull((Object)localGender);
        ConfiguredReferenceTest.verifyCarAnnotations(car, part, tire, localGender, importedGender, condition, person, listRequest);
        ConfiguredReferenceTest.verifyCarOptions(car, part, tire, localGender, importedGender, condition, person, listRequest);
        ConfiguredReferenceTest.verifyPart(part);
        ConfiguredReferenceTest.verifyCondition(condition);
        Service carService = proto.getService("CarService");
        ConfiguredReferenceTest.assertNotNull((Object)carService);
        ConfiguredReferenceTest.verifyCarService(carService, car, condition);
    }

    static void verifyCarAnnotations(Message car, Message part, Message tire, EnumGroup localGender, EnumGroup importedGender, EnumGroup condition, Message person, Message listRequest) {
        Annotation name = car.getAnnotation("Name");
        ConfiguredReferenceTest.assertNotNull((Object)name);
        ConfiguredReferenceTest.assertEquals((Object)name.getValue("value"), (Object)"Car");
        Annotation local = car.getAnnotation("Local");
        ConfiguredReferenceTest.assertNotNull((Object)local);
        ConfiguredReferenceTest.assertTrue((local.getValue("self") == car ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((local.getValue("local_enum") == localGender ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((local.getValue("nested") == part ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((local.getValue("nested_enum") == condition ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((local.getValue("deeper") == tire ? 1 : 0) != 0);
        Annotation imported = car.getAnnotation("Imported");
        ConfiguredReferenceTest.assertNotNull((Object)imported);
        ConfiguredReferenceTest.assertTrue((imported.getValue("imported_message") == person ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((imported.getValue("imported_enum") == importedGender ? 1 : 0) != 0);
        Annotation fqcn = car.getAnnotation("FQCN");
        ConfiguredReferenceTest.assertNotNull((Object)fqcn);
        ConfiguredReferenceTest.assertTrue((fqcn.getValue("fqcn_message") == listRequest ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((fqcn.getValue("fqcn_enum") == importedGender ? 1 : 0) != 0);
        if (ConfiguredReference.RESOLVE_ENUM_VALUE_REF) {
            ConfiguredReferenceTest.assertTrue((local.getValue("gender") == localGender.getValue("MALE") ? 1 : 0) != 0);
            ConfiguredReferenceTest.assertTrue((imported.getValue("gender") == importedGender.getValue("FEMALE") ? 1 : 0) != 0);
        }
    }

    static void verifyCarOptions(Message car, Message part, Message tire, EnumGroup localGender, EnumGroup importedGender, EnumGroup condition, Message person, Message listRequest) {
        ConfiguredReferenceTest.assertEquals((Object)"Car", car.getOptions().get("name"));
        ConfiguredReferenceTest.assertTrue((car.getOptions().get("self") == car ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((car.getOptions().get("local_enum") == localGender ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((car.getOptions().get("nested") == part ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((car.getOptions().get("nested_enum") == condition ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((car.getOptions().get("deeper") == tire ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((car.getOptions().get("imported_message") == person ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((car.getOptions().get("imported_enum") == importedGender ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((car.getOptions().get("fqcn_message") == listRequest ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((car.getOptions().get("fqcn_enum") == importedGender ? 1 : 0) != 0);
        Field.Int32 id = (Field.Int32)car.getField("id");
        ConfiguredReferenceTest.assertNotNull((Object)id);
        ConfiguredReferenceTest.assertTrue((id.getOptions().get("self") == car ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((id.getOptions().get("local_enum") == localGender ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((id.getOptions().get("nested") == part ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((id.getOptions().get("nested_enum") == condition ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((id.getOptions().get("deeper") == tire ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((id.getOptions().get("imported_message") == person ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((id.getOptions().get("imported_enum") == importedGender ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((id.getOptions().get("fqcn_message") == listRequest ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((id.getOptions().get("fqcn_enum") == importedGender ? 1 : 0) != 0);
        EnumGroup.Value male = localGender.getValue("MALE");
        ConfiguredReferenceTest.assertNotNull((Object)male);
        ConfiguredReferenceTest.assertTrue((male.getOptions().get("self") == car ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((male.getOptions().get("local_enum") == localGender ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((male.getOptions().get("nested") == part ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((male.getOptions().get("nested_enum") == condition ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((male.getOptions().get("deeper") == tire ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((male.getOptions().get("imported_message") == person ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((male.getOptions().get("imported_enum") == importedGender ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((male.getOptions().get("fqcn_message") == listRequest ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((male.getOptions().get("fqcn_enum") == importedGender ? 1 : 0) != 0);
        if (ConfiguredReference.RESOLVE_ENUM_VALUE_REF) {
            ConfiguredReferenceTest.assertTrue((car.getOptions().get("local_gender") == localGender.getValue("MALE") ? 1 : 0) != 0);
            ConfiguredReferenceTest.assertTrue((car.getOptions().get("imported_gender") == importedGender.getValue("FEMALE") ? 1 : 0) != 0);
        }
    }

    static void verifyPart(Message part) {
        ConfiguredReferenceTest.assertNotNull((Object)part.getParentMessage());
        Annotation owner = part.getAnnotation("Owner");
        ConfiguredReferenceTest.assertNotNull((Object)owner);
        ConfiguredReferenceTest.assertTrue((owner.getValue("type") == part.getParentMessage() ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((part.getOptions().get("owner") == part.getParentMessage() ? 1 : 0) != 0);
    }

    static void verifyCondition(EnumGroup condition) {
        ConfiguredReferenceTest.assertNotNull((Object)condition.getParentMessage());
        Annotation owner = condition.getAnnotation("Owner");
        ConfiguredReferenceTest.assertNotNull((Object)owner);
        ConfiguredReferenceTest.assertTrue((owner.getValue("type") == condition.getParentMessage() ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertTrue((condition.getOptions().get("owner") == condition.getParentMessage() ? 1 : 0) != 0);
    }

    static void verifyCarService(Service carService, Message car, EnumGroup condition) {
        Annotation a = carService.getAnnotation("A");
        ConfiguredReferenceTest.assertNotNull((Object)a);
        ConfiguredReferenceTest.assertEquals((Object)Boolean.TRUE, (Object)a.getValue("public"));
        ConfiguredReferenceTest.assertTrue((car == a.getValue("target") ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertEquals((Object)Boolean.TRUE, carService.getOptions().get("public"));
        ConfiguredReferenceTest.assertTrue((car == carService.getOptions().get("target") ? 1 : 0) != 0);
        Service.RpcMethod rm = carService.getRpcMethod("getMostRecentCar");
        ConfiguredReferenceTest.assertNotNull((Object)rm);
        Annotation rmA = rm.getAnnotation("A");
        ConfiguredReferenceTest.assertNotNull((Object)rmA);
        ConfiguredReferenceTest.assertEquals((Object)Boolean.FALSE, (Object)rmA.getValue("throttle"));
        ConfiguredReferenceTest.assertTrue((condition == rmA.getValue("might_wanna_specify") ? 1 : 0) != 0);
        ConfiguredReferenceTest.assertEquals((Object)Boolean.FALSE, rm.getOptions().get("throttle"));
        ConfiguredReferenceTest.assertTrue((condition == rm.getOptions().get("might_wanna_specify") ? 1 : 0) != 0);
    }
}

