/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.maven;

import io.protostuff.generator.GeneratorException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    private static final String GENERATED_SOURCES = "/generated-sources/proto";
    private static final String GENERATED_TEST_SOURCES = "/generated-test-sources/proto";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGeneratorMojo.class);
    @Parameter
    protected List<String> includes;
    @Parameter
    protected List<String> excludes;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution execution;
    @Parameter
    private File source;

    Path getSourcePath() {
        if (this.source != null) {
            return this.source.toPath();
        }
        String phase = this.execution.getLifecyclePhase();
        String basedir = this.getCanonicalPath(this.project.getBasedir());
        String sourcePath = LifecyclePhase.GENERATE_TEST_SOURCES.id().equals(phase) ? basedir + "/src/test/proto/" : basedir + "/src/main/proto/";
        return Paths.get(sourcePath, new String[0]);
    }

    private String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new GeneratorException("Could not determine full path for %s", (Throwable)e, new Object[]{file});
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
    }

    List<String> findProtoFiles(final Path sourcePath) {
        final ArrayList<String> protoFiles = new ArrayList<String>();
        if (Files.exists(sourcePath, new LinkOption[0]) && Files.isDirectory(sourcePath, new LinkOption[0])) {
            final PathMatcher protoMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.proto");
            try {
                Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (protoMatcher.matches(file)) {
                            String protoFile = sourcePath.relativize(file).toString();
                            String normalizedPath = AbstractGeneratorMojo.this.normalizeProtoPath(protoFile);
                            protoFiles.add(normalizedPath);
                        }
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("Can not build source files list", (Throwable)e);
            }
        }
        return protoFiles;
    }

    private String normalizeProtoPath(String protoFilePath) {
        String normalizedPath = File.separatorChar == '\\' ? protoFilePath.replace('\\', '/') : protoFilePath;
        return normalizedPath;
    }

    String computeSourceOutputDir(@Nullable File target) {
        String output;
        if (target != null) {
            output = target.getAbsolutePath();
        } else {
            String phase = this.execution.getLifecyclePhase();
            String buildDirectory = this.project.getBuild().getDirectory();
            output = LifecyclePhase.GENERATE_TEST_SOURCES.id().equals(phase) ? buildDirectory + GENERATED_TEST_SOURCES : buildDirectory + GENERATED_SOURCES;
        }
        LOGGER.debug("output = {}", (Object)output);
        return output;
    }

    void addGeneratedSourcesToProject(String output) {
        if (LifecyclePhase.GENERATE_TEST_SOURCES.id().equals(this.execution.getLifecyclePhase())) {
            this.project.addTestCompileSourceRoot(output);
        } else {
            this.project.addCompileSourceRoot(output);
        }
    }
}

