/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.maven;

import io.protostuff.compiler.maven.AbstractGeneratorMojo;
import io.protostuff.compiler.model.ImmutableModuleConfiguration;
import io.protostuff.compiler.model.ModuleConfiguration;
import io.protostuff.generator.ProtostuffCompiler;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="st4", configurator="include-project-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class St4GeneratorMojo
extends AbstractGeneratorMojo {
    @Parameter
    private File target;
    @Parameter
    private String template;
    @Parameter
    private List<String> templates;
    @Parameter
    private String extensions;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ProtostuffCompiler compiler = new ProtostuffCompiler();
        Path sourcePath = this.getSourcePath();
        String output = this.computeSourceOutputDir(this.target);
        LinkedHashSet<String> allTemplates = new LinkedHashSet<String>();
        if (this.template != null) {
            allTemplates.add(this.template);
        }
        if (this.templates != null) {
            allTemplates.addAll(this.templates);
        }
        List<String> protoFiles = this.findProtoFiles(sourcePath);
        ImmutableModuleConfiguration moduleConfiguration = ImmutableModuleConfiguration.builder().name("java").includePaths(Collections.singletonList(sourcePath)).generator("st4").putOptions("templates", allTemplates).putOptions("extensions", (Object)this.extensions).output(output).addAllProtoFiles(protoFiles).build();
        compiler.compile((ModuleConfiguration)moduleConfiguration);
        this.addGeneratedSourcesToProject(output);
    }
}

