/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.maven;

import io.protostuff.compiler.maven.AbstractGeneratorMojo;
import io.protostuff.compiler.model.ImmutableModuleConfiguration;
import io.protostuff.compiler.model.ModuleConfiguration;
import io.protostuff.generator.ProtostuffCompiler;
import io.protostuff.generator.html.StaticPage;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="html", configurator="include-project-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class HtmlGeneratorMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-html")
    private File target;
    @Parameter
    private List<StaticPage> pages = new ArrayList<StaticPage>();

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ProtostuffCompiler compiler = new ProtostuffCompiler();
        Path sourcePath = this.getSourcePath();
        List<String> protoFiles = this.findProtoFiles(sourcePath);
        ImmutableModuleConfiguration moduleConfiguration = ImmutableModuleConfiguration.builder().name("html").includePaths(Collections.singletonList(sourcePath)).generator("html").output(this.target.getAbsolutePath()).putOptions("pages", this.pages).addAllProtoFiles(protoFiles).build();
        compiler.compile((ModuleConfiguration)moduleConfiguration);
    }
}

