/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.maven;

import io.protostuff.compiler.maven.AbstractGeneratorMojo;
import io.protostuff.compiler.model.ImmutableModuleConfiguration;
import io.protostuff.compiler.model.ModuleConfiguration;
import io.protostuff.generator.ProtostuffCompiler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="st4", configurator="include-project-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class St4GeneratorMojo
extends AbstractGeneratorMojo {
    public static final String GENERATED_SOURCES = "/generated-sources/proto";
    public static final String GENERATED_TEST_SOURCES = "/generated-test-sources/proto";
    private static final Logger LOGGER = LoggerFactory.getLogger(St4GeneratorMojo.class);
    @Parameter
    private File target;
    @Parameter
    private String template;
    @Parameter
    private List<String> templates;
    @Parameter
    private String extensions;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ProtostuffCompiler compiler = new ProtostuffCompiler();
        final Path sourcePath = this.getSourcePath();
        String output = this.calculateOutput();
        LinkedHashSet<String> allTemplates = new LinkedHashSet<String>();
        if (this.template != null) {
            allTemplates.add(this.template);
        }
        if (this.templates != null) {
            allTemplates.addAll(this.templates);
        }
        final ImmutableModuleConfiguration.Builder builder = ImmutableModuleConfiguration.builder().name("java").includePaths(Collections.singletonList(sourcePath)).generator("st4").putOptions("templates", allTemplates).putOptions("extensions", (Object)this.extensions).output(output);
        final PathMatcher protoMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.proto");
        try {
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (protoMatcher.matches(file)) {
                        String protoFile = sourcePath.relativize(file).toString();
                        builder.addProtoFiles(St4GeneratorMojo.this.normalizeProtoPath(protoFile));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Can not build source files list", (Throwable)e);
        }
        ImmutableModuleConfiguration moduleConfiguration = builder.build();
        LOGGER.debug("Module configuration = {}", (Object)moduleConfiguration);
        compiler.compile((ModuleConfiguration)moduleConfiguration);
        this.addGeneratedSourcesToProject(output);
    }

    private void addGeneratedSourcesToProject(String output) {
        if (LifecyclePhase.GENERATE_TEST_SOURCES.id().equals(this.execution.getLifecyclePhase())) {
            this.project.addTestCompileSourceRoot(output);
        } else {
            this.project.addCompileSourceRoot(output);
        }
    }

    private String calculateOutput() {
        String output;
        if (this.target != null) {
            output = this.target.getAbsolutePath();
        } else {
            String phase = this.execution.getLifecyclePhase();
            String buildDirectory = this.project.getBuild().getDirectory();
            output = LifecyclePhase.GENERATE_TEST_SOURCES.id().equals(phase) ? buildDirectory + GENERATED_TEST_SOURCES : buildDirectory + GENERATED_SOURCES;
        }
        LOGGER.debug("output = {}", (Object)output);
        return output;
    }
}

