/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.maven;

import io.protostuff.compiler.maven.AbstractGeneratorMojo;
import io.protostuff.compiler.model.ImmutableModuleConfiguration;
import io.protostuff.compiler.model.ModuleConfiguration;
import io.protostuff.generator.ProtostuffCompiler;
import io.protostuff.generator.html.StaticPage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="html", configurator="include-project-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class HtmlGeneratorMojo
extends AbstractGeneratorMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlGeneratorMojo.class);
    @Parameter(defaultValue="${project.build.directory}/generated-html")
    private File target;
    @Parameter
    private List<StaticPage> pages;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ProtostuffCompiler compiler = new ProtostuffCompiler();
        final Path sourcePath = this.getSourcePath();
        final ImmutableModuleConfiguration.Builder builder = ImmutableModuleConfiguration.builder().name("html").includePaths(Collections.singletonList(sourcePath)).generator("html").output(this.target.getAbsolutePath());
        if (this.pages != null) {
            builder.putOptions("pages", this.pages);
        }
        final PathMatcher protoMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.proto");
        try {
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (protoMatcher.matches(file)) {
                        String protoFile = sourcePath.relativize(file).toString();
                        builder.addProtoFiles(HtmlGeneratorMojo.this.normalizeProtoPath(protoFile));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Can not build source files list", (Throwable)e);
        }
        ImmutableModuleConfiguration moduleConfiguration = builder.build();
        LOGGER.debug("Module configuration = {}", (Object)moduleConfiguration);
        compiler.compile((ModuleConfiguration)moduleConfiguration);
    }
}

