/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.maven;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    protected MojoExecution execution;
    @Parameter
    protected File source;
    @Parameter
    protected List<String> includes;
    @Parameter
    protected List<String> excludes;

    protected Path getSourcePath() {
        String basedir;
        if (this.source != null) {
            return this.source.toPath();
        }
        String phase = this.execution.getLifecyclePhase();
        try {
            basedir = this.project.getBasedir().getCanonicalPath();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        String sourcePath = LifecyclePhase.GENERATE_TEST_SOURCES.id().equals(phase) ? basedir + "/src/test/proto/" : basedir + "/src/main/proto/";
        return Paths.get(sourcePath, new String[0]);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
    }

    protected String normalizeProtoPath(String protoFilePath) {
        String normalizedPath = File.separatorChar == '\\' ? protoFilePath.replace('\\', '/') : protoFilePath;
        return normalizedPath;
    }
}

