/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.JsonIOUtil;
import io.protostuff.Schema;
import io.protostuff.UnsignedNumbers;
import org.junit.Assert;
import org.junit.Test;

public class JsonUnsignedSerializationTest {
    public static final String JSON = "{\"uint32\":4294967295,\"uint64\":18446744073709551615,\"fixed32\":4294967295,\"fixed64\":18446744073709551615}";

    @Test
    public void testSerialize() throws Exception {
        UnsignedNumbers msg = new UnsignedNumbers();
        msg.setUint32(Integer.valueOf(-1));
        msg.setFixed32(Integer.valueOf(-1));
        msg.setUint64(Long.valueOf(-1L));
        msg.setFixed64(Long.valueOf(-1L));
        byte[] bytes = JsonIOUtil.toByteArray((Object)msg, (Schema)UnsignedNumbers.getSchema(), (boolean)false);
        String result = new String(bytes);
        Assert.assertEquals((Object)JSON, (Object)result);
    }

    @Test
    public void testDeserialize() throws Exception {
        UnsignedNumbers msg = new UnsignedNumbers();
        JsonIOUtil.mergeFrom((byte[])JSON.getBytes(), (Object)msg, (Schema)UnsignedNumbers.getSchema(), (boolean)false);
        Assert.assertEquals((Object)-1, (Object)msg.getUint32());
        Assert.assertEquals((Object)-1, (Object)msg.getFixed32());
        Assert.assertEquals((Object)-1L, (Object)msg.getUint64());
        Assert.assertEquals((Object)-1L, (Object)msg.getFixed64());
    }

    @Test
    public void testDeserializeDataSerializedAsSignedNumbers_backward_comp() throws Exception {
        UnsignedNumbers msg = new UnsignedNumbers();
        String oldJson = "{\"uint32\":-1,\"uint64\":-1,\"fixed32\":-1,\"fixed64\":-1}";
        JsonIOUtil.mergeFrom((byte[])oldJson.getBytes(), (Object)msg, (Schema)UnsignedNumbers.getSchema(), (boolean)false);
        Assert.assertEquals((Object)-1, (Object)msg.getUint32());
        Assert.assertEquals((Object)-1, (Object)msg.getFixed32());
        Assert.assertEquals((Object)-1L, (Object)msg.getUint64());
        Assert.assertEquals((Object)-1L, (Object)msg.getFixed64());
    }
}

