/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.FPNumbers;
import io.protostuff.JsonIOUtil;
import org.junit.Assert;
import org.junit.Test;

public class JsonInfNaNSerializationTest {
    public static final String JSONPositiveInfinity = "{\"float\":\"Infinity\",\"double\":\"Infinity\"}";
    public static final String JSONNegativeInfinity = "{\"float\":\"-Infinity\",\"double\":\"-Infinity\"}";
    public static final String JSONNaN = "{\"float\":\"NaN\",\"double\":\"NaN\"}";

    @Test
    public void testSerializePositiveInfinity() throws Exception {
        FPNumbers msg = new FPNumbers();
        msg.setFloat(Float.valueOf(Float.POSITIVE_INFINITY));
        msg.setDouble(Double.POSITIVE_INFINITY);
        byte[] bytes = JsonIOUtil.toByteArray((Object)msg, FPNumbers.getSchema(), (boolean)false);
        String result = new String(bytes);
        Assert.assertEquals((Object)JSONPositiveInfinity, (Object)result);
    }

    @Test
    public void testDeserializePositiveInfinity() throws Exception {
        FPNumbers msg = new FPNumbers();
        JsonIOUtil.mergeFrom((byte[])JSONPositiveInfinity.getBytes(), (Object)msg, FPNumbers.getSchema(), (boolean)false);
        Assert.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)msg.getFloat());
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)msg.getDouble());
    }

    @Test
    public void testSerializeNegativeInfinity() throws Exception {
        FPNumbers msg = new FPNumbers();
        msg.setFloat(Float.valueOf(Float.NEGATIVE_INFINITY));
        msg.setDouble(Double.NEGATIVE_INFINITY);
        byte[] bytes = JsonIOUtil.toByteArray((Object)msg, FPNumbers.getSchema(), (boolean)false);
        String result = new String(bytes);
        Assert.assertEquals((Object)JSONNegativeInfinity, (Object)result);
    }

    @Test
    public void testDeserializeNegativeInfinity() throws Exception {
        FPNumbers msg = new FPNumbers();
        JsonIOUtil.mergeFrom((byte[])JSONNegativeInfinity.getBytes(), (Object)msg, FPNumbers.getSchema(), (boolean)false);
        Assert.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)msg.getFloat());
        Assert.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)msg.getDouble());
    }

    @Test
    public void testSerializeNaN() throws Exception {
        FPNumbers msg = new FPNumbers();
        msg.setFloat(Float.valueOf(Float.NaN));
        msg.setDouble(Double.NaN);
        byte[] bytes = JsonIOUtil.toByteArray((Object)msg, FPNumbers.getSchema(), (boolean)false);
        String result = new String(bytes);
        Assert.assertEquals((Object)JSONNaN, (Object)result);
    }

    @Test
    public void testDeserializeNaN() throws Exception {
        FPNumbers msg = new FPNumbers();
        JsonIOUtil.mergeFrom((byte[])JSONNaN.getBytes(), (Object)msg, FPNumbers.getSchema(), (boolean)false);
        Assert.assertEquals((Object)Float.valueOf(Float.NaN), (Object)msg.getFloat());
        Assert.assertEquals((Object)Double.NaN, (Object)msg.getDouble());
    }
}

