/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.JsonIOUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.SerializableObjects;
import io.protostuff.StringSerializer;
import io.protostuff.runtime.AbstractRuntimeMapTest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class AbstractJsonRuntimeMapTest
extends AbstractRuntimeMapTest {
    protected abstract boolean isNumeric();

    protected <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema) throws IOException {
        JsonIOUtil.mergeFrom((byte[])data, (int)offset, (int)length, message, schema, (boolean)this.isNumeric());
    }

    protected <T> void mergeFrom(InputStream in, T message, Schema<T> schema) throws IOException {
        JsonIOUtil.mergeFrom((InputStream)in, message, schema, (boolean)this.isNumeric());
    }

    protected <T> byte[] toByteArray(T message, Schema<T> schema) {
        return JsonIOUtil.toByteArray(message, schema, (boolean)this.isNumeric());
    }

    protected <T> void writeTo(OutputStream out, T message, Schema<T> schema) throws IOException {
        JsonIOUtil.writeTo((OutputStream)out, message, schema, (boolean)this.isNumeric());
    }

    protected <T> void roundTrip(T message, Schema<T> schema, Pipe.Schema<T> pipeSchema) throws Exception {
        byte[] json = JsonIOUtil.toByteArray(message, schema, (boolean)this.isNumeric());
        ByteArrayInputStream jsonStream = new ByteArrayInputStream(json);
        byte[] protostuff = ProtostuffIOUtil.toByteArray((Object)JsonIOUtil.newPipe((byte[])json, (int)0, (int)json.length, (boolean)this.isNumeric()), pipeSchema, (LinkedBuffer)AbstractJsonRuntimeMapTest.buf());
        byte[] protostuffFromStream = ProtostuffIOUtil.toByteArray((Object)JsonIOUtil.newPipe((InputStream)jsonStream, (boolean)this.isNumeric()), pipeSchema, (LinkedBuffer)AbstractJsonRuntimeMapTest.buf());
        AbstractJsonRuntimeMapTest.assertTrue((boolean)Arrays.equals(protostuff, protostuffFromStream));
        Object parsedMessage = schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])protostuff, (Object)parsedMessage, schema);
        SerializableObjects.assertEquals(message, (Object)parsedMessage);
        ByteArrayInputStream protostuffStream = new ByteArrayInputStream(protostuff);
        byte[] jsonRoundTrip = JsonIOUtil.toByteArray((Object)ProtostuffIOUtil.newPipe((byte[])protostuff, (int)0, (int)protostuff.length), pipeSchema, (boolean)this.isNumeric());
        byte[] jsonRoundTripFromStream = JsonIOUtil.toByteArray((Object)ProtostuffIOUtil.newPipe((InputStream)protostuffStream), pipeSchema, (boolean)this.isNumeric());
        AbstractJsonRuntimeMapTest.assertTrue((jsonRoundTrip.length == jsonRoundTripFromStream.length ? 1 : 0) != 0);
        String strJsonRoundTrip = StringSerializer.STRING.deser((byte[])jsonRoundTrip);
        AbstractJsonRuntimeMapTest.assertEquals((String)strJsonRoundTrip, (String)StringSerializer.STRING.deser((byte[])jsonRoundTripFromStream));
        AbstractJsonRuntimeMapTest.assertTrue((jsonRoundTrip.length == json.length ? 1 : 0) != 0);
        AbstractJsonRuntimeMapTest.assertEquals((String)strJsonRoundTrip, (String)StringSerializer.STRING.deser((byte[])json));
    }
}

