/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.JsonIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonUnknownFieldTest {
    public static final String NORMAL_MESSAGE = "{\"field1\":42,\"field2\":\"testValue\"}";
    public static final String UNKNOWN_SCALAR_FIELD = "{\"field1\":42,\"unknownField\":42,\"field2\":\"testValue\"}";
    public static final String UNKNOWN_ARRAY_FIELD = "{\"field1\":42,\"unknownField\":[{\"x\":1}, {\"x\":1, \"y\": [1,2,3]}],\"field2\":\"testValue\"}";
    public static final String UNKNOWN_EMPTY_MESSAGE_FIELD = "{\"field1\":42,\"unknownField\":{},\"field2\":\"testValue\"}";
    public static final String UNKNOWN_NESTED_MESSAGE_FIELD = "{\"field1\":42,\"unknownField\":{\"a\":0,\"field1\":43,\"anotherNestedField\":{\"b\":0,\"c\":[1, 2, 3],\"thirdNestedField\":{\"e\":1,\"f\":\"foobar\"}}},\"field2\":\"testValue\"}";
    public static final Schema<TestMessage> SCHEMA = RuntimeSchema.getSchema(TestMessage.class);
    private TestMessage instance;

    @Before
    public void setUp() throws Exception {
        this.instance = (TestMessage)SCHEMA.newMessage();
    }

    @Test
    public void normalMessage() throws Exception {
        JsonIOUtil.mergeFrom((byte[])NORMAL_MESSAGE.getBytes(), (Object)this.instance, SCHEMA, (boolean)false);
        this.checkKnownFields(this.instance);
    }

    @Test
    public void unknownScalarField() throws Exception {
        JsonIOUtil.mergeFrom((byte[])UNKNOWN_SCALAR_FIELD.getBytes(), (Object)this.instance, SCHEMA, (boolean)false);
        this.checkKnownFields(this.instance);
    }

    @Test
    public void unknownArrayField() throws Exception {
        JsonIOUtil.mergeFrom((byte[])UNKNOWN_ARRAY_FIELD.getBytes(), (Object)this.instance, SCHEMA, (boolean)false);
        this.checkKnownFields(this.instance);
    }

    @Test
    public void unknownEmptyMessageField() throws Exception {
        JsonIOUtil.mergeFrom((byte[])UNKNOWN_EMPTY_MESSAGE_FIELD.getBytes(), (Object)this.instance, SCHEMA, (boolean)false);
        this.checkKnownFields(this.instance);
    }

    @Test
    public void unknownNestedMessageField() throws Exception {
        JsonIOUtil.mergeFrom((byte[])UNKNOWN_NESTED_MESSAGE_FIELD.getBytes(), (Object)this.instance, SCHEMA, (boolean)false);
        this.checkKnownFields(this.instance);
    }

    private void checkKnownFields(TestMessage instance) {
        Assert.assertEquals((long)42L, (long)instance.field1);
        Assert.assertEquals((Object)"testValue", (Object)instance.field2);
    }

    static class TestMessage {
        public int field1;
        public String field2;

        TestMessage() {
        }
    }
}

