/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Bar;
import io.protostuff.Baz;
import io.protostuff.ByteString;
import io.protostuff.CompareOutputsTest;
import io.protostuff.Foo;
import io.protostuff.JsonIOUtil;
import io.protostuff.JsonXIOUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.Message;
import io.protostuff.Schema;
import io.protostuff.SerializableObjects;
import io.protostuff.StringSerializer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;

public class JsonCompareOutputsTest
extends TestCase {
    static final Baz negativeBaz = new Baz(-567, "negativeBaz", -202020202L);
    static final Bar negativeBar = new Bar(-12, "negativeBar", negativeBaz, Bar.Status.STARTED, null, true, -130.031f, -1000.0001, -101010101L);
    static final Baz baz = new Baz(567, "baz", 202020202L);
    static final Bar bar = new Bar(890, "bar", baz, Bar.Status.STARTED, ByteString.copyFromUtf8((String)"byte_bar"), true, 150.051f, 2000.0002, 303030303L);
    public static final Foo foo = SerializableObjects.newFoo((Integer[])new Integer[]{90210, -90210, 0}, (String[])new String[]{"a\b\t\u000b\r\n\f\t\b\"\\", "ef", "gh", "12345678901234567890123456789012345678901234567890"}, (Bar[])new Bar[]{bar, negativeBar}, (Foo.EnumSample[])new Foo.EnumSample[]{Foo.EnumSample.TYPE0, Foo.EnumSample.TYPE2}, (ByteString[])new ByteString[]{ByteString.copyFromUtf8((String)"byte1"), ByteString.copyFromUtf8((String)"byte2")}, (Boolean[])new Boolean[]{true, false}, (Float[])new Float[]{Float.valueOf(1234.4321f), Float.valueOf(-1234.4321f), Float.valueOf(0.0f)}, (Double[])new Double[]{1.234567887654321E7, -1.234567887654321E7, 0.0}, (Long[])new Long[]{7060504030201L, -7060504030201L, 0L});
    static final int BUF_SIZE = 1024;
    public static final CompareOutputsTest.Serializer JSON_OUTPUT = new CompareOutputsTest.Serializer(){

        public <T extends Message<T>> byte[] serialize(T message) {
            return JsonIOUtil.toByteArray(message, (Schema)message.cachedSchema(), (boolean)false);
        }

        public String getName() {
            return "json-output";
        }
    };
    public static final CompareOutputsTest.Serializer JSON_OUTPUT_NUMERIC = new CompareOutputsTest.Serializer(){

        public <T extends Message<T>> byte[] serialize(T message) {
            return JsonIOUtil.toByteArray(message, (Schema)message.cachedSchema(), (boolean)true);
        }

        public String getName() {
            return "json-output-numeric";
        }
    };
    public static final CompareOutputsTest.Serializer JSON_BUFFERED_OUTPUT = new CompareOutputsTest.Serializer(){
        final LinkedBuffer buffer = LinkedBuffer.allocate((int)1024);

        public <T extends Message<T>> byte[] serialize(T message) {
            try {
                byte[] byArray = JsonXIOUtil.toByteArray(message, (Schema)message.cachedSchema(), (boolean)false, (LinkedBuffer)this.buffer);
                return byArray;
            }
            finally {
                this.buffer.clear();
            }
        }

        public String getName() {
            return "json-buffered-output";
        }
    };
    public static final CompareOutputsTest.Serializer JSON_STREAMED_OUTPUT = new CompareOutputsTest.Serializer(){
        final LinkedBuffer buffer = LinkedBuffer.allocate((int)1024);

        public <T extends Message<T>> byte[] serialize(T message) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                JsonXIOUtil.writeTo((OutputStream)out, message, (boolean)false, (LinkedBuffer)this.buffer);
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.buffer.clear();
            }
        }

        public String getName() {
            return "json-streamed-output";
        }
    };
    public static final CompareOutputsTest.Serializer JSON_BUFFERED_OUTPUT_NUMERIC = new CompareOutputsTest.Serializer(){
        final LinkedBuffer buffer = LinkedBuffer.allocate((int)1024);

        public <T extends Message<T>> byte[] serialize(T message) {
            try {
                byte[] byArray = JsonXIOUtil.toByteArray(message, (Schema)message.cachedSchema(), (boolean)true, (LinkedBuffer)this.buffer);
                return byArray;
            }
            finally {
                this.buffer.clear();
            }
        }

        public String getName() {
            return "json-buffered-output-numeric";
        }
    };
    public static final CompareOutputsTest.Serializer JSON_STREAMED_OUTPUT_NUMERIC = new CompareOutputsTest.Serializer(){
        final LinkedBuffer buffer = LinkedBuffer.allocate((int)1024);

        public <T extends Message<T>> byte[] serialize(T message) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                JsonXIOUtil.writeTo((OutputStream)out, message, (boolean)true, (LinkedBuffer)this.buffer);
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.buffer.clear();
            }
        }

        public String getName() {
            return "json-streamed-output-numeric";
        }
    };
    static final CompareOutputsTest.Serializer[] JSON_SERIALIZERS = new CompareOutputsTest.Serializer[]{JSON_OUTPUT, JSON_OUTPUT_NUMERIC, JSON_BUFFERED_OUTPUT, JSON_BUFFERED_OUTPUT_NUMERIC, JSON_STREAMED_OUTPUT, JSON_STREAMED_OUTPUT_NUMERIC};

    public void testFoo() throws Exception {
        Foo fooCompare = foo;
        byte[] jo = JSON_OUTPUT.serialize((Message)fooCompare);
        byte[] jbo = JSON_BUFFERED_OUTPUT.serialize((Message)fooCompare);
        byte[] jso = JSON_STREAMED_OUTPUT.serialize((Message)fooCompare);
        JsonCompareOutputsTest.assertTrue((jo.length == jbo.length ? 1 : 0) != 0);
        JsonCompareOutputsTest.assertTrue((jso.length == jo.length ? 1 : 0) != 0);
        String joString = StringSerializer.STRING.deser((byte[])jo);
        String jboString = StringSerializer.STRING.deser((byte[])jbo);
        JsonCompareOutputsTest.assertEquals((String)joString, (String)jboString);
        JsonCompareOutputsTest.assertEquals((String)joString, (String)StringSerializer.STRING.deser((byte[])jso));
    }

    public void testFooNumeric() throws Exception {
        Foo fooCompare = foo;
        byte[] jo = JSON_OUTPUT_NUMERIC.serialize((Message)fooCompare);
        byte[] jbo = JSON_BUFFERED_OUTPUT_NUMERIC.serialize((Message)fooCompare);
        byte[] jso = JSON_STREAMED_OUTPUT_NUMERIC.serialize((Message)fooCompare);
        JsonCompareOutputsTest.assertTrue((jo.length == jbo.length ? 1 : 0) != 0);
        JsonCompareOutputsTest.assertTrue((jso.length == jo.length ? 1 : 0) != 0);
        String joString = StringSerializer.STRING.deser((byte[])jo);
        String jboString = StringSerializer.STRING.deser((byte[])jbo);
        JsonCompareOutputsTest.assertEquals((String)joString, (String)jboString);
        JsonCompareOutputsTest.assertEquals((String)joString, (String)StringSerializer.STRING.deser((byte[])jso));
    }

    public void testBar() throws Exception {
        for (Bar barCompare : new Bar[]{bar, negativeBar}) {
            byte[] jo = JSON_OUTPUT.serialize((Message)barCompare);
            byte[] jbo = JSON_BUFFERED_OUTPUT.serialize((Message)barCompare);
            byte[] jso = JSON_STREAMED_OUTPUT.serialize((Message)barCompare);
            JsonCompareOutputsTest.assertTrue((jo.length == jbo.length ? 1 : 0) != 0);
            JsonCompareOutputsTest.assertTrue((jso.length == jo.length ? 1 : 0) != 0);
            String joString = StringSerializer.STRING.deser((byte[])jo);
            String jboString = StringSerializer.STRING.deser((byte[])jbo);
            JsonCompareOutputsTest.assertEquals((String)joString, (String)jboString);
            JsonCompareOutputsTest.assertEquals((String)joString, (String)StringSerializer.STRING.deser((byte[])jso));
        }
    }

    public void testBarNumeric() throws Exception {
        for (Bar barCompare : new Bar[]{bar, negativeBar}) {
            byte[] jo = JSON_OUTPUT_NUMERIC.serialize((Message)barCompare);
            byte[] jbo = JSON_BUFFERED_OUTPUT_NUMERIC.serialize((Message)barCompare);
            byte[] jso = JSON_STREAMED_OUTPUT_NUMERIC.serialize((Message)barCompare);
            JsonCompareOutputsTest.assertTrue((jo.length == jbo.length ? 1 : 0) != 0);
            JsonCompareOutputsTest.assertTrue((jso.length == jo.length ? 1 : 0) != 0);
            String joString = StringSerializer.STRING.deser((byte[])jo);
            String jboString = StringSerializer.STRING.deser((byte[])jbo);
            JsonCompareOutputsTest.assertEquals((String)joString, (String)jboString);
            JsonCompareOutputsTest.assertEquals((String)joString, (String)StringSerializer.STRING.deser((byte[])jso));
        }
    }

    public void testBaz() throws Exception {
        for (Baz bazCompare : new Baz[]{baz, negativeBaz}) {
            byte[] jo = JSON_OUTPUT.serialize((Message)bazCompare);
            byte[] jbo = JSON_BUFFERED_OUTPUT.serialize((Message)bazCompare);
            byte[] jso = JSON_STREAMED_OUTPUT.serialize((Message)bazCompare);
            JsonCompareOutputsTest.assertTrue((jo.length == jbo.length ? 1 : 0) != 0);
            JsonCompareOutputsTest.assertTrue((jso.length == jo.length ? 1 : 0) != 0);
            String joString = StringSerializer.STRING.deser((byte[])jo);
            String jboString = StringSerializer.STRING.deser((byte[])jbo);
            JsonCompareOutputsTest.assertEquals((String)joString, (String)jboString);
            JsonCompareOutputsTest.assertEquals((String)joString, (String)StringSerializer.STRING.deser((byte[])jso));
        }
    }

    public void testBazNumeric() throws Exception {
        for (Baz bazCompare : new Baz[]{baz, negativeBaz}) {
            byte[] jo = JSON_OUTPUT_NUMERIC.serialize((Message)bazCompare);
            byte[] jbo = JSON_BUFFERED_OUTPUT_NUMERIC.serialize((Message)bazCompare);
            byte[] jso = JSON_STREAMED_OUTPUT_NUMERIC.serialize((Message)bazCompare);
            JsonCompareOutputsTest.assertTrue((jo.length == jbo.length ? 1 : 0) != 0);
            JsonCompareOutputsTest.assertTrue((jso.length == jo.length ? 1 : 0) != 0);
            String joString = StringSerializer.STRING.deser((byte[])jo);
            String jboString = StringSerializer.STRING.deser((byte[])jbo);
            JsonCompareOutputsTest.assertEquals((String)joString, (String)jboString);
            JsonCompareOutputsTest.assertEquals((String)joString, (String)StringSerializer.STRING.deser((byte[])jso));
        }
    }

    public void testBenchmark() throws Exception {
        if (!"false".equals(System.getProperty("benchmark.skip"))) {
            return;
        }
        String dir = System.getProperty("benchmark.output_dir");
        PrintStream out = dir == null ? System.out : new PrintStream(new FileOutputStream(new File(new File(dir), "protostuff-json-" + System.currentTimeMillis() + ".txt"), true));
        int warmups = Integer.getInteger("benchmark.warmups", 200000);
        int loops = Integer.getInteger("benchmark.loops", 2000000);
        String title = "protostuff-json serialization benchmark for " + loops + " runs";
        out.println(title);
        out.println();
        CompareOutputsTest.start((Message)foo, (CompareOutputsTest.Serializer[])JSON_SERIALIZERS, (PrintStream)out, (int)warmups, (int)loops);
        if (System.out != out) {
            out.close();
        }
    }

    public static void main(String[] args) throws Exception {
        String dir = System.getProperty("benchmark.output_dir");
        PrintStream out = dir == null ? System.out : new PrintStream(new FileOutputStream(new File(new File(dir), "protostuff-json-" + System.currentTimeMillis() + ".txt"), true));
        int warmups = Integer.getInteger("benchmark.warmups", 100000);
        int loops = Integer.getInteger("benchmark.loops", 1000000);
        String title = "protostuff-json serialization benchmark for " + loops + " runs";
        out.println(title);
        out.println();
        CompareOutputsTest.start((Message)foo, (CompareOutputsTest.Serializer[])JSON_SERIALIZERS, (PrintStream)out, (int)warmups, (int)loops);
        if (System.out != out) {
            out.close();
        }
    }
}

