/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.AbstractTest;
import io.protostuff.Bar;
import io.protostuff.Baz;
import io.protostuff.Foo;
import io.protostuff.LinkedBuffer;
import io.protostuff.Pipe;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.SerializableObjects;
import io.protostuff.SmileIOUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;

public class SmilePipeTest
extends AbstractTest {
    static <T> void protobufRoundTrip(T message, Schema<T> schema, Pipe.Schema<T> pipeSchema) throws Exception {
        byte[] protobuf = ProtobufIOUtil.toByteArray(message, schema, (LinkedBuffer)SmilePipeTest.buf());
        ByteArrayInputStream protobufStream = new ByteArrayInputStream(protobuf);
        byte[] smile = SmileIOUtil.toByteArray((Object)ProtobufIOUtil.newPipe((byte[])protobuf, (int)0, (int)protobuf.length), pipeSchema, (boolean)false);
        byte[] smileFromStream = SmileIOUtil.toByteArray((Object)ProtobufIOUtil.newPipe((InputStream)protobufStream), pipeSchema, (boolean)false);
        SmilePipeTest.assertTrue((boolean)Arrays.equals(smile, smileFromStream));
        Object parsedMessage = schema.newMessage();
        SmileIOUtil.mergeFrom((byte[])smile, (Object)parsedMessage, schema, (boolean)false);
        SerializableObjects.assertEquals(message, (Object)parsedMessage);
        ByteArrayInputStream smileStream = new ByteArrayInputStream(smile);
        byte[] protobufRoundTrip = ProtobufIOUtil.toByteArray((Object)SmileIOUtil.newPipe((byte[])smile, (int)0, (int)smile.length, (boolean)false), pipeSchema, (LinkedBuffer)SmilePipeTest.buf());
        byte[] protobufRoundTripFromStream = ProtobufIOUtil.toByteArray((Object)SmileIOUtil.newPipe((InputStream)smileStream, (boolean)false), pipeSchema, (LinkedBuffer)SmilePipeTest.buf());
        SmilePipeTest.assertTrue((boolean)Arrays.equals(protobufRoundTrip, protobufRoundTripFromStream));
        SmilePipeTest.assertTrue((boolean)Arrays.equals(protobufRoundTrip, protobuf));
    }

    static <T> void protostuffRoundTrip(T message, Schema<T> schema, Pipe.Schema<T> pipeSchema) throws Exception {
        byte[] protostuff = ProtostuffIOUtil.toByteArray(message, schema, (LinkedBuffer)SmilePipeTest.buf());
        ByteArrayInputStream protostuffStream = new ByteArrayInputStream(protostuff);
        byte[] smile = SmileIOUtil.toByteArray((Object)ProtostuffIOUtil.newPipe((byte[])protostuff, (int)0, (int)protostuff.length), pipeSchema, (boolean)false);
        byte[] smileFromStream = SmileIOUtil.toByteArray((Object)ProtostuffIOUtil.newPipe((InputStream)protostuffStream), pipeSchema, (boolean)false);
        SmilePipeTest.assertTrue((boolean)Arrays.equals(smile, smileFromStream));
        Object parsedMessage = schema.newMessage();
        SmileIOUtil.mergeFrom((byte[])smile, (Object)parsedMessage, schema, (boolean)false);
        SerializableObjects.assertEquals(message, (Object)parsedMessage);
        ByteArrayInputStream smileStream = new ByteArrayInputStream(smile);
        byte[] protostuffRoundTrip = ProtostuffIOUtil.toByteArray((Object)SmileIOUtil.newPipe((byte[])smile, (int)0, (int)smile.length, (boolean)false), pipeSchema, (LinkedBuffer)SmilePipeTest.buf());
        byte[] protostuffRoundTripFromStream = ProtostuffIOUtil.toByteArray((Object)SmileIOUtil.newPipe((InputStream)smileStream, (boolean)false), pipeSchema, (LinkedBuffer)SmilePipeTest.buf());
        SmilePipeTest.assertTrue((boolean)Arrays.equals(protostuffRoundTrip, protostuffRoundTripFromStream));
        SmilePipeTest.assertTrue((boolean)Arrays.equals(protostuffRoundTrip, protostuff));
    }

    public void testFoo() throws Exception {
        Foo foo = SerializableObjects.foo;
        SmilePipeTest.protobufRoundTrip(foo, Foo.getSchema(), Foo.getPipeSchema());
        SmilePipeTest.protostuffRoundTrip(foo, Foo.getSchema(), Foo.getPipeSchema());
    }

    public void testBar() throws Exception {
        Bar bar = SerializableObjects.bar;
        SmilePipeTest.protobufRoundTrip(bar, Bar.getSchema(), Bar.getPipeSchema());
        SmilePipeTest.protostuffRoundTrip(bar, Bar.getSchema(), Bar.getPipeSchema());
    }

    public void testBaz() throws Exception {
        Baz baz = SerializableObjects.baz;
        SmilePipeTest.protobufRoundTrip(baz, Baz.getSchema(), Baz.getPipeSchema());
        SmilePipeTest.protostuffRoundTrip(baz, Baz.getSchema(), Baz.getPipeSchema());
    }
}

