/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.AbstractTest;
import io.protostuff.Bar;
import io.protostuff.Baz;
import io.protostuff.Foo;
import io.protostuff.JsonIOUtil;
import io.protostuff.JsonXIOUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.Pipe;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.SerializableObjects;
import io.protostuff.StringSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class JsonPipeTest
extends AbstractTest {
    static <T> void protobufRoundTrip(T message, Schema<T> schema, Pipe.Schema<T> pipeSchema, boolean numeric) throws Exception {
        byte[] jsonFromStream;
        byte[] protobuf = ProtobufIOUtil.toByteArray(message, schema, (LinkedBuffer)JsonPipeTest.buf());
        ByteArrayInputStream protobufStream = new ByteArrayInputStream(protobuf);
        byte[] json = JsonIOUtil.toByteArray((Object)ProtobufIOUtil.newPipe((byte[])protobuf, (int)0, (int)protobuf.length), pipeSchema, (boolean)numeric);
        JsonPipeTest.assertTrue((json.length == (jsonFromStream = JsonIOUtil.toByteArray((Object)ProtobufIOUtil.newPipe((InputStream)protobufStream), pipeSchema, (boolean)numeric)).length ? 1 : 0) != 0);
        JsonPipeTest.assertEquals((String)StringSerializer.STRING.deser((byte[])json), (String)StringSerializer.STRING.deser((byte[])jsonFromStream));
        Object parsedMessage = schema.newMessage();
        JsonIOUtil.mergeFrom((byte[])json, (Object)parsedMessage, schema, (boolean)numeric);
        SerializableObjects.assertEquals(message, (Object)parsedMessage);
        ByteArrayInputStream jsonStream = new ByteArrayInputStream(json);
        byte[] protobufRoundTrip = ProtobufIOUtil.toByteArray((Object)JsonIOUtil.newPipe((byte[])json, (int)0, (int)json.length, (boolean)numeric), pipeSchema, (LinkedBuffer)JsonPipeTest.buf());
        byte[] protobufRoundTripFromStream = ProtobufIOUtil.toByteArray((Object)JsonIOUtil.newPipe((InputStream)jsonStream, (boolean)numeric), pipeSchema, (LinkedBuffer)JsonPipeTest.buf());
        JsonPipeTest.assertTrue((boolean)Arrays.equals(protobufRoundTrip, protobufRoundTripFromStream));
        JsonPipeTest.assertTrue((boolean)Arrays.equals(protobufRoundTrip, protobuf));
        JsonPipeTest.checkCompat(json, jsonFromStream, protobuf, pipeSchema, numeric, false);
    }

    static <T> void protostuffRoundTrip(T message, Schema<T> schema, Pipe.Schema<T> pipeSchema, boolean numeric) throws Exception {
        byte[] jsonFromStream;
        byte[] protostuff = ProtostuffIOUtil.toByteArray(message, schema, (LinkedBuffer)JsonPipeTest.buf());
        ByteArrayInputStream protostuffStream = new ByteArrayInputStream(protostuff);
        byte[] json = JsonIOUtil.toByteArray((Object)ProtostuffIOUtil.newPipe((byte[])protostuff, (int)0, (int)protostuff.length), pipeSchema, (boolean)numeric);
        JsonPipeTest.assertTrue((json.length == (jsonFromStream = JsonIOUtil.toByteArray((Object)ProtostuffIOUtil.newPipe((InputStream)protostuffStream), pipeSchema, (boolean)numeric)).length ? 1 : 0) != 0);
        JsonPipeTest.assertEquals((String)StringSerializer.STRING.deser((byte[])json), (String)StringSerializer.STRING.deser((byte[])jsonFromStream));
        Object parsedMessage = schema.newMessage();
        JsonIOUtil.mergeFrom((byte[])json, (Object)parsedMessage, schema, (boolean)numeric);
        SerializableObjects.assertEquals(message, (Object)parsedMessage);
        ByteArrayInputStream jsonStream = new ByteArrayInputStream(json);
        byte[] protostuffRoundTrip = ProtostuffIOUtil.toByteArray((Object)JsonIOUtil.newPipe((byte[])json, (int)0, (int)json.length, (boolean)numeric), pipeSchema, (LinkedBuffer)JsonPipeTest.buf());
        byte[] protostuffRoundTripFromStream = ProtostuffIOUtil.toByteArray((Object)JsonIOUtil.newPipe((InputStream)jsonStream, (boolean)numeric), pipeSchema, (LinkedBuffer)JsonPipeTest.buf());
        JsonPipeTest.assertTrue((boolean)Arrays.equals(protostuffRoundTrip, protostuffRoundTripFromStream));
        JsonPipeTest.assertTrue((boolean)Arrays.equals(protostuffRoundTrip, protostuff));
        JsonPipeTest.checkCompat(json, jsonFromStream, protostuff, pipeSchema, numeric, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void checkCompat(byte[] json, byte[] jsonFromStream, byte[] source, Pipe.Schema<T> pipeSchema, boolean numeric, boolean protostuff) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(source);
        LinkedBuffer buffer = JsonPipeTest.buf();
        try {
            JsonXIOUtil.writeTo((OutputStream)out, (Object)(protostuff ? ProtostuffIOUtil.newPipe((InputStream)in) : ProtobufIOUtil.newPipe((InputStream)in)), pipeSchema, (boolean)numeric, (LinkedBuffer)buffer);
        }
        finally {
            buffer.clear();
        }
        byte[] jsonxFromStream = out.toByteArray();
        byte[] jsonx = JsonXIOUtil.toByteArray((Object)(protostuff ? ProtostuffIOUtil.newPipe((byte[])source, (int)0, (int)source.length) : ProtobufIOUtil.newPipe((byte[])source, (int)0, (int)source.length)), pipeSchema, (boolean)numeric, (LinkedBuffer)JsonPipeTest.buf());
        JsonPipeTest.assertTrue((jsonx.length == jsonxFromStream.length ? 1 : 0) != 0);
        JsonPipeTest.assertEquals((String)StringSerializer.STRING.deser((byte[])jsonx), (String)StringSerializer.STRING.deser((byte[])jsonxFromStream));
        JsonPipeTest.assertEquals((String)StringSerializer.STRING.deser((byte[])json), (String)StringSerializer.STRING.deser((byte[])jsonx));
    }

    public void testFoo() throws Exception {
        Foo foo = SerializableObjects.foo;
        JsonPipeTest.protobufRoundTrip(foo, Foo.getSchema(), Foo.getPipeSchema(), false);
        JsonPipeTest.protostuffRoundTrip(foo, Foo.getSchema(), Foo.getPipeSchema(), false);
        JsonPipeTest.protobufRoundTrip(foo, Foo.getSchema(), Foo.getPipeSchema(), true);
        JsonPipeTest.protostuffRoundTrip(foo, Foo.getSchema(), Foo.getPipeSchema(), true);
    }

    public void testBar() throws Exception {
        Bar bar = SerializableObjects.bar;
        JsonPipeTest.protobufRoundTrip(bar, Bar.getSchema(), Bar.getPipeSchema(), false);
        JsonPipeTest.protostuffRoundTrip(bar, Bar.getSchema(), Bar.getPipeSchema(), false);
        JsonPipeTest.protobufRoundTrip(bar, Bar.getSchema(), Bar.getPipeSchema(), true);
        JsonPipeTest.protostuffRoundTrip(bar, Bar.getSchema(), Bar.getPipeSchema(), true);
    }

    public void testBaz() throws Exception {
        Baz baz = SerializableObjects.baz;
        JsonPipeTest.protobufRoundTrip(baz, Baz.getSchema(), Baz.getPipeSchema(), false);
        JsonPipeTest.protostuffRoundTrip(baz, Baz.getSchema(), Baz.getPipeSchema(), false);
        JsonPipeTest.protobufRoundTrip(baz, Baz.getSchema(), Baz.getPipeSchema(), true);
        JsonPipeTest.protostuffRoundTrip(baz, Baz.getSchema(), Baz.getPipeSchema(), true);
    }
}

