/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import com.fasterxml.jackson.core.JsonParser;
import io.protostuff.Bar;
import io.protostuff.Baz;
import io.protostuff.ByteString;
import io.protostuff.Foo;
import io.protostuff.JsonIOUtil;
import io.protostuff.Schema;
import io.protostuff.SerializableObjects;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class JsonCoreSerDeserTest
extends TestCase {
    public void testFoo() throws Exception {
        Foo fooCompare = SerializableObjects.foo;
        Foo dfoo = new Foo();
        byte[] data = JsonIOUtil.toByteArray((Object)fooCompare, (Schema)fooCompare.cachedSchema(), (boolean)false);
        JsonIOUtil.mergeFrom((byte[])data, (Object)dfoo, (Schema)dfoo.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)fooCompare, (Object)dfoo);
    }

    public void testBar() throws Exception {
        for (Bar barCompare : new Bar[]{SerializableObjects.bar, SerializableObjects.negativeBar}) {
            Bar dbar = new Bar();
            byte[] data = JsonIOUtil.toByteArray((Object)barCompare, (Schema)barCompare.cachedSchema(), (boolean)false);
            JsonIOUtil.mergeFrom((byte[])data, (Object)dbar, (Schema)dbar.cachedSchema(), (boolean)false);
            SerializableObjects.assertEquals((Object)barCompare, (Object)dbar);
        }
    }

    public void testBaz() throws Exception {
        for (Baz bazCompare : new Baz[]{SerializableObjects.baz, SerializableObjects.negativeBaz}) {
            Baz dbaz = new Baz();
            byte[] data = JsonIOUtil.toByteArray((Object)bazCompare, (Schema)bazCompare.cachedSchema(), (boolean)false);
            JsonIOUtil.mergeFrom((byte[])data, (Object)dbaz, (Schema)dbaz.cachedSchema(), (boolean)false);
            SerializableObjects.assertEquals((Object)bazCompare, (Object)dbaz);
        }
    }

    public void testUnknownScalarFields() throws Exception {
        String[] regularMessages = new String[]{"{\"int\":1,\"string\":\"string\",\"double\":555.444,\"id\":1}", "{\"int\":1,\"string\":\"string\",\"id\":2,\"double\":555.444}", "{\"id\":3,\"int\":1,\"string\":\"string\",\"double\":555.444}"};
        for (int i = 0; i < regularMessages.length; ++i) {
            Baz b = new Baz();
            JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser(regularMessages[i]), (Object)b, (Schema)b.cachedSchema(), (boolean)false);
            JsonCoreSerDeserTest.assertTrue((i + 1 == b.getId() ? 1 : 0) != 0);
        }
        String[] numericMessages = new String[]{"{\"4\":1,\"5\":\"string\",\"6\":555.444,\"1\":1}", "{\"4\":1,\"5\":\"string\",\"1\":2,\"6\":555.444}", "{\"1\":3,\"4\":1,\"5\":\"string\",\"6\":555.444}"};
        for (int i = 0; i < numericMessages.length; ++i) {
            Baz b = new Baz();
            JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser(numericMessages[i]), (Object)b, (Schema)b.cachedSchema(), (boolean)true);
            JsonCoreSerDeserTest.assertTrue((i + 1 == b.getId() ? 1 : 0) != 0);
        }
    }

    public void testUnknownScalarFieldsWithArray() throws Exception {
        String[] regularMessages = new String[]{"{\"int\":[1],\"string\":\"string\",\"double\":[555.444],\"id\":1}", "{\"int\":1,\"string\":[\"string\"],\"id\":2,\"double\":[555.444]}", "{\"id\":3,\"int\":[1],\"string\":[\"string\"],\"double\":555.444}"};
        for (int i = 0; i < regularMessages.length; ++i) {
            Baz b = new Baz();
            JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser(regularMessages[i]), (Object)b, (Schema)b.cachedSchema(), (boolean)false);
            JsonCoreSerDeserTest.assertTrue((i + 1 == b.getId() ? 1 : 0) != 0);
        }
        String[] numericMessages = new String[]{"{\"4\":[1],\"5\":\"string\",\"6\":[555.444],\"1\":1}", "{\"4\":1,\"5\":[\"string\"],\"1\":2,\"6\":[555.444]}", "{\"1\":3,\"4\":[1],\"5\":[\"string\"],\"6\":555.444}"};
        for (int i = 0; i < numericMessages.length; ++i) {
            Baz b = new Baz();
            JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser(numericMessages[i]), (Object)b, (Schema)b.cachedSchema(), (boolean)true);
            JsonCoreSerDeserTest.assertTrue((i + 1 == b.getId() ? 1 : 0) != 0);
        }
    }

    public void testListIO() throws Exception {
        ArrayList<Bar> bars = new ArrayList<Bar>();
        bars.add(SerializableObjects.bar);
        bars.add(SerializableObjects.negativeBar);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonIOUtil.writeListTo((OutputStream)out, bars, (Schema)SerializableObjects.bar.cachedSchema(), (boolean)false);
        byte[] data = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        List parsedBars = JsonIOUtil.parseListFrom((InputStream)in, (Schema)SerializableObjects.bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertTrue((parsedBars.size() == bars.size() ? 1 : 0) != 0);
        int i = 0;
        for (Bar b : parsedBars) {
            SerializableObjects.assertEquals(bars.get(i++), (Object)b);
        }
    }

    public void testListEmpty() throws Exception {
        ArrayList bars = new ArrayList();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonIOUtil.writeListTo((OutputStream)out, bars, (Schema)SerializableObjects.bar.cachedSchema(), (boolean)false);
        byte[] data = out.toByteArray();
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"[]");
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        List parsedBars = JsonIOUtil.parseListFrom((InputStream)in, (Schema)SerializableObjects.bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertTrue((parsedBars.size() == bars.size() ? 1 : 0) != 0);
        int i = 0;
        for (Bar b : parsedBars) {
            SerializableObjects.assertEquals(bars.get(i++), (Object)b);
        }
    }

    public void testListIOWithArrays() throws Exception {
        ArrayList<Foo> foos = new ArrayList<Foo>();
        foos.add(SerializableObjects.foo);
        foos.add(SerializableObjects.foo);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonIOUtil.writeListTo((OutputStream)out, foos, (Schema)SerializableObjects.foo.cachedSchema(), (boolean)false);
        byte[] data = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        List parsed = JsonIOUtil.parseListFrom((InputStream)in, (Schema)SerializableObjects.foo.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertTrue((parsed.size() == foos.size() ? 1 : 0) != 0);
        int i = 0;
        for (Foo f : parsed) {
            SerializableObjects.assertEquals(foos.get(i++), (Object)f);
        }
    }

    public void testEmptyMessage() throws Exception {
        Bar bar = new Bar();
        byte[] data = JsonIOUtil.toByteArray((Object)bar, (Schema)bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{}");
        Bar parsedBar = new Bar();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedBar, (Schema)parsedBar.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)bar, (Object)parsedBar);
    }

    public void testEmptyMessageInner() throws Exception {
        Baz baz = new Baz();
        Bar bar = new Bar();
        bar.setSomeBaz(baz);
        byte[] data = JsonIOUtil.toByteArray((Object)bar, (Schema)bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{\"someBaz\":{}}");
        Bar parsedBar = new Bar();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedBar, (Schema)parsedBar.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)bar, (Object)parsedBar);
    }

    public void testPartialEmptyMessage() throws Exception {
        Baz baz = new Baz();
        Bar bar = new Bar();
        bar.setSomeInt(1);
        bar.setSomeBaz(baz);
        byte[] data = JsonIOUtil.toByteArray((Object)bar, (Schema)bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{\"someInt\":1,\"someBaz\":{}}");
        Bar parsedBar = new Bar();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedBar, (Schema)parsedBar.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)bar, (Object)parsedBar);
    }

    public void testPartialEmptyMessageWithString() throws Exception {
        Baz baz = new Baz();
        Bar bar = new Bar();
        bar.setSomeString("someString");
        bar.setSomeBaz(baz);
        byte[] data = JsonIOUtil.toByteArray((Object)bar, (Schema)bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{\"someString\":\"someString\",\"someBaz\":{}}");
        Bar parsedBar = new Bar();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedBar, (Schema)parsedBar.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)bar, (Object)parsedBar);
    }

    public void testPartialEmptyMessageWithEmptyString() throws Exception {
        Baz baz = new Baz();
        Bar bar = new Bar();
        bar.setSomeString("");
        bar.setSomeBaz(baz);
        byte[] data = JsonIOUtil.toByteArray((Object)bar, (Schema)bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{\"someString\":\"\",\"someBaz\":{}}");
        Bar parsedBar = new Bar();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedBar, (Schema)parsedBar.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)bar, (Object)parsedBar);
    }

    public void testPartialEmptyMessageInner() throws Exception {
        Baz baz = new Baz();
        Bar bar = new Bar();
        baz.setId(2);
        bar.setSomeBaz(baz);
        byte[] data = JsonIOUtil.toByteArray((Object)bar, (Schema)bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{\"someBaz\":{\"id\":2}}");
        Bar parsedBar = new Bar();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedBar, (Schema)parsedBar.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)bar, (Object)parsedBar);
    }

    public void testPartialEmptyMessageInnerWithString() throws Exception {
        Baz baz = new Baz();
        Bar bar = new Bar();
        baz.setName("asdfsf");
        bar.setSomeBaz(baz);
        byte[] data = JsonIOUtil.toByteArray((Object)bar, (Schema)bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{\"someBaz\":{\"name\":\"asdfsf\"}}");
        Bar parsedBar = new Bar();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedBar, (Schema)parsedBar.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)bar, (Object)parsedBar);
    }

    public void testPartialEmptyMessageInnerWithEmptyString() throws Exception {
        Baz baz = new Baz();
        Bar bar = new Bar();
        baz.setName("");
        bar.setSomeBaz(baz);
        byte[] data = JsonIOUtil.toByteArray((Object)bar, (Schema)bar.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{\"someBaz\":{\"name\":\"\"}}");
        Bar parsedBar = new Bar();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedBar, (Schema)parsedBar.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)bar, (Object)parsedBar);
    }

    public void testEmptyFoo() throws Exception {
        Foo foo = new Foo();
        byte[] data = JsonIOUtil.toByteArray((Object)foo, (Schema)foo.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{}");
        Foo parsedFoo = new Foo();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedFoo, (Schema)parsedFoo.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)foo, (Object)parsedFoo);
    }

    public void testEmptyFooInner() throws Exception {
        Foo foo = new Foo();
        ArrayList<Bar> bars = new ArrayList<Bar>();
        bars.add(new Bar());
        foo.setSomeBar(bars);
        byte[] data = JsonIOUtil.toByteArray((Object)foo, (Schema)foo.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{\"someBar\":[{}]}");
        Foo parsedFoo = new Foo();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedFoo, (Schema)parsedFoo.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)foo, (Object)parsedFoo);
    }

    public void testEmptyFooDeeper() throws Exception {
        Foo foo = new Foo();
        ArrayList<Bar> bars = new ArrayList<Bar>();
        Bar bar = new Bar();
        bar.setSomeBaz(new Baz());
        bars.add(bar);
        foo.setSomeBar(bars);
        byte[] data = JsonIOUtil.toByteArray((Object)foo, (Schema)foo.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((String)new String(data, "UTF-8"), (String)"{\"someBar\":[{\"someBaz\":{}}]}");
        Foo parsedFoo = new Foo();
        JsonIOUtil.mergeFrom((byte[])data, (Object)parsedFoo, (Schema)parsedFoo.cachedSchema(), (boolean)false);
        SerializableObjects.assertEquals((Object)foo, (Object)parsedFoo);
    }

    public void testFooNullFields() throws Exception {
        Foo b = new Foo();
        JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser("{\"someInt\":[null],\"someString\":[null],\"someBar\":[null],\"someEnum\":[null],\"someBytes\":[null],\"someBoolean\":[null],\"someFloat\":[null],\"someDouble\":[null],\"someLong\":[null]}"), (Object)b, (Schema)b.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeInt());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeString());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeBar());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeEnum());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeBytes());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeBoolean());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeFloat());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeDouble());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeLong());
    }

    public void testFooNullFieldsButFirst() throws Exception {
        Foo b = new Foo();
        JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser("{\"someInt\":[1,null],\"someString\":[\"string\",null],\"someBar\":[{},null],\"someEnum\":[1,null],\"someBytes\":[\"fw==\",null],\"someBoolean\":[true,null],\"someFloat\":[10.01,null],\"someDouble\":[100.001,null],\"someLong\":[1000,null]}"), (Object)b, (Schema)b.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeInt(), Arrays.asList(new Integer(1)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeString(), Arrays.asList("string"));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBar(), Arrays.asList(new Bar()));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeEnum(), Arrays.asList(Foo.EnumSample.TYPE1));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBytes(), Arrays.asList(ByteString.copyFrom((byte[])new byte[]{127})));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBoolean(), Arrays.asList(Boolean.TRUE));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeFloat(), Arrays.asList(new Float(10.01f)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeDouble(), Arrays.asList(new Double(100.001)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeLong(), Arrays.asList(new Long(1000L)));
    }

    public void testFooNullFieldsButMid() throws Exception {
        Foo b = new Foo();
        JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser("{\"someInt\":[null,1,null],\"someString\":[null,\"string\",null],\"someBar\":[null,{},null],\"someEnum\":[null,1,null],\"someBytes\":[null,\"fw==\",null],\"someBoolean\":[null,true,null],\"someFloat\":[null,10.01,null],\"someDouble\":[null,100.001,null],\"someLong\":[null,1000,null]}"), (Object)b, (Schema)b.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeInt(), Arrays.asList(new Integer(1)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeString(), Arrays.asList("string"));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBar(), Arrays.asList(new Bar()));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeEnum(), Arrays.asList(Foo.EnumSample.TYPE1));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBytes(), Arrays.asList(ByteString.copyFrom((byte[])new byte[]{127})));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBoolean(), Arrays.asList(Boolean.TRUE));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeFloat(), Arrays.asList(new Float(10.01f)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeDouble(), Arrays.asList(new Double(100.001)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeLong(), Arrays.asList(new Long(1000L)));
    }

    public void testFooNullFieldsButLast() throws Exception {
        Foo b = new Foo();
        JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser("{\"someInt\":[null,1],\"someString\":[null,\"string\"],\"someBar\":[null,{}],\"someEnum\":[null,1],\"someBytes\":[null,\"fw==\"],\"someBoolean\":[null,true],\"someFloat\":[null,10.01],\"someDouble\":[null,100.001],\"someLong\":[null,1000]}"), (Object)b, (Schema)b.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeInt(), Arrays.asList(new Integer(1)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeString(), Arrays.asList("string"));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBar(), Arrays.asList(new Bar()));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeEnum(), Arrays.asList(Foo.EnumSample.TYPE1));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBytes(), Arrays.asList(ByteString.copyFrom((byte[])new byte[]{127})));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBoolean(), Arrays.asList(Boolean.TRUE));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeFloat(), Arrays.asList(new Float(10.01f)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeDouble(), Arrays.asList(new Double(100.001)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeLong(), Arrays.asList(new Long(1000L)));
    }

    public void testFooNullFieldsButLast2() throws Exception {
        Foo b = new Foo();
        JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser("{\"someInt\":[null,null,1],\"someString\":[null,null,\"string\"],\"someBar\":[null,null,{}],\"someEnum\":[null,null,1],\"someBytes\":[null,null,\"fw==\"],\"someBoolean\":[null,null,true],\"someFloat\":[null,null,10.01],\"someDouble\":[null,null,100.001],\"someLong\":[null,null,1000]}"), (Object)b, (Schema)b.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeInt(), Arrays.asList(new Integer(1)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeString(), Arrays.asList("string"));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBar(), Arrays.asList(new Bar()));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeEnum(), Arrays.asList(Foo.EnumSample.TYPE1));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBytes(), Arrays.asList(ByteString.copyFrom((byte[])new byte[]{127})));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeBoolean(), Arrays.asList(Boolean.TRUE));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeFloat(), Arrays.asList(new Float(10.01f)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeDouble(), Arrays.asList(new Double(100.001)));
        JsonCoreSerDeserTest.assertEquals((Object)b.getSomeLong(), Arrays.asList(new Long(1000L)));
    }

    public void testBarNullFields() throws Exception {
        Bar b = new Bar();
        JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser("{\"someInt\":null,\"someString\":null,\"someBaz\":null,\"someEnum\":null,\"someBytes\":null,\"someBoolean\":null,\"someFloat\":null,\"someDouble\":null,\"someLong\":null}"), (Object)b, (Schema)b.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((int)0, (int)b.getSomeInt());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeString());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeBaz());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeEnum());
        JsonCoreSerDeserTest.assertNull((Object)b.getSomeBytes());
        JsonCoreSerDeserTest.assertFalse((boolean)b.getSomeBoolean());
        JsonCoreSerDeserTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(b.getSomeFloat()));
        JsonCoreSerDeserTest.assertEquals((Object)0.0, (Object)b.getSomeDouble());
        JsonCoreSerDeserTest.assertEquals((long)0L, (long)b.getSomeLong());
    }

    public void testBazNullFields() throws Exception {
        Baz b = new Baz();
        JsonIOUtil.mergeFrom((JsonParser)JsonIOUtil.DEFAULT_JSON_FACTORY.createJsonParser("{\"id\":null,\"name\":null,\"timestamp\":null}"), (Object)b, (Schema)b.cachedSchema(), (boolean)false);
        JsonCoreSerDeserTest.assertEquals((int)0, (int)b.getId());
        JsonCoreSerDeserTest.assertNull((Object)b.getName());
        JsonCoreSerDeserTest.assertEquals((long)0L, (long)b.getTimestamp());
    }
}

