/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.AbstractTest;
import io.protostuff.JsonIOUtil;
import io.protostuff.JsonXIOUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.Schema;
import io.protostuff.StandardTest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JsonBufferReuseTest
extends StandardTest {
    private static final ThreadLocal<LinkedBuffer> localBuffer = new ThreadLocal<LinkedBuffer>(){

        @Override
        protected LinkedBuffer initialValue() {
            return AbstractTest.buf();
        }
    };

    protected <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, length);
        JsonIOUtil.mergeFrom((InputStream)in, message, schema, (boolean)false, (LinkedBuffer)localBuffer.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> byte[] toByteArray(T message, Schema<T> schema) {
        LinkedBuffer buffer = localBuffer.get();
        try {
            byte[] byArray = JsonXIOUtil.toByteArray(message, schema, (boolean)false, (LinkedBuffer)buffer);
            return byArray;
        }
        finally {
            buffer.clear();
        }
    }
}

