/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import com.fasterxml.jackson.core.JsonGenerator;
import io.protostuff.ByteString;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class JsonOutput
implements Output,
StatefulOutput {
    private final JsonGenerator generator;
    private Schema<?> schema;
    private final boolean numeric;
    private boolean lastRepeated;
    private int lastNumber;

    public JsonOutput(JsonGenerator generator) {
        this(generator, false);
    }

    public JsonOutput(JsonGenerator generator, boolean numeric) {
        this.generator = generator;
        this.numeric = numeric;
    }

    public JsonOutput(JsonGenerator generator, boolean numeric, Schema<?> schema) {
        this(generator, numeric);
        this.schema = schema;
    }

    public JsonOutput reset() {
        this.lastRepeated = false;
        this.lastNumber = 0;
        return this;
    }

    public JsonOutput use(Schema<?> schema) {
        this.schema = schema;
        return this.reset();
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public boolean isLastRepeated() {
        return this.lastRepeated;
    }

    public void updateLast(Schema<?> schema, Schema<?> lastSchema) {
        if (lastSchema != null && lastSchema == this.schema) {
            this.schema = schema;
        }
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeBoolean(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeBoolean(value);
        } else {
            generator.writeBooleanField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeBinary(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeBinary(value);
        } else {
            generator.writeFieldName(name);
            generator.writeBinary(value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            if (utf8String) {
                this.generator.writeUTF8String(value, offset, length);
            } else {
                this.generator.writeBinary(value, offset, length);
            }
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            if (utf8String) {
                generator.writeUTF8String(value, offset, length);
            } else {
                generator.writeBinary(value, offset, length);
            }
        } else {
            generator.writeFieldName(name);
            if (utf8String) {
                generator.writeUTF8String(value, offset, length);
            } else {
                generator.writeBinary(value, offset, length);
            }
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, value.getBytes(), repeated);
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeNumber(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeNumber(value);
        } else {
            generator.writeNumberField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeString(int fieldNumber, String value, boolean repeated) throws IOException {
        String name;
        if (this.lastNumber == fieldNumber) {
            this.generator.writeString(value);
            return;
        }
        JsonGenerator generator = this.generator;
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        String string = name = this.numeric ? Integer.toString(fieldNumber) : this.schema.getFieldName(fieldNumber);
        if (repeated) {
            generator.writeArrayFieldStart(name);
            generator.writeString(value);
        } else {
            generator.writeStringField(name, value);
        }
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        JsonGenerator generator = this.generator;
        Schema<?> lastSchema = this.schema;
        if (this.lastNumber != fieldNumber) {
            String name;
            if (this.lastRepeated) {
                generator.writeEndArray();
            }
            String string = name = this.numeric ? Integer.toString(fieldNumber) : lastSchema.getFieldName(fieldNumber);
            if (repeated) {
                generator.writeArrayFieldStart(name);
            } else {
                generator.writeFieldName(name);
            }
        }
        this.schema = schema;
        this.lastNumber = 0;
        this.lastRepeated = false;
        generator.writeStartObject();
        schema.writeTo((Output)this, value);
        if (this.lastRepeated) {
            generator.writeEndArray();
        }
        generator.writeEndObject();
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
        this.schema = lastSchema;
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, value.array(), value.arrayOffset() + value.position(), value.remaining(), repeated);
    }
}

