/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Bar;
import io.protostuff.Baz;
import io.protostuff.Foo;
import io.protostuff.JsonIOUtil;
import io.protostuff.Schema;
import io.protostuff.SerializableObjects;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class JsonNumericCoreSerDeserTest
extends TestCase {
    public void testFoo() throws Exception {
        Foo fooCompare = SerializableObjects.foo;
        Foo dfoo = new Foo();
        byte[] data = JsonIOUtil.toByteArray((Object)fooCompare, (Schema)fooCompare.cachedSchema(), (boolean)true);
        JsonIOUtil.mergeFrom((byte[])data, (Object)dfoo, (Schema)dfoo.cachedSchema(), (boolean)true);
        SerializableObjects.assertEquals((Object)fooCompare, (Object)dfoo);
    }

    public void testBar() throws Exception {
        for (Bar barCompare : new Bar[]{SerializableObjects.bar, SerializableObjects.negativeBar}) {
            Bar dbar = new Bar();
            byte[] data = JsonIOUtil.toByteArray((Object)barCompare, (Schema)barCompare.cachedSchema(), (boolean)true);
            JsonIOUtil.mergeFrom((byte[])data, (Object)dbar, (Schema)dbar.cachedSchema(), (boolean)true);
            SerializableObjects.assertEquals((Object)barCompare, (Object)dbar);
        }
    }

    public void testBaz() throws Exception {
        for (Baz bazCompare : new Baz[]{SerializableObjects.baz, SerializableObjects.negativeBaz}) {
            Baz dbaz = new Baz();
            byte[] data = JsonIOUtil.toByteArray((Object)bazCompare, (Schema)bazCompare.cachedSchema(), (boolean)true);
            JsonIOUtil.mergeFrom((byte[])data, (Object)dbaz, (Schema)dbaz.cachedSchema(), (boolean)true);
            SerializableObjects.assertEquals((Object)bazCompare, (Object)dbaz);
        }
    }

    public void testListIO() throws Exception {
        ArrayList<Bar> bars = new ArrayList<Bar>();
        bars.add(SerializableObjects.bar);
        bars.add(SerializableObjects.negativeBar);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonIOUtil.writeListTo((OutputStream)out, bars, (Schema)SerializableObjects.bar.cachedSchema(), (boolean)true);
        byte[] data = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        List parsedBars = JsonIOUtil.parseListFrom((InputStream)in, (Schema)SerializableObjects.bar.cachedSchema(), (boolean)true);
        JsonNumericCoreSerDeserTest.assertTrue((parsedBars.size() == bars.size() ? 1 : 0) != 0);
        int i = 0;
        for (Bar b : parsedBars) {
            SerializableObjects.assertEquals(bars.get(i++), (Object)b);
        }
    }
}

