/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Input;
import io.protostuff.JsonInput;
import io.protostuff.JsonInputException;
import io.protostuff.JsonOutput;
import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.Schema;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.impl.Utf8Generator;
import org.codehaus.jackson.impl.Utf8StreamParser;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.sym.BytesToNameCanonicalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonIOUtil {
    public static final Factory DEFAULT_JSON_FACTORY = new Factory();

    private JsonIOUtil() {
    }

    public static Pipe newPipe(byte[] data, boolean numeric) throws IOException {
        return JsonIOUtil.newPipe(data, 0, data.length, numeric);
    }

    public static Pipe newPipe(byte[] data, int offset, int length, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)data, false);
        Utf8StreamParser parser = JsonIOUtil.newJsonParser(null, data, offset, offset + length, false, context);
        return JsonIOUtil.newPipe((JsonParser)parser, numeric);
    }

    public static Pipe newPipe(InputStream in, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)in, false);
        Utf8StreamParser parser = JsonIOUtil.newJsonParser(in, context.allocReadIOBuffer(), 0, 0, true, context);
        return JsonIOUtil.newPipe((JsonParser)parser, numeric);
    }

    public static Pipe newPipe(Reader reader, boolean numeric) throws IOException {
        return JsonIOUtil.newPipe(DEFAULT_JSON_FACTORY.createJsonParser(reader), numeric);
    }

    public static Pipe newPipe(final JsonParser parser, boolean numeric) throws IOException {
        final JsonInput jsonInput = new JsonInput(parser, numeric);
        return new Pipe(){

            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                if (parser.nextToken() != JsonToken.START_OBJECT) {
                    throw new JsonInputException("Expected token: { but was " + parser.getCurrentToken() + " on message " + pipeSchema.wrappedSchema.messageFullName());
                }
                return jsonInput;
            }

            protected void end(Pipe.Schema<?> pipeSchema, Input input, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    parser.close();
                    return;
                }
                assert (input == jsonInput);
                JsonToken token = parser.getCurrentToken();
                parser.close();
                if (token != JsonToken.END_OBJECT) {
                    throw new JsonInputException("Expected token: } but was " + token + " on message " + pipeSchema.wrappedSchema.messageFullName());
                }
            }
        };
    }

    public static Utf8StreamParser newJsonParser(InputStream in, byte[] buf, int offset, int limit) throws IOException {
        return JsonIOUtil.newJsonParser(in, buf, offset, limit, false, new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)in, false));
    }

    static Utf8StreamParser newJsonParser(InputStream in, byte[] buf, int offset, int limit, boolean bufferRecyclable, IOContext context) throws IOException {
        return new Utf8StreamParser(context, DEFAULT_JSON_FACTORY.getParserFeatures(), in, DEFAULT_JSON_FACTORY.getCodec(), DEFAULT_JSON_FACTORY.getRootByteSymbols().makeChild(true, true), buf, offset, limit, bufferRecyclable);
    }

    public static Utf8Generator newJsonGenerator(OutputStream out, byte[] buf) {
        return JsonIOUtil.newJsonGenerator(out, buf, 0, false, new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)out, false));
    }

    static Utf8Generator newJsonGenerator(OutputStream out, byte[] buf, int offset, boolean bufferRecyclable, IOContext context) {
        context.setEncoding(JsonEncoding.UTF8);
        return new Utf8Generator(context, DEFAULT_JSON_FACTORY.getGeneratorFeatures(), DEFAULT_JSON_FACTORY.getCodec(), out, buf, offset, bufferRecyclable);
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema, boolean numeric) throws IOException {
        JsonIOUtil.mergeFrom(data, 0, data.length, message, schema, numeric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)data, false);
        Utf8StreamParser parser = JsonIOUtil.newJsonParser(null, data, offset, offset + length, false, context);
        try {
            JsonIOUtil.mergeFrom((JsonParser)parser, message, schema, numeric);
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)in, false);
        Utf8StreamParser parser = JsonIOUtil.newJsonParser(in, context.allocReadIOBuffer(), 0, 0, true, context);
        try {
            JsonIOUtil.mergeFrom((JsonParser)parser, message, schema, numeric);
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)in, false);
        Utf8StreamParser parser = JsonIOUtil.newJsonParser(in, buffer.buffer, 0, 0, false, context);
        try {
            JsonIOUtil.mergeFrom((JsonParser)parser, message, schema, numeric);
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(Reader reader, T message, Schema<T> schema, boolean numeric) throws IOException {
        JsonParser parser = DEFAULT_JSON_FACTORY.createJsonParser(reader);
        try {
            JsonIOUtil.mergeFrom(parser, message, schema, numeric);
        }
        finally {
            parser.close();
        }
    }

    public static <T> void mergeFrom(JsonParser parser, T message, Schema<T> schema, boolean numeric) throws IOException {
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonInputException("Expected token: { but was " + parser.getCurrentToken() + " on message " + schema.messageFullName());
        }
        schema.mergeFrom((Input)new JsonInput(parser, numeric), message);
        if (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            throw new JsonInputException("Expected token: } but was " + parser.getCurrentToken() + " on message " + schema.messageFullName());
        }
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JsonIOUtil.writeTo(baos, message, schema, numeric);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return baos.toByteArray();
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JsonIOUtil.writeTo(baos, message, schema, numeric, buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)out, false);
        Utf8Generator generator = JsonIOUtil.newJsonGenerator(out, context.allocWriteEncodingBuffer(), 0, true, context);
        try {
            JsonIOUtil.writeTo((JsonGenerator)generator, message, schema, numeric);
        }
        finally {
            generator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)out, false);
        Utf8Generator generator = JsonIOUtil.newJsonGenerator(out, buffer.buffer, 0, false, context);
        try {
            JsonIOUtil.writeTo((JsonGenerator)generator, message, schema, numeric);
        }
        finally {
            generator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeTo(Writer writer, T message, Schema<T> schema, boolean numeric) throws IOException {
        JsonGenerator generator = DEFAULT_JSON_FACTORY.createJsonGenerator(writer);
        try {
            JsonIOUtil.writeTo(generator, message, schema, numeric);
        }
        finally {
            generator.close();
        }
    }

    public static <T> void writeTo(JsonGenerator generator, T message, Schema<T> schema, boolean numeric) throws IOException {
        generator.writeStartObject();
        JsonOutput output = new JsonOutput(generator, numeric, schema);
        schema.writeTo((Output)output, message);
        if (output.isLastRepeated()) {
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)out, false);
        Utf8Generator generator = JsonIOUtil.newJsonGenerator(out, context.allocWriteEncodingBuffer(), 0, true, context);
        try {
            JsonIOUtil.writeListTo((JsonGenerator)generator, messages, schema, numeric);
        }
        finally {
            generator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)out, false);
        Utf8Generator generator = JsonIOUtil.newJsonGenerator(out, buffer.buffer, 0, false, context);
        try {
            JsonIOUtil.writeListTo((JsonGenerator)generator, messages, schema, numeric);
        }
        finally {
            generator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeListTo(Writer writer, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        JsonGenerator generator = DEFAULT_JSON_FACTORY.createJsonGenerator(writer);
        try {
            JsonIOUtil.writeListTo(generator, messages, schema, numeric);
        }
        finally {
            generator.close();
        }
    }

    public static <T> void writeListTo(JsonGenerator generator, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        generator.writeStartArray();
        if (messages.isEmpty()) {
            generator.writeEndArray();
            return;
        }
        JsonOutput output = new JsonOutput(generator, numeric, schema);
        for (T m : messages) {
            generator.writeStartObject();
            schema.writeTo((Output)output, m);
            if (output.isLastRepeated()) {
                generator.writeEndArray();
            }
            generator.writeEndObject();
            output.reset();
        }
        generator.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)in, false);
        Utf8StreamParser parser = JsonIOUtil.newJsonParser(in, context.allocReadIOBuffer(), 0, 0, true, context);
        try {
            List<T> list = JsonIOUtil.parseListFrom((JsonParser)parser, schema, numeric);
            return list;
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), (Object)in, false);
        Utf8StreamParser parser = JsonIOUtil.newJsonParser(in, buffer.buffer, 0, 0, false, context);
        try {
            List<T> list = JsonIOUtil.parseListFrom((JsonParser)parser, schema, numeric);
            return list;
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> parseListFrom(Reader reader, Schema<T> schema, boolean numeric) throws IOException {
        JsonParser parser = DEFAULT_JSON_FACTORY.createJsonParser(reader);
        try {
            List<T> list = JsonIOUtil.parseListFrom(parser, schema, numeric);
            return list;
        }
        finally {
            parser.close();
        }
    }

    public static <T> List<T> parseListFrom(JsonParser parser, Schema<T> schema, boolean numeric) throws IOException {
        if (parser.nextToken() != JsonToken.START_ARRAY) {
            throw new JsonInputException("Expected token: [ but was " + parser.getCurrentToken() + " on message: " + schema.messageFullName());
        }
        JsonInput input = new JsonInput(parser, numeric);
        ArrayList<Object> list = new ArrayList<Object>();
        JsonToken t = parser.nextToken();
        while (t != JsonToken.END_ARRAY) {
            if (t != JsonToken.START_OBJECT) {
                throw new JsonInputException("Expected token: { but was " + parser.getCurrentToken() + " on message " + schema.messageFullName());
            }
            Object message = schema.newMessage();
            schema.mergeFrom((Input)input, message);
            if (parser.getCurrentToken() != JsonToken.END_OBJECT) {
                throw new JsonInputException("Expected token: } but was " + parser.getCurrentToken() + " on message " + schema.messageFullName());
            }
            list.add(message);
            input.reset();
            t = parser.nextToken();
        }
        return list;
    }

    static {
        DEFAULT_JSON_FACTORY.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        DEFAULT_JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }

    public static final class Factory
    extends JsonFactory {
        public BytesToNameCanonicalizer getRootByteSymbols() {
            return this._rootByteSymbols;
        }

        public int getParserFeatures() {
            return this._parserFeatures;
        }

        public int getGeneratorFeatures() {
            return this._generatorFeatures;
        }
    }
}

