/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.StringSerializer;
import io.protostuff.WriteSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import junit.framework.TestCase;

public class StringSerializerTest
extends TestCase {
    static final String three_byte_utf8 = "\u1234\u8000\uf800\u0800";
    static final String two_byte_utf8 = "\u07ff\u00e1\u0088\u00b4";
    static final String alphabet = "abcdefghijklmnopqrstuvwyxz";
    static final String alphabet_to_upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static final String surrogatePairs = "\ud83c\udfe0\ud83c\udf4e\ud83d\udca9";
    static final byte[] nativeSurrogatePairsSerialized = new byte[]{-16, -97, -113, -96, -16, -97, -115, -114, -16, -97, -110, -87};
    static final byte[] legacySurrogatePairSerialized = new byte[]{-19, -96, -68, -19, -65, -96, -19, -96, -68, -19, -67, -114, -19, -96, -67, -19, -78, -87};
    static final String numeric = "0123456789";
    static final String whitespace = "\r\n\t";
    static final String foo = "abcdefghijklmnopqrstuvwyxz\u1234\u8000\uf800\u08000123456789\u07ff\u00e1\u0088\u00b4\r\n\t\ud83c\udfe0\ud83c\udf4e\ud83d\udca9";
    static final String str_len_130 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
    static final String[] targets = new String[]{"\u1234\u8000\uf800\u0800", "\u07ff\u00e1\u0088\u00b4", "abcdefghijklmnopqrstuvwyxz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "0123456789", "\r\n\t", "abcdefghijklmnopqrstuvwyxz\u1234\u8000\uf800\u08000123456789\u07ff\u00e1\u0088\u00b4\r\n\t\ud83c\udfe0\ud83c\udf4e\ud83d\udca9", "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890", "\ud83c\udfe0\ud83c\udf4e\ud83d\udca9", StringSerializerTest.repeatChar('a', 2032), StringSerializerTest.repeatChar('a', 2064), StringSerializerTest.repeatChar('a', 32752), StringSerializerTest.repeatChar('a', 32784)};
    static final String[] ascii_targets = new String[]{"abcdefghijklmnopqrstuvwyxz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "0123456789", "\r\n\t", "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890", StringSerializerTest.repeatChar('b', 2032), StringSerializerTest.repeatChar('b', 2064), StringSerializerTest.repeatChar('b', 32752), StringSerializerTest.repeatChar('b', 32784)};
    static final int[] int_targets;
    static final long[] long_targets;
    static final float[] float_targets;
    static final double[] double_targets;

    static {
        int[] nArray = new int[19];
        nArray[1] = 1;
        nArray[2] = -1;
        nArray[3] = 10;
        nArray[4] = -10;
        nArray[5] = 100;
        nArray[6] = -100;
        nArray[7] = 1000;
        nArray[8] = -1000;
        nArray[9] = 10001;
        nArray[10] = -10001;
        nArray[11] = 1110001;
        nArray[12] = -1110001;
        nArray[13] = 111110001;
        nArray[14] = -111110001;
        nArray[15] = 1234567890;
        nArray[16] = -1234567890;
        nArray[17] = Integer.MAX_VALUE;
        nArray[18] = Integer.MIN_VALUE;
        int_targets = nArray;
        long[] lArray = new long[27];
        lArray[1] = 1L;
        lArray[2] = -1L;
        lArray[3] = 10L;
        lArray[4] = -10L;
        lArray[5] = 100L;
        lArray[6] = -100L;
        lArray[7] = 1000L;
        lArray[8] = -1000L;
        lArray[9] = 10001L;
        lArray[10] = -10001L;
        lArray[11] = 1110001L;
        lArray[12] = -1110001L;
        lArray[13] = 111110001L;
        lArray[14] = -111110001L;
        lArray[15] = 11111110001L;
        lArray[16] = -11111110001L;
        lArray[17] = 1111111110001L;
        lArray[18] = -1111111110001L;
        lArray[19] = 111111111110001L;
        lArray[20] = -111111111110001L;
        lArray[21] = 11111111111110001L;
        lArray[22] = -11111111111110001L;
        lArray[23] = 1234567890123456789L;
        lArray[24] = -1234567890123456789L;
        lArray[25] = Long.MAX_VALUE;
        lArray[26] = Long.MIN_VALUE;
        long_targets = lArray;
        float_targets = new float[]{0.0f, 10.01f, -10.01f, 0.0f, 56789.99f, -56789.99f, Float.MAX_VALUE, Float.MIN_VALUE};
        double_targets = new double[]{0.0, 10.01, -10.01, 0.0, 56789.98765, -56789.98765, 1.2345678900987654E9, -1.2345678900987654E9, Double.MAX_VALUE, Double.MIN_VALUE};
    }

    public void testVarDelimitedBoundryTwoByte() throws Exception {
        int size = 16383;
        StringSerializerTest.checkVarDelimitedBoundry(1, size);
        StringSerializerTest.checkVarDelimitedBoundry(2, size);
        StringSerializerTest.checkVarDelimitedBoundry(3, size);
        StringSerializerTest.checkVarDelimitedBoundry(4, size);
    }

    public void testVarDelimitedBoundryThreeByte() throws Exception {
        int size = 0x1FFFFF;
        StringSerializerTest.checkVarDelimitedBoundry(1, size);
        StringSerializerTest.checkVarDelimitedBoundry(2, size);
        StringSerializerTest.checkVarDelimitedBoundry(3, size);
        StringSerializerTest.checkVarDelimitedBoundry(4, size);
        StringSerializerTest.checkVarDelimitedBoundry(5, size);
    }

    public static String repeatChar(char ch, int times) {
        StringBuilder sb = new StringBuilder(times);
        int i = 0;
        while (i < times) {
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static void checkVarDelimitedBoundry(int initialGap, int secondWriteSize) {
        int bufferSize = 256;
        LinkedBuffer lb = LinkedBuffer.allocate((int)bufferSize);
        WriteSession session = new WriteSession(lb, bufferSize);
        StringSerializer.writeUTF8((CharSequence)StringSerializerTest.repeatChar('a', bufferSize - initialGap), (WriteSession)session, (LinkedBuffer)lb);
        StringSerializerTest.assertTrue((secondWriteSize > bufferSize ? 1 : 0) != 0);
        StringSerializer.writeUTF8VarDelimited((CharSequence)StringSerializerTest.repeatChar('a', secondWriteSize), (WriteSession)session, (LinkedBuffer)lb);
    }

    public void testInt() throws Exception {
        int[] nArray = int_targets;
        int n = int_targets.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb);
            StringSerializer.writeInt((int)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer lb2 = new LinkedBuffer(1);
            WriteSession session2 = new WriteSession(lb2);
            StringSerializer.writeInt((int)i, (WriteSession)session2, (LinkedBuffer)lb2);
            byte[] buffered = session.toByteArray();
            byte[] buffered_needed_to_grow = session2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Integer.toString(i));
            StringSerializerTest.assertEquals(builtin, buffered);
            StringSerializerTest.assertEquals(builtin, buffered_needed_to_grow);
            ++n2;
        }
    }

    public void testLong() throws Exception {
        long[] lArray = long_targets;
        int n = long_targets.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb);
            StringSerializer.writeLong((long)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer lb2 = new LinkedBuffer(1);
            WriteSession session2 = new WriteSession(lb2);
            StringSerializer.writeLong((long)i, (WriteSession)session2, (LinkedBuffer)lb2);
            byte[] buffered = session.toByteArray();
            byte[] buffered_needed_to_grow = session2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Long.toString(i));
            StringSerializerTest.assertEquals(builtin, buffered);
            StringSerializerTest.assertEquals(builtin, buffered_needed_to_grow);
            ++n2;
        }
    }

    public void testFloat() throws Exception {
        float[] fArray = float_targets;
        int n = float_targets.length;
        int n2 = 0;
        while (n2 < n) {
            float i = fArray[n2];
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb);
            StringSerializer.writeFloat((float)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer lb2 = new LinkedBuffer(1);
            WriteSession session2 = new WriteSession(lb2);
            StringSerializer.writeFloat((float)i, (WriteSession)session2, (LinkedBuffer)lb2);
            byte[] buffered = session.toByteArray();
            byte[] buffered_needed_to_grow = session2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Float.toString(i));
            StringSerializerTest.assertEquals(builtin, buffered);
            StringSerializerTest.assertEquals(builtin, buffered_needed_to_grow);
            ++n2;
        }
    }

    public void testDouble() throws Exception {
        double[] dArray = double_targets;
        int n = double_targets.length;
        int n2 = 0;
        while (n2 < n) {
            double i = dArray[n2];
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb);
            StringSerializer.writeDouble((double)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer lb2 = new LinkedBuffer(1);
            WriteSession session2 = new WriteSession(lb2);
            StringSerializer.writeDouble((double)i, (WriteSession)session2, (LinkedBuffer)lb2);
            byte[] buffered = session.toByteArray();
            byte[] buffered_needed_to_grow = session2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Double.toString(i));
            StringSerializerTest.assertEquals(builtin, buffered);
            StringSerializerTest.assertEquals(builtin, buffered_needed_to_grow);
            ++n2;
        }
    }

    public void testAscii() throws Exception {
        String[] stringArray = ascii_targets;
        int n = ascii_targets.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StringSerializerTest.checkAscii(s);
            ++n2;
        }
    }

    public void testUTF8() throws Exception {
        String[] stringArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StringSerializerTest.check(s);
            ++n2;
        }
        StringSerializerTest.check("");
        StringSerializerTest.check(str_len_130);
        String lessThan2048 = str_len_130;
        int i = 0;
        while (i < 14) {
            lessThan2048 = String.valueOf(lessThan2048) + str_len_130;
            ++i;
        }
        int lt2048Len = 1950;
        StringSerializerTest.assertTrue((lessThan2048.length() == lt2048Len ? 1 : 0) != 0);
        StringSerializerTest.check(lessThan2048);
        String moreThan2048 = str_len_130;
        int i2 = 0;
        while (i2 < 20) {
            moreThan2048 = String.valueOf(moreThan2048) + str_len_130;
            ++i2;
        }
        int expectedLen = 2730;
        StringSerializerTest.assertTrue((moreThan2048.length() == expectedLen ? 1 : 0) != 0);
        StringSerializerTest.check(moreThan2048);
    }

    public void testUTF8VarDelimited() throws Exception {
        StringSerializerTest.checkVarDelimited(foo, 1, 71);
        StringSerializerTest.checkVarDelimited(whitespace, 1, 3);
        StringSerializerTest.checkVarDelimited(numeric, 1, 10);
        StringSerializerTest.checkVarDelimited(alphabet, 1, 26);
        StringSerializerTest.checkVarDelimited(alphabet_to_upper, 1, 26);
        StringSerializerTest.checkVarDelimited(two_byte_utf8, 1, 8);
        StringSerializerTest.checkVarDelimited(three_byte_utf8, 1, 12);
        StringSerializerTest.checkVarDelimited("1234567890123456789012345678901234567890", 1, 40);
        StringSerializerTest.checkVarDelimited("", 1, 0);
        StringSerializerTest.checkVarDelimited(str_len_130, 2, 130);
        StringSerializerTest.checkVarDelimited(str_len_130.substring(10), 1, 120);
        String lessThan2048 = str_len_130;
        int i = 0;
        while (i < 14) {
            lessThan2048 = String.valueOf(lessThan2048) + str_len_130;
            ++i;
        }
        int lt2048Len = 1950;
        StringSerializerTest.assertTrue((lessThan2048.length() == lt2048Len ? 1 : 0) != 0);
        StringSerializerTest.checkVarDelimited(lessThan2048, 2, lt2048Len);
        String moreThan2048 = str_len_130;
        int i2 = 0;
        while (i2 < 20) {
            moreThan2048 = String.valueOf(moreThan2048) + str_len_130;
            ++i2;
        }
        int expectedLen = 2730;
        StringSerializerTest.assertTrue((moreThan2048.length() == expectedLen ? 1 : 0) != 0);
        StringSerializerTest.checkVarDelimited(moreThan2048, 2, expectedLen);
        String str16383 = StringSerializerTest.repeatChar('z', 16383);
        String str16384 = String.valueOf(str16383) + "g";
        StringSerializerTest.checkVarDelimited(str16383, 2, str16383.length());
        StringSerializerTest.checkVarDelimited(str16384, 3, str16384.length());
    }

    public void testUTF8FixedDelimited() throws Exception {
        String[] stringArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StringSerializerTest.checkFixedDelimited(s);
            ++n2;
        }
        StringSerializerTest.checkFixedDelimited("1234567890123456789012345678901234567890");
        StringSerializerTest.checkFixedDelimited("");
        StringSerializerTest.checkFixedDelimited(str_len_130);
        String lessThan2048 = str_len_130;
        int i = 0;
        while (i < 14) {
            lessThan2048 = String.valueOf(lessThan2048) + str_len_130;
            ++i;
        }
        int lt2048Len = 1950;
        StringSerializerTest.assertTrue((lessThan2048.length() == lt2048Len ? 1 : 0) != 0);
        StringSerializerTest.checkFixedDelimited(lessThan2048);
        String moreThan2048 = str_len_130;
        int i2 = 0;
        while (i2 < 20) {
            moreThan2048 = String.valueOf(moreThan2048) + str_len_130;
            ++i2;
        }
        int expectedLen = 2730;
        StringSerializerTest.assertTrue((moreThan2048.length() == expectedLen ? 1 : 0) != 0);
        StringSerializerTest.checkFixedDelimited(moreThan2048);
    }

    public void testLegacySurrogatePairs() throws Exception {
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb);
        StringSerializer.writeUTF8((CharSequence)surrogatePairs, (WriteSession)session, (LinkedBuffer)lb);
        byte[] buffered = session.toByteArray();
        StringSerializerTest.assertNotSame((Object)surrogatePairs, (Object)StringSerializer.STRING.deser((byte[])legacySurrogatePairSerialized));
        StringSerializerTest.assertEquals((String)surrogatePairs, (String)StringSerializer.STRING.deser((byte[])buffered));
    }

    public void testSurrogatePairsCustomOnly() throws Exception {
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb);
        StringSerializer.writeUTF8((CharSequence)surrogatePairs, (WriteSession)session, (LinkedBuffer)lb);
        byte[] fastPathBuffered = session.toByteArray();
        lb = new LinkedBuffer(1);
        session = new WriteSession(lb);
        StringSerializer.writeUTF8((CharSequence)surrogatePairs, (WriteSession)session, (LinkedBuffer)lb);
        byte[] slowPathBuffered = session.toByteArray();
        StringSerializerTest.assertTrue((boolean)Arrays.equals(fastPathBuffered, slowPathBuffered));
        StringSerializerTest.assertTrue((boolean)Arrays.equals(fastPathBuffered, nativeSurrogatePairsSerialized));
        StringSerializerTest.assertEquals((String)surrogatePairs, (String)StringSerializer.STRING.deserCustomOnly((byte[])fastPathBuffered));
        StringSerializerTest.assertEquals((String)surrogatePairs, (String)StringSerializer.STRING.deserCustomOnly((byte[])legacySurrogatePairSerialized));
        StringSerializerTest.assertEquals((String)surrogatePairs, (String)new String(nativeSurrogatePairsSerialized, "UTF-8"));
        StringSerializerTest.assertFalse((boolean)Arrays.equals(fastPathBuffered, legacySurrogatePairSerialized));
        try {
            StringSerializerTest.assertEquals((String)surrogatePairs, (String)StringSerializer.STRING.deserCustomOnly((byte[])nativeSurrogatePairsSerialized));
        }
        catch (RuntimeException ex) {
            StringSerializerTest.assertEquals((String)surrogatePairs, (String)StringSerializer.STRING.deser((byte[])nativeSurrogatePairsSerialized));
            StringSerializerTest.fail((String)"Deserializer should not have used built in decoder.");
        }
    }

    public void testPartialSurrogatePair() throws Exception {
        String partial = "\ud83c";
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb);
        StringSerializer.writeUTF8((CharSequence)partial, (WriteSession)session, (LinkedBuffer)lb);
        byte[] buffered = session.toByteArray();
        lb = new LinkedBuffer(1);
        session = new WriteSession(lb);
        StringSerializer.writeUTF8((CharSequence)partial, (WriteSession)session, (LinkedBuffer)lb);
        buffered = session.toByteArray();
    }

    public void testDataInputStreamDecoding() throws Exception {
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb);
        StringSerializer.writeUTF8FixedDelimited((CharSequence)surrogatePairs, (WriteSession)session, (LinkedBuffer)lb);
        byte[] buffered = session.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(buffered);
        DataInputStream din = new DataInputStream(in);
        try {
            String dinResult = din.readUTF();
            StringSerializerTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testReallyLongString() throws Exception {
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb);
        StringBuilder sb = new StringBuilder(98301);
        int i = 0;
        while (i < 98301) {
            sb.append(i % 10);
            ++i;
        }
        String bigString = sb.toString();
        StringSerializer.writeUTF8((CharSequence)bigString, (WriteSession)session, (LinkedBuffer)lb);
        byte[] buffered = session.toByteArray();
        StringSerializerTest.assertEquals((String)bigString, (String)StringSerializer.STRING.deserCustomOnly((byte[])buffered));
    }

    static void checkVarDelimited(CharSequence str, int size, int stringLen) throws Exception {
        LinkedBuffer lb = new LinkedBuffer(512);
        WriteSession session = new WriteSession(lb);
        StringSerializer.writeUTF8VarDelimited((CharSequence)str, (WriteSession)session, (LinkedBuffer)lb);
        byte[] buf = session.toByteArray();
        StringSerializerTest.assertTrue((buf.length == stringLen + size ? 1 : 0) != 0);
        int len = StringSerializerTest.readRawVarint32(lb.buffer, 0);
        StringSerializerTest.assertTrue((len == stringLen ? 1 : 0) != 0);
        StringSerializerTest.print("total len: " + buf.length);
    }

    static void checkFixedDelimited(CharSequence str) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(StringSerializerTest.getShortStringLengthInBytes(str));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        writer.write(str.toString(), 0, str.length());
        writer.close();
        LinkedBuffer lb = new LinkedBuffer(512);
        WriteSession session = new WriteSession(lb);
        StringSerializer.writeUTF8FixedDelimited((CharSequence)str, (WriteSession)session, (LinkedBuffer)lb);
        byte[] b1 = out.toByteArray();
        byte[] b2 = session.toByteArray();
        StringSerializerTest.assertEquals(b1, b2);
    }

    static byte[] getShortStringLengthInBytes(CharSequence str) throws Exception {
        byte[] array = str.toString().getBytes("UTF-8");
        return new byte[]{(byte)(array.length >> 8 & 0xFF), (byte)(array.length & 0xFF)};
    }

    static void assertEquals(byte[] b1, byte[] b2) throws Exception {
        StringSerializerTest.assertTrue((boolean)Arrays.equals(b1, b2));
    }

    static void checkAscii(CharSequence str) throws Exception {
        byte[] builtin = str.toString().getBytes("UTF-8");
        LinkedBuffer lb = new LinkedBuffer(512);
        WriteSession session = new WriteSession(lb);
        StringSerializer.writeAscii((CharSequence)str, (WriteSession)session, (LinkedBuffer)lb);
        StringSerializerTest.assertTrue((builtin.length == session.size ? 1 : 0) != 0);
        byte[] buffered = session.toByteArray();
        StringSerializerTest.assertTrue((builtin.length == buffered.length ? 1 : 0) != 0);
        String strBuiltin = new String(builtin, "ASCII");
        String strBuffered = new String(buffered, "ASCII");
        StringSerializerTest.assertEquals((String)strBuiltin, (String)strBuffered);
        StringSerializerTest.print(strBuiltin);
        StringSerializerTest.print("len: " + builtin.length);
    }

    static void check(CharSequence str) throws Exception {
        byte[] builtin = str.toString().getBytes("UTF-8");
        LinkedBuffer lb = new LinkedBuffer(512);
        WriteSession session = new WriteSession(lb);
        StringSerializer.writeUTF8((CharSequence)str, (WriteSession)session, (LinkedBuffer)lb);
        StringSerializerTest.assertTrue((builtin.length == session.size ? 1 : 0) != 0);
        byte[] buffered = session.toByteArray();
        StringSerializerTest.assertTrue((builtin.length == buffered.length ? 1 : 0) != 0);
        String strBuiltin = new String(builtin, "UTF-8");
        String strBuffered = new String(buffered, "UTF-8");
        StringSerializerTest.assertEquals((String)strBuiltin, (String)strBuffered);
        StringSerializerTest.print(strBuiltin);
        StringSerializerTest.print("len: " + builtin.length);
    }

    static void print(CharSequence msg) {
    }

    static int readRawVarint32(byte[] buffer, int offset) throws IOException {
        byte tmp;
        if ((tmp = buffer[offset++]) >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if ((tmp = buffer[offset++]) >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if ((tmp = buffer[offset++]) >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if ((tmp = buffer[offset++]) >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = buffer[offset++];
                    result |= tmp << 28;
                    if (tmp < 0) {
                        int i = 0;
                        while (i < 5) {
                            if (buffer[offset++] >= 0) {
                                return result;
                            }
                            ++i;
                        }
                        throw new RuntimeException("Malformed varint.");
                    }
                }
            }
        }
        return result;
    }
}

