/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.StreamedStringSerializer;
import io.protostuff.StringSerializer;
import io.protostuff.StringSerializerTest;
import io.protostuff.WriteSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import junit.framework.TestCase;

public class StreamedStringSerializerTest
extends TestCase {
    static final int NUM_BUF_SIZE = 32;
    static final int BUF_SIZE = 256;

    public void testVarDelimitedBoundryTwoByte() throws Exception {
        int size = 16383;
        this.checkVarDelimitedBoundry(1, size);
        this.checkVarDelimitedBoundry(2, size);
        this.checkVarDelimitedBoundry(3, size);
        this.checkVarDelimitedBoundry(4, size);
    }

    public void testVarDelimitedBoundryThreeByte() throws Exception {
        int size = 0x1FFFFF;
        this.checkVarDelimitedBoundry(1, size);
        this.checkVarDelimitedBoundry(2, size);
        this.checkVarDelimitedBoundry(3, size);
        this.checkVarDelimitedBoundry(4, size);
        this.checkVarDelimitedBoundry(5, size);
    }

    public String repeatChar(char ch, int times) {
        StringBuilder sb = new StringBuilder(times);
        int i = 0;
        while (i < times) {
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public void checkVarDelimitedBoundry(int initialGap, int secondWriteSize) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int bufferSize = 256;
        LinkedBuffer lb = new LinkedBuffer(bufferSize);
        WriteSession session = new WriteSession(lb, (OutputStream)out, null, bufferSize);
        StreamedStringSerializer.writeUTF8((CharSequence)this.repeatChar('a', bufferSize - initialGap), (WriteSession)session, (LinkedBuffer)lb);
        StreamedStringSerializerTest.assertTrue((secondWriteSize > bufferSize ? 1 : 0) != 0);
        StreamedStringSerializer.writeUTF8VarDelimited((CharSequence)this.repeatChar('a', secondWriteSize), (WriteSession)session, (LinkedBuffer)lb);
    }

    public void testInt() throws Exception {
        int[] nArray = StringSerializerTest.int_targets;
        int n = StringSerializerTest.int_targets.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb, (OutputStream)out);
            StreamedStringSerializer.writeInt((int)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            LinkedBuffer lb2 = new LinkedBuffer(32);
            WriteSession session2 = new WriteSession(lb2, (OutputStream)out2);
            StreamedStringSerializer.writeInt((int)i, (WriteSession)session2, (LinkedBuffer)lb2);
            LinkedBuffer.writeTo((OutputStream)out2, (LinkedBuffer)lb2);
            byte[] buffered = out.toByteArray();
            byte[] buffered_needed_to_flush = out2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Integer.toString(i));
            StreamedStringSerializerTest.assertEquals(builtin, buffered);
            StreamedStringSerializerTest.assertEquals(builtin, buffered_needed_to_flush);
            ++n2;
        }
    }

    public void testLong() throws Exception {
        long[] lArray = StringSerializerTest.long_targets;
        int n = StringSerializerTest.long_targets.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb, (OutputStream)out);
            StreamedStringSerializer.writeLong((long)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            LinkedBuffer lb2 = new LinkedBuffer(32);
            WriteSession session2 = new WriteSession(lb2, (OutputStream)out2);
            StreamedStringSerializer.writeLong((long)i, (WriteSession)session2, (LinkedBuffer)lb2);
            LinkedBuffer.writeTo((OutputStream)out2, (LinkedBuffer)lb2);
            byte[] buffered = out.toByteArray();
            byte[] buffered_needed_to_flush = out2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Long.toString(i));
            StreamedStringSerializerTest.assertEquals(builtin, buffered);
            StreamedStringSerializerTest.assertEquals(builtin, buffered_needed_to_flush);
            ++n2;
        }
    }

    public void testFloat() throws Exception {
        float[] fArray = StringSerializerTest.float_targets;
        int n = StringSerializerTest.float_targets.length;
        int n2 = 0;
        while (n2 < n) {
            float i = fArray[n2];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb, (OutputStream)out);
            StreamedStringSerializer.writeFloat((float)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            LinkedBuffer lb2 = new LinkedBuffer(32);
            WriteSession session2 = new WriteSession(lb2, (OutputStream)out2);
            StreamedStringSerializer.writeFloat((float)i, (WriteSession)session2, (LinkedBuffer)lb2);
            LinkedBuffer.writeTo((OutputStream)out2, (LinkedBuffer)lb2);
            byte[] buffered = out.toByteArray();
            byte[] buffered_needed_to_flush = out2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Float.toString(i));
            StreamedStringSerializerTest.assertEquals(builtin, buffered);
            StreamedStringSerializerTest.assertEquals(builtin, buffered_needed_to_flush);
            ++n2;
        }
    }

    public void testDouble() throws Exception {
        double[] dArray = StringSerializerTest.double_targets;
        int n = StringSerializerTest.double_targets.length;
        int n2 = 0;
        while (n2 < n) {
            double i = dArray[n2];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb, (OutputStream)out);
            StreamedStringSerializer.writeDouble((double)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            LinkedBuffer lb2 = new LinkedBuffer(32);
            WriteSession session2 = new WriteSession(lb2, (OutputStream)out2);
            StreamedStringSerializer.writeDouble((double)i, (WriteSession)session2, (LinkedBuffer)lb2);
            LinkedBuffer.writeTo((OutputStream)out2, (LinkedBuffer)lb2);
            byte[] buffered = out.toByteArray();
            byte[] buffered_needed_to_flush = out2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Double.toString(i));
            StreamedStringSerializerTest.assertEquals(builtin, buffered);
            StreamedStringSerializerTest.assertEquals(builtin, buffered_needed_to_flush);
            ++n2;
        }
    }

    public void testAscii() throws Exception {
        String[] stringArray = StringSerializerTest.ascii_targets;
        int n = StringSerializerTest.ascii_targets.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StreamedStringSerializerTest.checkAscii(s);
            ++n2;
        }
    }

    public void testUTF8() throws Exception {
        String[] stringArray = StringSerializerTest.targets;
        int n = StringSerializerTest.targets.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StreamedStringSerializerTest.check(s);
            ++n2;
        }
        StreamedStringSerializerTest.check("");
        StreamedStringSerializerTest.check("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
        String lessThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        int i = 0;
        while (i < 14) {
            lessThan2048 = String.valueOf(lessThan2048) + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
            ++i;
        }
        int lt2048Len = 1950;
        StreamedStringSerializerTest.assertTrue((lessThan2048.length() == lt2048Len ? 1 : 0) != 0);
        StreamedStringSerializerTest.check(lessThan2048);
        String moreThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        int i2 = 0;
        while (i2 < 20) {
            moreThan2048 = String.valueOf(moreThan2048) + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
            ++i2;
        }
        int expectedLen = 2730;
        StreamedStringSerializerTest.assertTrue((moreThan2048.length() == expectedLen ? 1 : 0) != 0);
        StreamedStringSerializerTest.check(moreThan2048);
    }

    public void testUTF8VarDelimited() throws Exception {
        StreamedStringSerializerTest.checkVarDelimited("abcdefghijklmnopqrstuvwyxz\u1234\u8000\uf800\u08000123456789\u07ff\u00e1\u0088\u00b4\r\n\t\ud83c\udfe0\ud83c\udf4e\ud83d\udca9", 1, 71);
        StreamedStringSerializerTest.checkVarDelimited("\r\n\t", 1, 3);
        StreamedStringSerializerTest.checkVarDelimited("0123456789", 1, 10);
        StreamedStringSerializerTest.checkVarDelimited("abcdefghijklmnopqrstuvwyxz", 1, 26);
        StreamedStringSerializerTest.checkVarDelimited("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1, 26);
        StreamedStringSerializerTest.checkVarDelimited("\u07ff\u00e1\u0088\u00b4", 1, 8);
        StreamedStringSerializerTest.checkVarDelimited("\u1234\u8000\uf800\u0800", 1, 12);
        StreamedStringSerializerTest.checkVarDelimited("1234567890123456789012345678901234567890", 1, 40);
        StreamedStringSerializerTest.checkVarDelimited("", 1, 0);
        StreamedStringSerializerTest.checkVarDelimited("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890", 2, 130);
        StreamedStringSerializerTest.checkVarDelimited("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890".substring(10), 1, 120);
        String lessThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        int i = 0;
        while (i < 14) {
            lessThan2048 = String.valueOf(lessThan2048) + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
            ++i;
        }
        int lt2048Len = 1950;
        StreamedStringSerializerTest.assertTrue((lessThan2048.length() == lt2048Len ? 1 : 0) != 0);
        StreamedStringSerializerTest.checkVarDelimited(lessThan2048, 2, lt2048Len);
        String moreThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        int i2 = 0;
        while (i2 < 20) {
            moreThan2048 = String.valueOf(moreThan2048) + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
            ++i2;
        }
        int expectedLen = 2730;
        StreamedStringSerializerTest.assertTrue((moreThan2048.length() == expectedLen ? 1 : 0) != 0);
        StreamedStringSerializerTest.checkVarDelimited(moreThan2048, 2, expectedLen);
        String str16383 = this.repeatChar('z', 16383);
        String str16384 = String.valueOf(str16383) + "g";
        StreamedStringSerializerTest.checkVarDelimited(str16383, 2, str16383.length());
        StreamedStringSerializerTest.checkVarDelimited(str16384, 3, str16384.length());
    }

    public void testUTF8FixedDelimited() throws Exception {
        String[] stringArray = StringSerializerTest.targets;
        int n = StringSerializerTest.targets.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StreamedStringSerializerTest.checkFixedDelimited(s);
            ++n2;
        }
        StreamedStringSerializerTest.checkFixedDelimited("1234567890123456789012345678901234567890");
        StreamedStringSerializerTest.checkFixedDelimited("");
        StreamedStringSerializerTest.checkFixedDelimited("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
        String lessThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        int i = 0;
        while (i < 14) {
            lessThan2048 = String.valueOf(lessThan2048) + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
            ++i;
        }
        int lt2048Len = 1950;
        StreamedStringSerializerTest.assertTrue((lessThan2048.length() == lt2048Len ? 1 : 0) != 0);
        StreamedStringSerializerTest.checkFixedDelimited(lessThan2048);
        String moreThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        int i2 = 0;
        while (i2 < 20) {
            moreThan2048 = String.valueOf(moreThan2048) + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
            ++i2;
        }
        int expectedLen = 2730;
        StreamedStringSerializerTest.assertTrue((moreThan2048.length() == expectedLen ? 1 : 0) != 0);
        StreamedStringSerializerTest.checkFixedDelimited(moreThan2048);
    }

    public void testSurrogatePairs() throws Exception {
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb);
        StreamedStringSerializer.writeUTF8((CharSequence)"\ud83c\udfe0\ud83c\udf4e\ud83d\udca9", (WriteSession)session, (LinkedBuffer)lb);
        byte[] buffered = session.toByteArray();
        StreamedStringSerializerTest.assertTrue((boolean)Arrays.equals(buffered, StringSerializerTest.nativeSurrogatePairsSerialized));
        StreamedStringSerializerTest.assertEquals((String)"\ud83c\udfe0\ud83c\udf4e\ud83d\udca9", (String)StringSerializer.STRING.deserCustomOnly((byte[])buffered));
        StreamedStringSerializerTest.assertEquals((String)"\ud83c\udfe0\ud83c\udf4e\ud83d\udca9", (String)StringSerializer.STRING.deserCustomOnly((byte[])StringSerializerTest.legacySurrogatePairSerialized));
        StreamedStringSerializerTest.assertEquals((String)"\ud83c\udfe0\ud83c\udf4e\ud83d\udca9", (String)new String(StringSerializerTest.nativeSurrogatePairsSerialized, "UTF-8"));
        StreamedStringSerializerTest.assertFalse((boolean)Arrays.equals(buffered, StringSerializerTest.legacySurrogatePairSerialized));
        try {
            StreamedStringSerializerTest.assertEquals((String)"\ud83c\udfe0\ud83c\udf4e\ud83d\udca9", (String)StringSerializer.STRING.deserCustomOnly((byte[])StringSerializerTest.nativeSurrogatePairsSerialized));
        }
        catch (RuntimeException ex) {
            StreamedStringSerializerTest.assertEquals((String)"\ud83c\udfe0\ud83c\udf4e\ud83d\udca9", (String)StringSerializer.STRING.deser((byte[])StringSerializerTest.nativeSurrogatePairsSerialized));
            StreamedStringSerializerTest.fail((String)"Deserializer should not have used built in decoder.");
        }
    }

    public void testPartialSurrogatePair() throws Exception {
        String partial = "\ud83c";
        LinkedBuffer lb = new LinkedBuffer(3);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WriteSession session = new WriteSession(lb, (OutputStream)out);
        StreamedStringSerializer.writeUTF8((CharSequence)partial, (WriteSession)session, (LinkedBuffer)lb);
        byte[] buffered = session.toByteArray();
    }

    static void checkVarDelimited(CharSequence str, int size, int stringLen) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb, (OutputStream)out);
        StreamedStringSerializer.writeUTF8VarDelimited((CharSequence)str, (WriteSession)session, (LinkedBuffer)lb);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
        byte[] buf = out.toByteArray();
        StreamedStringSerializerTest.assertTrue((buf.length == stringLen + size ? 1 : 0) != 0);
        int len = StringSerializerTest.readRawVarint32(buf, 0);
        StreamedStringSerializerTest.assertTrue((len == stringLen ? 1 : 0) != 0);
        StreamedStringSerializerTest.print("total len: " + buf.length);
    }

    static void checkFixedDelimited(CharSequence str) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        bout.write(StringSerializerTest.getShortStringLengthInBytes(str));
        writer.write(str.toString(), 0, str.length());
        writer.close();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb, (OutputStream)out);
        StreamedStringSerializer.writeUTF8FixedDelimited((CharSequence)str, (WriteSession)session, (LinkedBuffer)lb);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
        byte[] b1 = bout.toByteArray();
        byte[] b2 = out.toByteArray();
        StreamedStringSerializerTest.assertEquals(b1, b2);
    }

    static void assertEquals(byte[] b1, byte[] b2) throws Exception {
        String s1 = new String(b1, "UTF-8");
        String s2 = new String(b2, "UTF-8");
        StreamedStringSerializerTest.assertEquals((String)s1, (String)s2);
    }

    static void checkAscii(CharSequence str) throws Exception {
        byte[] builtin = str.toString().getBytes("UTF-8");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb, (OutputStream)out);
        StreamedStringSerializer.writeAscii((CharSequence)str, (WriteSession)session, (LinkedBuffer)lb);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
        StreamedStringSerializerTest.assertTrue((builtin.length == session.size ? 1 : 0) != 0);
        byte[] buffered = out.toByteArray();
        StreamedStringSerializerTest.assertTrue((builtin.length == buffered.length ? 1 : 0) != 0);
        String strBuiltin = new String(builtin, "ASCII");
        String strBuffered = new String(buffered, "ASCII");
        StreamedStringSerializerTest.assertEquals((String)strBuiltin, (String)strBuffered);
        StreamedStringSerializerTest.print(strBuiltin);
        StreamedStringSerializerTest.print("len: " + builtin.length);
    }

    static void check(CharSequence str) throws Exception {
        byte[] builtin = str.toString().getBytes("UTF-8");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb, (OutputStream)out);
        StreamedStringSerializer.writeUTF8((CharSequence)str, (WriteSession)session, (LinkedBuffer)lb);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
        StreamedStringSerializerTest.assertTrue((builtin.length == session.size ? 1 : 0) != 0);
        byte[] buffered = out.toByteArray();
        StreamedStringSerializerTest.assertTrue((builtin.length == buffered.length ? 1 : 0) != 0);
        String strBuiltin = new String(builtin, "UTF-8");
        String strBuffered = new String(buffered, "UTF-8");
        StreamedStringSerializerTest.assertEquals((String)strBuiltin, (String)strBuffered);
        StreamedStringSerializerTest.assertTrue((boolean)Arrays.equals(builtin, buffered));
        StreamedStringSerializerTest.assertEquals((String)StringSerializer.STRING.deser((byte[])builtin), (String)StringSerializer.STRING.deser((byte[])buffered));
        StreamedStringSerializerTest.print(strBuiltin);
        StreamedStringSerializerTest.print("len: " + builtin.length);
    }

    static void checkEncodedStringWithVarDelimited(byte[] buffer, String str, int offset, int len) throws Exception {
        StreamedStringSerializerTest.assertEquals((int)len, (int)StringSerializerTest.readRawVarint32(buffer, offset));
        String deser = StringSerializer.STRING.deser((byte[])buffer, (int)(offset + 2), (int)len);
        StreamedStringSerializerTest.assertEquals((int)str.length(), (int)deser.length());
        StreamedStringSerializerTest.assertEquals((String)str, (String)deser);
    }

    public void testMultipleLargeStringsExceedingBufferSize() throws Exception {
        LinkedBuffer buffer = LinkedBuffer.allocate((int)256);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WriteSession session = new WriteSession(buffer, (OutputStream)out);
        String utf8OneByte = this.repeatChar('a', 1024);
        String utf8TwoBytes = this.repeatChar('\u07ff', 512);
        String utf8ThreeBytes = this.repeatChar('\u0800', 341);
        StreamedStringSerializerTest.writeToSession(utf8OneByte, utf8TwoBytes, utf8ThreeBytes, session, false);
        StreamedStringSerializerTest.assertTrue((session.tail == session.head ? 1 : 0) != 0);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
        buffer.clear();
        byte[] data = out.toByteArray();
        LinkedBuffer buffer2 = LinkedBuffer.allocate((int)256);
        WriteSession session2 = new WriteSession(buffer2);
        StreamedStringSerializerTest.writeToSession(utf8OneByte, utf8TwoBytes, utf8ThreeBytes, session2, false);
        byte[] data2 = session2.toByteArray();
        StreamedStringSerializerTest.assertEquals((String)StringSerializer.STRING.deser((byte[])data), (String)StringSerializer.STRING.deser((byte[])data2));
    }

    public void testMultipleLargeStringsExceedingBufferSizeDelimited() throws Exception {
        LinkedBuffer buffer = LinkedBuffer.allocate((int)256);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WriteSession session = new WriteSession(buffer, (OutputStream)out);
        String utf8OneByte = this.repeatChar('a', 1024);
        String utf8TwoBytes = this.repeatChar('\u07ff', 512);
        String utf8ThreeBytes = this.repeatChar('\u0800', 341);
        StreamedStringSerializerTest.writeToSession(utf8OneByte, utf8TwoBytes, utf8ThreeBytes, session, true);
        StreamedStringSerializerTest.assertTrue((session.tail == session.head ? 1 : 0) != 0);
        StreamedStringSerializerTest.assertTrue((session.tail.next != null ? 1 : 0) != 0);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
        buffer.clear();
        byte[] data = out.toByteArray();
        LinkedBuffer buffer2 = LinkedBuffer.allocate((int)256);
        WriteSession session2 = new WriteSession(buffer2);
        StreamedStringSerializerTest.writeToSession(utf8OneByte, utf8TwoBytes, utf8ThreeBytes, session2, true);
        byte[] data2 = session2.toByteArray();
        StreamedStringSerializerTest.assertEquals((int)data.length, (int)data2.length);
        int i = 0;
        while (i < data.length) {
            StreamedStringSerializerTest.assertEquals((byte)data[i], (byte)data2[i]);
            ++i;
        }
        int offset = 0;
        StreamedStringSerializerTest.checkEncodedStringWithVarDelimited(data, utf8OneByte, offset, 1024);
        StreamedStringSerializerTest.checkEncodedStringWithVarDelimited(data, utf8OneByte, offset += 1026, 1024);
        StreamedStringSerializerTest.checkEncodedStringWithVarDelimited(data, utf8TwoBytes, offset += 1026, 1024);
        StreamedStringSerializerTest.checkEncodedStringWithVarDelimited(data, utf8TwoBytes, offset += 1026, 1024);
        StreamedStringSerializerTest.checkEncodedStringWithVarDelimited(data, utf8ThreeBytes, offset += 1026, 1023);
        StreamedStringSerializerTest.checkEncodedStringWithVarDelimited(data, utf8ThreeBytes, offset += 1025, 1023);
        StreamedStringSerializerTest.assertEquals((int)(offset += 1025), (int)data.length);
    }

    static void writeToSession(CharSequence str1, CharSequence str2, CharSequence str3, WriteSession session, boolean delimited) throws IOException {
        if (delimited) {
            session.tail = session.sink.writeStrUTF8VarDelimited(str1, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str1, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str2, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str2, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str3, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str3, session, session.tail);
        } else {
            session.tail = session.sink.writeStrUTF8(str1, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str1, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str2, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str2, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str3, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str3, session, session.tail);
        }
    }

    static void print(CharSequence msg) {
    }
}

