/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.B64Code;
import io.protostuff.LinkedBuffer;
import io.protostuff.StringSerializer;
import io.protostuff.WriteSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.TestCase;

public class B64CodeTest
extends TestCase {
    public void testStream() throws Exception {
        B64CodeTest.testStream("1234567", new LinkedBuffer(12));
        B64CodeTest.testStream("1234567", B64CodeTest.str('a', 4), B64CodeTest.newBuffer(12, 'a', 4));
        B64CodeTest.testStream("1234567", new LinkedBuffer(4));
        B64CodeTest.testStream("1234567", B64CodeTest.str('a', 1), B64CodeTest.newBuffer(4, 'a', 1));
        B64CodeTest.testStream("1234567", B64CodeTest.str('a', 4), B64CodeTest.newBuffer(8, 'a', 4));
    }

    public void testBuffer() throws Exception {
        B64CodeTest.testBuffer("1234567", new LinkedBuffer(12));
        B64CodeTest.testBuffer("1234567", new LinkedBuffer(3));
        B64CodeTest.testBuffer("1234567", new LinkedBuffer(4));
        B64CodeTest.testBuffer("1234567", B64CodeTest.str('a', 1), B64CodeTest.newBuffer(4, 'a', 1));
        B64CodeTest.testBuffer("1234567", B64CodeTest.str('a', 1), B64CodeTest.newBuffer(4, 'a', 1), 4);
        B64CodeTest.testBuffer("1234567", B64CodeTest.str('a', 4), B64CodeTest.newBuffer(8, 'a', 4));
        B64CodeTest.testBuffer("1234567", B64CodeTest.str('a', 4), B64CodeTest.newBuffer(8, 'a', 4), 3);
    }

    public void testDecodeFromString() throws Exception {
        String[] stringArray = new String[]{"abcdefgh", "1", "12", "123", "1234", "12345"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            byte[] b64Encoded = B64Code.encode((byte[])str.getBytes("UTF-8"));
            byte[] decoded = B64Code.decode((byte[])b64Encoded);
            byte[] decodedFromString = B64Code.decode((String)new String(b64Encoded, "UTF-8"));
            B64CodeTest.assertEquals((String)StringSerializer.STRING.deser((byte[])decoded), (String)StringSerializer.STRING.deser((byte[])decodedFromString));
            B64CodeTest.assertEquals((String)str, (String)StringSerializer.STRING.deser((byte[])decoded));
            ++n2;
        }
    }

    public void testDecodeTo() throws Exception {
        String[] stringArray = new String[]{"abcdefgh", "1", "12", "123", "1234", "12345"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            byte[] b64Encoded = B64Code.encode((byte[])str.getBytes("UTF-8"));
            byte[] decoded = new byte[16];
            int decodedLen = B64Code.decodeTo((byte[])decoded, (int)0, (byte[])b64Encoded, (int)0, (int)b64Encoded.length);
            byte[] decodedFromString = B64Code.decode((String)new String(b64Encoded, "UTF-8"));
            String a = StringSerializer.STRING.deser((byte[])decoded, (int)0, (int)decodedLen);
            String b = StringSerializer.STRING.deser((byte[])decodedFromString);
            boolean x = a.equals(b);
            int lenA = a.length();
            int lenB = b.length();
            B64CodeTest.assertEquals((String)StringSerializer.STRING.deser((byte[])decoded, (int)0, (int)decodedLen), (String)StringSerializer.STRING.deser((byte[])decodedFromString));
            B64CodeTest.assertEquals((String)str, (String)StringSerializer.STRING.deser((byte[])decoded, (int)0, (int)decodedLen));
            ++n2;
        }
    }

    public void testStringDecodeTo() throws Exception {
        String[] stringArray = new String[]{"abcdefgh", "1", "12", "123", "1234", "12345"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            byte[] b64Encoded = B64Code.encode((byte[])str.getBytes("UTF-8"));
            byte[] decoded = new byte[16];
            int decodedLen = B64Code.decodeTo((byte[])decoded, (int)0, (byte[])b64Encoded, (int)0, (int)b64Encoded.length);
            String encodedString = new String(b64Encoded, "UTF-8");
            byte[] decodedFromString = new byte[16];
            int decodedFromStringLen = B64Code.decodeTo((byte[])decodedFromString, (int)0, (String)encodedString, (int)0, (int)encodedString.length());
            B64CodeTest.assertEquals((String)StringSerializer.STRING.deser((byte[])decoded, (int)0, (int)decodedLen), (String)StringSerializer.STRING.deser((byte[])decodedFromString, (int)0, (int)decodedFromStringLen));
            B64CodeTest.assertEquals((String)str, (String)StringSerializer.STRING.deser((byte[])decoded, (int)0, (int)decodedLen));
            ++n2;
        }
    }

    public void testRoundtripFromString() throws Exception {
        String[] stringArray = new String[]{"abcdefghijklmnopqrstuvwxyz", "0123456789", "abcdefghijklmnopqrstuvwxyz0123456789"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.verifyRoundTrip(str.getBytes("UTF-8"));
            ++n2;
        }
    }

    public void testRoundtrip() {
        byte[][] byArrayArray = new byte[16][];
        byArrayArray[0] = new byte[4];
        byte[] byArray = new byte[8];
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 1;
        byArrayArray[1] = byArray;
        byArrayArray[2] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        byte[] byArray2 = new byte[10];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 4;
        byArray2[5] = 5;
        byArray2[6] = 6;
        byArray2[7] = 7;
        byArray2[8] = 8;
        byArray2[9] = 9;
        byArrayArray[3] = byArray2;
        byArrayArray[4] = new byte[]{10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
        byArrayArray[5] = new byte[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
        byArrayArray[6] = new byte[]{30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
        byArrayArray[7] = new byte[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49};
        byArrayArray[8] = new byte[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59};
        byArrayArray[9] = new byte[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69};
        byArrayArray[10] = new byte[]{70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
        byArrayArray[11] = new byte[]{80, 81, 82, 83, 84, 85, 86, 87, 88, 89};
        byArrayArray[12] = new byte[]{90, 91, 92, 93, 94, 95, 96, 97, 98, 99};
        byArrayArray[13] = new byte[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 109};
        byArrayArray[14] = new byte[]{110, 111, 112, 113, 114, 115, 116, 117, 118, 119};
        byArrayArray[15] = new byte[]{120, 121, 122, 123, 124, 125, 126, 127};
        byte[][] byArrayArray2 = byArrayArray;
        int n = byArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] b = byArrayArray2[n2];
            this.verifyRoundTrip(b);
            ++n2;
        }
    }

    void verifyRoundTrip(byte[] raw) {
        byte[] encoded = B64Code.encode((byte[])raw);
        byte[] decoded = B64Code.decode((byte[])encoded);
        B64CodeTest.assertTrue((boolean)Arrays.equals(raw, decoded));
        char[] cencoded = B64Code.cencode((byte[])raw);
        B64CodeTest.verifyArrayContentEqual(cencoded, encoded);
        B64CodeTest.assertTrue((boolean)Arrays.equals(raw, B64Code.cdecode((char[])cencoded)));
    }

    static String str(char c, int size) {
        char[] array = new char[size];
        Arrays.fill(array, c);
        return new String(array);
    }

    static LinkedBuffer newBuffer(int size, char c, int loops) {
        LinkedBuffer lb = new LinkedBuffer(size);
        while (loops-- > 0) {
            lb.buffer[lb.offset++] = (byte)c;
        }
        return lb;
    }

    static void testStream(String str, LinkedBuffer tail) throws IOException {
        B64CodeTest.testStream(str, "", tail);
    }

    static void testStream(String str, String prefix, LinkedBuffer tail) throws IOException {
        byte[] copy = new byte[tail.offset - tail.start];
        System.arraycopy(tail.buffer, tail.start, copy, 0, tail.offset - tail.start);
        byte[] data = str.getBytes();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WriteSession session = new WriteSession(tail, (OutputStream)out);
        session.size += tail.offset - tail.start;
        tail = B64Code.sencode((byte[])data, (int)0, (int)data.length, (WriteSession)session, (LinkedBuffer)tail);
        B64CodeTest.assertTrue((tail == session.head ? 1 : 0) != 0);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)tail);
        byte[] dataFromStream = out.toByteArray();
        B64CodeTest.verifyB64(str, prefix, dataFromStream);
        WriteSession bws = new WriteSession(new LinkedBuffer(copy, 0));
        bws.tail.offset += copy.length;
        bws.size += copy.length;
        bws.tail = B64Code.encode((byte[])data, (int)0, (int)data.length, (WriteSession)bws, (LinkedBuffer)bws.tail);
        B64CodeTest.assertTrue((boolean)Arrays.equals(dataFromStream, bws.toByteArray()));
    }

    static void verifyB64(String str, String prefix, byte[] result) {
        byte[] decoded = B64Code.decode((byte[])result, (int)prefix.length(), (int)(result.length - prefix.length()));
        String strd = new String(decoded);
        B64CodeTest.assertEquals((String)str, (String)strd);
        char[] cresult = B64CodeTest.toCharArray(result);
        byte[] decoded2 = B64Code.cdecode((char[])cresult, (int)prefix.length(), (int)(cresult.length - prefix.length()));
        B64CodeTest.assertTrue((boolean)Arrays.equals(decoded, decoded2));
        char[] cencoded = B64Code.cencode((byte[])decoded);
        byte[] encoded = B64Code.encode((byte[])decoded);
        B64CodeTest.assertTrue((cencoded.length == encoded.length ? 1 : 0) != 0);
        B64CodeTest.verifyArrayContentEqual(cencoded, encoded);
    }

    static void verifyArrayContentEqual(char[] cencoded, byte[] encoded) {
        int i = 0;
        int len = encoded.length;
        while (i < len) {
            B64CodeTest.assertTrue((cencoded[i] == encoded[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    static void testBuffer(String str, LinkedBuffer tail) throws IOException {
        B64CodeTest.testBuffer(str, "", tail);
    }

    static void testBuffer(String str, String prefix, LinkedBuffer tail) throws IOException {
        B64CodeTest.testBuffer(str, prefix, tail, 512);
    }

    static void testBuffer(String str, String prefix, LinkedBuffer tail, int nextBufferSize) throws IOException {
        byte[] data = str.getBytes();
        WriteSession session = new WriteSession(tail, nextBufferSize);
        session.size += tail.offset - tail.start;
        tail = B64Code.encode((byte[])data, (int)0, (int)data.length, (WriteSession)session, (LinkedBuffer)tail);
        byte[] result = session.toByteArray();
        B64CodeTest.verifyB64(str, prefix, result);
    }

    static char[] toCharArray(byte[] buf) {
        char[] c = new char[buf.length];
        int i = 0;
        while (i < buf.length) {
            c[i] = (char)buf[i];
            ++i;
        }
        return c;
    }
}

