/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.NumberParser;
import io.protostuff.StringSerializer;
import io.protostuff.WriteSession;
import java.io.IOException;
import junit.framework.TestCase;

public class NumberParserTest
extends TestCase {
    public void testParseInt() throws Exception {
        NumberParserTest.assertTrue((0 == NumberParser.parseInt((byte[])new byte[]{48}, (int)0, (int)1, (int)10) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((1 == NumberParser.parseInt((byte[])new byte[]{49}, (int)0, (int)1, (int)10) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((-1 == NumberParser.parseInt((byte[])new byte[]{45, 49}, (int)0, (int)2, (int)10) ? 1 : 0) != 0);
        LinkedBuffer lb = LinkedBuffer.allocate((int)256);
        WriteSession session = new WriteSession(lb);
        NumberParserTest.assertTrue((lb == StringSerializer.writeInt((int)Integer.MAX_VALUE, (WriteSession)session, (LinkedBuffer)session.tail) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((Integer.MAX_VALUE == NumberParser.parseInt((byte[])session.toByteArray(), (int)0, (int)session.size, (int)10) ? 1 : 0) != 0);
        session.clear();
        NumberParserTest.assertTrue((lb == StringSerializer.writeInt((int)0x7FFFFFFE, (WriteSession)session, (LinkedBuffer)session.tail) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((0x7FFFFFFE == NumberParser.parseInt((byte[])session.toByteArray(), (int)0, (int)session.size, (int)10) ? 1 : 0) != 0);
        session.clear();
        NumberParserTest.assertTrue((lb == StringSerializer.writeInt((int)Integer.MIN_VALUE, (WriteSession)session, (LinkedBuffer)session.tail) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((Integer.MIN_VALUE == NumberParser.parseInt((byte[])session.toByteArray(), (int)0, (int)session.size, (int)10) ? 1 : 0) != 0);
        session.clear();
        NumberParserTest.assertTrue((lb == StringSerializer.writeInt((int)-2147483647, (WriteSession)session, (LinkedBuffer)session.tail) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((-2147483647 == NumberParser.parseInt((byte[])session.toByteArray(), (int)0, (int)session.size, (int)10) ? 1 : 0) != 0);
    }

    public void testParseLong() throws IOException {
        NumberParserTest.assertTrue((0L == NumberParser.parseLong((byte[])new byte[]{48}, (int)0, (int)1, (int)10) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((1L == NumberParser.parseLong((byte[])new byte[]{49}, (int)0, (int)1, (int)10) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((-1L == NumberParser.parseLong((byte[])new byte[]{45, 49}, (int)0, (int)2, (int)10) ? 1 : 0) != 0);
        LinkedBuffer lb = LinkedBuffer.allocate((int)256);
        WriteSession session = new WriteSession(lb);
        NumberParserTest.assertTrue((lb == StringSerializer.writeLong((long)Long.MAX_VALUE, (WriteSession)session, (LinkedBuffer)session.tail) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((Long.MAX_VALUE == NumberParser.parseLong((byte[])session.toByteArray(), (int)0, (int)session.size, (int)10) ? 1 : 0) != 0);
        session.clear();
        NumberParserTest.assertTrue((lb == StringSerializer.writeLong((long)0x7FFFFFFFFFFFFFFEL, (WriteSession)session, (LinkedBuffer)session.tail) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((0x7FFFFFFFFFFFFFFEL == NumberParser.parseLong((byte[])session.toByteArray(), (int)0, (int)session.size, (int)10) ? 1 : 0) != 0);
        session.clear();
        NumberParserTest.assertTrue((lb == StringSerializer.writeLong((long)Long.MIN_VALUE, (WriteSession)session, (LinkedBuffer)session.tail) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((Long.MIN_VALUE == NumberParser.parseLong((byte[])session.toByteArray(), (int)0, (int)session.size, (int)10) ? 1 : 0) != 0);
        session.clear();
        NumberParserTest.assertTrue((lb == StringSerializer.writeLong((long)-9223372036854775807L, (WriteSession)session, (LinkedBuffer)session.tail) ? 1 : 0) != 0);
        NumberParserTest.assertTrue((-9223372036854775807L == NumberParser.parseLong((byte[])session.toByteArray(), (int)0, (int)session.size, (int)10) ? 1 : 0) != 0);
    }
}

