/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.StreamedStringSerializer;
import io.protostuff.StringSerializer;
import io.protostuff.StringSerializerTest;
import io.protostuff.WriteSession;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;

public class StreamedStringSerializerTest
extends TestCase {
    static final int NUM_BUF_SIZE = 32;
    static final int BUF_SIZE = 256;

    public void testVarDelimitedBoundryTwoByte() throws Exception {
        int size = 16383;
        this.checkVarDelimitedBoundry(1, size);
        this.checkVarDelimitedBoundry(2, size);
        this.checkVarDelimitedBoundry(3, size);
        this.checkVarDelimitedBoundry(4, size);
    }

    public void testVarDelimitedBoundryThreeByte() throws Exception {
        int size = 0x1FFFFF;
        this.checkVarDelimitedBoundry(1, size);
        this.checkVarDelimitedBoundry(2, size);
        this.checkVarDelimitedBoundry(3, size);
        this.checkVarDelimitedBoundry(4, size);
        this.checkVarDelimitedBoundry(5, size);
    }

    public String repeatChar(char ch, int times) {
        StringBuilder sb = new StringBuilder(times);
        for (int i = 0; i < times; ++i) {
            sb.append(ch);
        }
        return sb.toString();
    }

    public void checkVarDelimitedBoundry(int initialGap, int secondWriteSize) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int bufferSize = 256;
        LinkedBuffer lb = new LinkedBuffer(bufferSize);
        WriteSession session = new WriteSession(lb, (OutputStream)out, null, bufferSize);
        StreamedStringSerializer.writeUTF8((String)this.repeatChar('a', bufferSize - initialGap), (WriteSession)session, (LinkedBuffer)lb);
        StreamedStringSerializerTest.assertTrue((secondWriteSize > bufferSize ? 1 : 0) != 0);
        StreamedStringSerializer.writeUTF8VarDelimited((String)this.repeatChar('a', secondWriteSize), (WriteSession)session, (LinkedBuffer)lb);
    }

    public void testInt() throws Exception {
        for (int i : StringSerializerTest.int_targets) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb, (OutputStream)out);
            StreamedStringSerializer.writeInt((int)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            LinkedBuffer lb2 = new LinkedBuffer(32);
            WriteSession session2 = new WriteSession(lb2, (OutputStream)out2);
            StreamedStringSerializer.writeInt((int)i, (WriteSession)session2, (LinkedBuffer)lb2);
            LinkedBuffer.writeTo((OutputStream)out2, (LinkedBuffer)lb2);
            byte[] buffered = out.toByteArray();
            byte[] buffered_needed_to_flush = out2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Integer.toString(i));
            StreamedStringSerializerTest.assertEquals(builtin, buffered);
            StreamedStringSerializerTest.assertEquals(builtin, buffered_needed_to_flush);
        }
    }

    public void testLong() throws Exception {
        for (long i : StringSerializerTest.long_targets) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb, (OutputStream)out);
            StreamedStringSerializer.writeLong((long)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            LinkedBuffer lb2 = new LinkedBuffer(32);
            WriteSession session2 = new WriteSession(lb2, (OutputStream)out2);
            StreamedStringSerializer.writeLong((long)i, (WriteSession)session2, (LinkedBuffer)lb2);
            LinkedBuffer.writeTo((OutputStream)out2, (LinkedBuffer)lb2);
            byte[] buffered = out.toByteArray();
            byte[] buffered_needed_to_flush = out2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Long.toString(i));
            StreamedStringSerializerTest.assertEquals(builtin, buffered);
            StreamedStringSerializerTest.assertEquals(builtin, buffered_needed_to_flush);
        }
    }

    public void testFloat() throws Exception {
        for (float i : StringSerializerTest.float_targets) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb, (OutputStream)out);
            StreamedStringSerializer.writeFloat((float)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            LinkedBuffer lb2 = new LinkedBuffer(32);
            WriteSession session2 = new WriteSession(lb2, (OutputStream)out2);
            StreamedStringSerializer.writeFloat((float)i, (WriteSession)session2, (LinkedBuffer)lb2);
            LinkedBuffer.writeTo((OutputStream)out2, (LinkedBuffer)lb2);
            byte[] buffered = out.toByteArray();
            byte[] buffered_needed_to_flush = out2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Float.toString(i));
            StreamedStringSerializerTest.assertEquals(builtin, buffered);
            StreamedStringSerializerTest.assertEquals(builtin, buffered_needed_to_flush);
        }
    }

    public void testDouble() throws Exception {
        for (double i : StringSerializerTest.double_targets) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LinkedBuffer lb = new LinkedBuffer(256);
            WriteSession session = new WriteSession(lb, (OutputStream)out);
            StreamedStringSerializer.writeDouble((double)i, (WriteSession)session, (LinkedBuffer)lb);
            LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            LinkedBuffer lb2 = new LinkedBuffer(32);
            WriteSession session2 = new WriteSession(lb2, (OutputStream)out2);
            StreamedStringSerializer.writeDouble((double)i, (WriteSession)session2, (LinkedBuffer)lb2);
            LinkedBuffer.writeTo((OutputStream)out2, (LinkedBuffer)lb2);
            byte[] buffered = out.toByteArray();
            byte[] buffered_needed_to_flush = out2.toByteArray();
            byte[] builtin = StringSerializer.STRING.ser((String)Double.toString(i));
            StreamedStringSerializerTest.assertEquals(builtin, buffered);
            StreamedStringSerializerTest.assertEquals(builtin, buffered_needed_to_flush);
        }
    }

    public void testAscii() throws Exception {
        for (String s : StringSerializerTest.ascii_targets) {
            StreamedStringSerializerTest.checkAscii(s);
        }
    }

    public void testUTF8() throws Exception {
        for (String s : StringSerializerTest.targets) {
            StreamedStringSerializerTest.check(s);
        }
        StreamedStringSerializerTest.check("");
        StreamedStringSerializerTest.check("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
        String lessThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        for (int i = 0; i < 14; ++i) {
            lessThan2048 = lessThan2048 + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        }
        int lt2048Len = 1950;
        StreamedStringSerializerTest.assertTrue((lessThan2048.length() == lt2048Len ? 1 : 0) != 0);
        StreamedStringSerializerTest.check(lessThan2048);
        String moreThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        for (int i = 0; i < 20; ++i) {
            moreThan2048 = moreThan2048 + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        }
        int expectedLen = 2730;
        StreamedStringSerializerTest.assertTrue((moreThan2048.length() == expectedLen ? 1 : 0) != 0);
        StreamedStringSerializerTest.check(moreThan2048);
    }

    public void testUTF8VarDelimited() throws Exception {
        StreamedStringSerializerTest.checkVarDelimited("abcdefghijklmnopqrstuvwyxz\u1234\u8000\uf800\u08000123456789\u07ff\u00e1\u0088\u00b4\r\n\t", 1, 59);
        StreamedStringSerializerTest.checkVarDelimited("\r\n\t", 1, 3);
        StreamedStringSerializerTest.checkVarDelimited("0123456789", 1, 10);
        StreamedStringSerializerTest.checkVarDelimited("abcdefghijklmnopqrstuvwyxz", 1, 26);
        StreamedStringSerializerTest.checkVarDelimited("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1, 26);
        StreamedStringSerializerTest.checkVarDelimited("\u07ff\u00e1\u0088\u00b4", 1, 8);
        StreamedStringSerializerTest.checkVarDelimited("\u1234\u8000\uf800\u0800", 1, 12);
        StreamedStringSerializerTest.checkVarDelimited("1234567890123456789012345678901234567890", 1, 40);
        StreamedStringSerializerTest.checkVarDelimited("", 1, 0);
        StreamedStringSerializerTest.checkVarDelimited("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890", 2, 130);
        StreamedStringSerializerTest.checkVarDelimited("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890".substring(10), 1, 120);
        String lessThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        for (int i = 0; i < 14; ++i) {
            lessThan2048 = lessThan2048 + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        }
        int lt2048Len = 1950;
        StreamedStringSerializerTest.assertTrue((lessThan2048.length() == lt2048Len ? 1 : 0) != 0);
        StreamedStringSerializerTest.checkVarDelimited(lessThan2048, 2, lt2048Len);
        String moreThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        for (int i = 0; i < 20; ++i) {
            moreThan2048 = moreThan2048 + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        }
        int expectedLen = 2730;
        StreamedStringSerializerTest.assertTrue((moreThan2048.length() == expectedLen ? 1 : 0) != 0);
        StreamedStringSerializerTest.checkVarDelimited(moreThan2048, 2, expectedLen);
        String str16383 = this.repeatChar('z', 16383);
        String str16384 = str16383 + "g";
        StreamedStringSerializerTest.checkVarDelimited(str16383, 2, str16383.length());
        StreamedStringSerializerTest.checkVarDelimited(str16384, 3, str16384.length());
    }

    public void testUTF8FixedDelimited() throws Exception {
        for (String s : StringSerializerTest.targets) {
            StreamedStringSerializerTest.checkFixedDelimited(s);
        }
        StreamedStringSerializerTest.checkFixedDelimited("1234567890123456789012345678901234567890");
        StreamedStringSerializerTest.checkFixedDelimited("");
        StreamedStringSerializerTest.checkFixedDelimited("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
        String lessThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        for (int i = 0; i < 14; ++i) {
            lessThan2048 = lessThan2048 + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        }
        int lt2048Len = 1950;
        StreamedStringSerializerTest.assertTrue((lessThan2048.length() == lt2048Len ? 1 : 0) != 0);
        StreamedStringSerializerTest.checkFixedDelimited(lessThan2048);
        String moreThan2048 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        for (int i = 0; i < 20; ++i) {
            moreThan2048 = moreThan2048 + "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        }
        int expectedLen = 2730;
        StreamedStringSerializerTest.assertTrue((moreThan2048.length() == expectedLen ? 1 : 0) != 0);
        StreamedStringSerializerTest.checkFixedDelimited(moreThan2048);
    }

    static void checkVarDelimited(String str, int size, int stringLen) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb, (OutputStream)out);
        StreamedStringSerializer.writeUTF8VarDelimited((String)str, (WriteSession)session, (LinkedBuffer)lb);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
        byte[] buf = out.toByteArray();
        StreamedStringSerializerTest.assertTrue((buf.length == stringLen + size ? 1 : 0) != 0);
        int len = StringSerializerTest.readRawVarint32(buf, 0);
        StreamedStringSerializerTest.assertTrue((len == stringLen ? 1 : 0) != 0);
        StreamedStringSerializerTest.print("total len: " + buf.length);
    }

    static void checkFixedDelimited(String str) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeUTF(str);
        dout.close();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb, (OutputStream)out);
        StreamedStringSerializer.writeUTF8FixedDelimited((String)str, (WriteSession)session, (LinkedBuffer)lb);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
        byte[] b1 = bout.toByteArray();
        byte[] b2 = out.toByteArray();
        StreamedStringSerializerTest.assertEquals(b1, b2);
    }

    static void assertEquals(byte[] b1, byte[] b2) throws Exception {
        String s1 = new String(b1, "UTF-8");
        String s2 = new String(b2, "UTF-8");
        StreamedStringSerializerTest.assertEquals((String)s1, (String)s2);
    }

    static void checkAscii(String str) throws Exception {
        byte[] builtin = StringSerializerTest.BUILT_IN_SERIALIZER.serialize(str);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb, (OutputStream)out);
        StreamedStringSerializer.writeAscii((String)str, (WriteSession)session, (LinkedBuffer)lb);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
        StreamedStringSerializerTest.assertTrue((builtin.length == session.size ? 1 : 0) != 0);
        byte[] buffered = out.toByteArray();
        StreamedStringSerializerTest.assertTrue((builtin.length == buffered.length ? 1 : 0) != 0);
        String strBuiltin = new String(builtin, "ASCII");
        String strBuffered = new String(buffered, "ASCII");
        StreamedStringSerializerTest.assertEquals((String)strBuiltin, (String)strBuffered);
        StreamedStringSerializerTest.print(strBuiltin);
        StreamedStringSerializerTest.print("len: " + builtin.length);
    }

    static void check(String str) throws Exception {
        byte[] builtin = StringSerializerTest.BUILT_IN_SERIALIZER.serialize(str);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedBuffer lb = new LinkedBuffer(256);
        WriteSession session = new WriteSession(lb, (OutputStream)out);
        StreamedStringSerializer.writeUTF8((String)str, (WriteSession)session, (LinkedBuffer)lb);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)lb);
        StreamedStringSerializerTest.assertTrue((builtin.length == session.size ? 1 : 0) != 0);
        byte[] buffered = out.toByteArray();
        StreamedStringSerializerTest.assertTrue((builtin.length == buffered.length ? 1 : 0) != 0);
        String strBuiltin = new String(builtin, "UTF-8");
        String strBuffered = new String(buffered, "UTF-8");
        StreamedStringSerializerTest.assertEquals((String)strBuiltin, (String)strBuffered);
        StreamedStringSerializerTest.print(strBuiltin);
        StreamedStringSerializerTest.print("len: " + builtin.length);
    }

    public void testMultipleLargeStringsExceedingBufferSize() throws Exception {
        LinkedBuffer buffer = LinkedBuffer.allocate((int)256);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WriteSession session = new WriteSession(buffer, (OutputStream)out);
        String utf8OneByte = this.repeatChar('a', 1024);
        String utf8TwoBytes = this.repeatChar('\u07ff', 512);
        String utf8ThreeBytes = this.repeatChar('\u0800', 341);
        StreamedStringSerializerTest.writeToSession(utf8OneByte, utf8TwoBytes, utf8ThreeBytes, session, false);
        StreamedStringSerializerTest.assertTrue((session.tail == session.head ? 1 : 0) != 0);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
        buffer.clear();
        byte[] data = out.toByteArray();
        LinkedBuffer buffer2 = LinkedBuffer.allocate((int)256);
        WriteSession session2 = new WriteSession(buffer2);
        StreamedStringSerializerTest.writeToSession(utf8OneByte, utf8TwoBytes, utf8ThreeBytes, session2, false);
        byte[] data2 = session2.toByteArray();
        StreamedStringSerializerTest.assertEquals((String)StringSerializer.STRING.deser((byte[])data), (String)StringSerializer.STRING.deser((byte[])data2));
    }

    public void testMultipleLargeStringsExceedingBufferSizeDelimited() throws Exception {
        LinkedBuffer buffer = LinkedBuffer.allocate((int)256);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WriteSession session = new WriteSession(buffer, (OutputStream)out);
        String utf8OneByte = this.repeatChar('a', 1024);
        String utf8TwoBytes = this.repeatChar('\u07ff', 512);
        String utf8ThreeBytes = this.repeatChar('\u0800', 341);
        StreamedStringSerializerTest.writeToSession(utf8OneByte, utf8TwoBytes, utf8ThreeBytes, session, true);
        StreamedStringSerializerTest.assertTrue((session.tail == session.head ? 1 : 0) != 0);
        StreamedStringSerializerTest.assertTrue((session.tail.next != null ? 1 : 0) != 0);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
        buffer.clear();
        byte[] data = out.toByteArray();
        LinkedBuffer buffer2 = LinkedBuffer.allocate((int)256);
        WriteSession session2 = new WriteSession(buffer2);
        StreamedStringSerializerTest.writeToSession(utf8OneByte, utf8TwoBytes, utf8ThreeBytes, session2, true);
        byte[] data2 = session2.toByteArray();
        StreamedStringSerializerTest.assertEquals((String)StringSerializer.STRING.deser((byte[])data), (String)StringSerializer.STRING.deser((byte[])data2));
    }

    static void writeToSession(String str1, String str2, String str3, WriteSession session, boolean delimited) throws IOException {
        if (delimited) {
            session.tail = session.sink.writeStrUTF8VarDelimited(str1, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str1, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str2, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str2, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str3, session, session.tail);
            session.tail = session.sink.writeStrUTF8VarDelimited(str3, session, session.tail);
        } else {
            session.tail = session.sink.writeStrUTF8(str1, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str1, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str2, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str2, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str3, session, session.tail);
            session.tail = session.sink.writeStrUTF8(str3, session, session.tail);
        }
    }

    static void print(String msg) {
    }
}

