/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.servlet.javax;

import io.prometheus.metrics.exporter.common.PrometheusHttpExchange;
import io.prometheus.metrics.exporter.common.PrometheusHttpRequest;
import io.prometheus.metrics.exporter.common.PrometheusHttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpExchangeAdapter
implements PrometheusHttpExchange {
    private final Request request;
    private final Response response;

    public HttpExchangeAdapter(HttpServletRequest request, HttpServletResponse response) {
        this.request = new Request(request);
        this.response = new Response(response);
    }

    public PrometheusHttpRequest getRequest() {
        return this.request;
    }

    public PrometheusHttpResponse getResponse() {
        return this.response;
    }

    public void handleException(IOException e) throws IOException {
        throw e;
    }

    public void handleException(RuntimeException e) {
        throw e;
    }

    public void close() {
    }

    public static class Request
    implements PrometheusHttpRequest {
        private final HttpServletRequest request;

        public Request(HttpServletRequest request) {
            this.request = request;
        }

        public String getQueryString() {
            return this.request.getQueryString();
        }

        public Enumeration<String> getHeaders(String name) {
            return this.request.getHeaders(name);
        }

        public String getMethod() {
            return this.request.getMethod();
        }

        public String getRequestPath() {
            String pathInfo;
            String servletPath;
            StringBuilder uri = new StringBuilder();
            String contextPath = this.request.getContextPath();
            if (contextPath.startsWith("/")) {
                uri.append(contextPath);
            }
            if ((servletPath = this.request.getServletPath()).startsWith("/")) {
                uri.append(servletPath);
            }
            if ((pathInfo = this.request.getPathInfo()) != null) {
                uri.append(pathInfo);
            }
            return uri.toString();
        }
    }

    public static class Response
    implements PrometheusHttpResponse {
        private final HttpServletResponse response;

        public Response(HttpServletResponse response) {
            this.response = response;
        }

        public void setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        public OutputStream sendHeadersAndGetBody(int statusCode, int contentLength) throws IOException {
            if (this.response.getHeader("Content-Length") == null && contentLength > 0) {
                this.response.setContentLength(contentLength);
            }
            this.response.setStatus(statusCode);
            return this.response.getOutputStream();
        }
    }
}

