/*
 * Decompiled with CFR 0.152.
 */
package io.preboot.eventbus;

import io.preboot.eventbus.EventPublisher;
import io.preboot.eventbus.ExceptionIfNoHandler;
import io.preboot.eventbus.LocalEventHandlerRepository;
import io.preboot.eventbus.NoEventHandlerException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEventPublisher
implements EventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalEventPublisher.class);
    private final LocalEventHandlerRepository localEventHandlerRepository;

    public LocalEventPublisher(LocalEventHandlerRepository localEventHandlerRepository) {
        this.localEventHandlerRepository = localEventHandlerRepository;
    }

    @Override
    public <T> void publish(T event) {
        if (this.localEventHandlerRepository.isHandlerMissing(event)) {
            if (event.getClass().getAnnotation(ExceptionIfNoHandler.class) != null) {
                throw new NoEventHandlerException(event);
            }
            log.warn("No handler found for event: {}", event);
            return;
        }
        this.localEventHandlerRepository.publish(event);
    }
}

