/*
 * Decompiled with CFR 0.152.
 */
package io.preboot.eventbus;

import io.preboot.eventbus.EventHandler;
import io.preboot.eventbus.EventPublishException;
import io.preboot.eventbus.GenericEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LocalEventHandlerRepository
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(LocalEventHandlerRepository.class);
    private final Map<Class<?>, List<HandlerMethod>> eventHandlers = new HashMap();
    private final ReentrantLock initializationLock = new ReentrantLock();
    private volatile boolean initialized = false;
    private ApplicationContext applicationContext;

    public LocalEventHandlerRepository(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHandlers() {
        if (this.initialized) {
            return;
        }
        this.initializationLock.lock();
        try {
            String[] beanNames;
            if (this.initialized) {
                return;
            }
            for (String beanName : beanNames = this.applicationContext.getBeanDefinitionNames()) {
                try {
                    Object bean = this.applicationContext.getBean(beanName);
                    this.scanBean(bean);
                }
                catch (Exception e) {
                    log.debug("Could not process bean {} for event handlers: {}", (Object)beanName, (Object)e.getMessage());
                }
            }
            this.initialized = true;
        }
        finally {
            this.initializationLock.unlock();
        }
    }

    private void scanBean(Object bean) {
        Class<?> targetClass = bean.getClass();
        boolean isNotPublicClass = !Modifier.isPublic(targetClass.getModifiers());
        for (Method method : targetClass.getMethods()) {
            EventHandler annotation = method.getAnnotation(EventHandler.class);
            if (annotation == null) continue;
            if (isNotPublicClass) {
                log.error("Skipping event handler registration for non-public class: {}. Event handlers must be in public classes.", (Object)targetClass.getName());
                return;
            }
            if (method.getParameterCount() != 1) {
                log.warn("Event handler method {} must have exactly one parameter", (Object)method.getName());
                continue;
            }
            Class<?> eventType = method.getParameterTypes()[0];
            Class<?> typeParameter = annotation.typeParameter();
            if (typeParameter == Void.TYPE) {
                typeParameter = null;
            }
            HandlerMethod handlerMethod = new HandlerMethod(bean, method, annotation.priority(), typeParameter);
            this.eventHandlers.computeIfAbsent(eventType, k -> new ArrayList()).add(handlerMethod);
            this.eventHandlers.get(eventType).sort((h1, h2) -> Integer.compare(h2.priority(), h1.priority()));
            String typeParamInfo = typeParameter != null ? " with type parameter " + typeParameter.getName() : "";
            log.info("Registered event handler method: {}.{} for event type: {}{}", new Object[]{bean.getClass().getName(), method.getName(), eventType.getName(), typeParamInfo});
        }
    }

    public void publish(Object event) {
        this.initializeHandlers();
        Class<?> eventType = event.getClass();
        List<HandlerMethod> handlers = this.eventHandlers.get(eventType);
        if (handlers != null) {
            for (HandlerMethod handler : handlers) {
                try {
                    if (handler.typeParameter() != null && event instanceof GenericEvent) {
                        GenericEvent genericEvent = (GenericEvent)event;
                        if (!handler.typeParameter().isInstance(genericEvent.getTypeParameter())) continue;
                    }
                    handler.method().invoke(handler.instance(), event);
                    log.debug("Event {} handled by {}.{}", new Object[]{eventType.getName(), handler.instance().getClass().getName(), handler.method().getName()});
                }
                catch (Exception e) {
                    throw new EventPublishException(e);
                }
            }
        }
    }

    public <T> boolean isHandlerMissing(T event) {
        this.initializeHandlers();
        Class<?> eventType = event.getClass();
        List<HandlerMethod> handlers = this.eventHandlers.get(eventType);
        return handlers == null || handlers.isEmpty();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private record HandlerMethod(Object instance, Method method, int priority, Class<?> typeParameter) {
    }
}

